/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class AGAVEOligoPainter
extends AGAVEPainter {
    private static final Color colorNoType = Color.black;
    private static final String DEFAULT_LEGEND_LABEL = "Standard oligo";
    private static final Color colorSubstandardType = Color.red;
    private static final String SUBSTANDARD_LEGEND_LABEL = "Substandard oligo";
    private static final String SUBSTANDARD_ATTR = "substandard";
    private static final Color colorMultiSubstandardType = Color.orange;
    private static final String MULTI_SUBSTANDARD_LEGEND_LABEL = "Substandard multi-site oligo";
    private static Color colorMultibindingType = null;
    private static final String MULTIBINDING_LEGEND_LABEL = "Multi-site binding oligo";
    private static final String MULTIBINDING_ATTR = "multibinding";
    private Image noTypeImage;
    private Image substandardImage;
    private Image multiSubstandardImage;
    private Image multibindingImage;
    private LaneManager laneMgr;
    private boolean laneDrawn;

    public int getPriority() {
        return 80;
    }

    public AGAVEOligoPainter(LaneManager laneManager) {
        this.laneMgr = laneManager;
        if (colorMultibindingType == null) {
            colorMultibindingType = new Color(128, 128, 0);
        }
        this.noTypeImage = new BufferedImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT, 1);
        Graphics graphics = this.noTypeImage.getGraphics();
        graphics.setColor(colorNoType);
        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        this.substandardImage = new BufferedImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT, 1);
        graphics = this.substandardImage.getGraphics();
        graphics.setColor(colorSubstandardType);
        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        this.multiSubstandardImage = new BufferedImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT, 1);
        graphics = this.substandardImage.getGraphics();
        graphics.setColor(colorMultiSubstandardType);
        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        this.multibindingImage = new BufferedImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT, 1);
        graphics = this.multibindingImage.getGraphics();
        graphics.setColor(colorMultibindingType);
        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        Object object;
        int n = dTDElementInstance.getTarget();
        int n2 = abstractLinearGraphics.getLOD();
        if (n == -1) {
            System.err.println("Ooops.  parent of " + dTDElementInstance.getLocalName() + "was not a target");
            return;
        }
        int[] nArray = abstractLinearGraphics.isInTextMode() ? this.getOrigFeatureRange(dTDElementInstance) : this.getFeatureRange(dTDElementInstance);
        boolean bl = nArray[1] < nArray[0];
        int n3 = bl ? nArray[1] : nArray[0];
        int n4 = bl ? nArray[0] : nArray[1];
        int n5 = ((BluejayDTDElementInstance)dTDElementInstance).getSlaveNum();
        ComparisonPool comparisonPool = abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool();
        if (n5 != 0) {
            object = comparisonPool.getSeqsFromPool().elementAt(n5);
            double[] dArray = this.laneMgr.getLane("slave_neg_oligo_tick" + Integer.toString(n5), n2);
            if (!((Genome)object).isOligoLaneDrawn() && dArray != null) {
                this.drawLaneLine(abstractLinearGraphics, n, dArray[0]);
                ((Genome)object).setOligoLaneDrawn(true);
            }
        } else if (!this.laneDrawn) {
            double[] dArray = this.laneMgr.getLane("Negative oligo lane", n2);
            if (dArray != null) {
                this.drawLaneLine(abstractLinearGraphics, n, dArray[0]);
            }
            this.laneDrawn = true;
        }
        object = dTDElementInstance.getAttribute("label");
        boolean bl2 = ((TargetAppearance)abstractLinearGraphics.getTargetAppearances().elementAt(n)).isReverseComplement();
        Color color = abstractLinearGraphics.getColor();
        Color color2 = colorNoType;
        Image image = null;
        String string = DEFAULT_LEGEND_LABEL;
        if (dTDElementInstance.getAttribute(SUBSTANDARD_ATTR) != null && !dTDElementInstance.getAttribute(SUBSTANDARD_ATTR).equals("")) {
            if (dTDElementInstance.getAttribute(MULTIBINDING_ATTR) != null && !dTDElementInstance.getAttribute(MULTIBINDING_ATTR).equals("")) {
                image = this.multiSubstandardImage;
                string = MULTI_SUBSTANDARD_LEGEND_LABEL;
                color2 = colorMultiSubstandardType;
            } else {
                image = this.substandardImage;
                string = SUBSTANDARD_LEGEND_LABEL;
                color2 = colorSubstandardType;
            }
        } else if (dTDElementInstance.getAttribute(MULTIBINDING_ATTR) != null && !dTDElementInstance.getAttribute(MULTIBINDING_ATTR).equals("")) {
            image = this.multibindingImage;
            string = MULTIBINDING_LEGEND_LABEL;
            color2 = colorMultibindingType;
        } else {
            image = this.noTypeImage;
        }
        if (Debug.legend) {
            if (SUBSTANDARD_LEGEND_LABEL.equals(string)) {
                abstractLinearGraphics.getLegend().addItem(image, string, "//agave:oligonucleotide[@agave:substandard=true]", dTDElementInstance.getXPointer(), color2);
            } else if (MULTI_SUBSTANDARD_LEGEND_LABEL.equals(string)) {
                abstractLinearGraphics.getLegend().addItem(image, string, "//agave:oligonucleotide[@agave:multibinding=true and @agave:substandard]", dTDElementInstance.getXPointer(), color2);
            } else if (MULTIBINDING_LEGEND_LABEL.equals(string)) {
                abstractLinearGraphics.getLegend().addItem(image, string, "//agave:oligonucleotide[@agave:multibinding=true]", dTDElementInstance.getXPointer(), color2);
            } else {
                abstractLinearGraphics.getLegend().addItem(image, DEFAULT_LEGEND_LABEL, "//agave:gene[not(@agave:multibinding) and not(@agave:substandard)]", dTDElementInstance.getXPointer(), color2);
            }
        }
        double d = abstractLinearGraphics.getTarget(n).getScale();
        abstractLinearGraphics.setColor(color2);
        if (n2 == 80 && d <= 1.0) {
            int n6;
            double[] dArray;
            double[] dArray2;
            boolean bl3;
            boolean bl4 = bl3 = bl == bl2;
            if (bl3) {
                if (n5 != 0) {
                    dArray2 = this.laneMgr.getLane("slave_pos_oligo_tick" + Integer.toString(n5), n2);
                    dArray = this.laneMgr.getLane("slave_pos_oligo_label" + Integer.toString(n5), n2);
                } else {
                    dArray2 = this.laneMgr.getLane("Positive oligo lane", n2);
                    dArray = this.laneMgr.getLane("Positive oligo label lane", n2);
                }
                n6 = 30;
            } else {
                if (n5 != 0) {
                    dArray2 = this.laneMgr.getLane("slave_neg_oligo_tick" + Integer.toString(n5), n2);
                    dArray = this.laneMgr.getLane("slave_neg_oligo_label" + Integer.toString(n5), n2);
                } else {
                    dArray2 = this.laneMgr.getLane("Negative oligo lane", n2);
                    dArray = this.laneMgr.getLane("Negative oligo label lane", n2);
                }
                n6 = 40;
            }
            if (dArray2 == null) {
                return;
            }
            abstractLinearGraphics.fillRect(n, n3, n4, dArray2[0], dArray2[1]);
            double d2 = (double)(n4 - n3 + 1) * d;
            Object object2 = object;
            abstractLinearGraphics.drawString(n, (String)object2, null, (n3 + n4) / 2, dArray[0], dArray[1], n6);
        }
        abstractLinearGraphics.setColor(color);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n;
        String[] stringArray;
        int n2 = abstractLinearGraphics.getLOD();
        if (n2 == 80) {
            stringArray = new String[]{"Positive oligo lane", "Negative oligo lane", "Positive oligo label lane", "Negative oligo label lane"};
            AGAVEOligoPainter.requestLanes(this.laneMgr, this, n2, stringArray);
            n = abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool().getPoolSize();
            if (ComparisonMenuManager.isComparison && n > 1) {
                for (int i = 1; i < n; ++i) {
                    String[] stringArray2 = new String[]{"slave_neg_oligo_label" + Integer.toString(i), "slave_pos_oligo_label" + Integer.toString(i), "slave_neg_oligo_tick" + Integer.toString(i), "slave_pos_oligo_tick" + Integer.toString(i)};
                    AGAVEOligoPainter.requestLanes(this.laneMgr, this, n2, stringArray2);
                }
            }
        }
        this.laneDrawn = false;
        stringArray = abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool();
        if (ComparisonMenuManager.isComparison && stringArray.getPoolSize() > 1) {
            for (n = 1; n < stringArray.getPoolSize(); ++n) {
                Genome genome = stringArray.getSeqsFromPool().elementAt(n);
                genome.setOligoLaneDrawn(false);
            }
        }
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return "Oligonucleotide probe";
    }
}

