/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractSequencePainter;
import ca.ucalgary.bluejay.gui.painter.LaneGetter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BasicPainter
implements AbstractLinearPainter {
    protected static Hashtable classColorMapping;
    private static Logger logger;
    public static int APPEARFRAME;

    public int getPriority() {
        return 70;
    }

    public String getSequence(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
        if (dTDElementInstance == null) {
            return null;
        }
        int[] nArray = this.getFeatureRange(dTDElementInstance);
        if (nArray == null) {
            return null;
        }
        int n = dTDElementInstance.getTarget();
        if (n == -1) {
            return null;
        }
        LinearTarget linearTarget = abstractLinearGraphics.getTarget(n);
        if (linearTarget == null) {
            return null;
        }
        MaskPainter maskPainter = linearTarget.getMaskPainter();
        if (maskPainter == null) {
            return null;
        }
        DTDElementInstance dTDElementInstance2 = maskPainter.getSequenceElement();
        if (dTDElementInstance2 == null) {
            return null;
        }
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance2.getPainter();
        if (abstractLinearPainter == null || !(abstractLinearPainter instanceof AbstractSequencePainter)) {
            return null;
        }
        return ((AbstractSequencePainter)abstractLinearPainter).getSequence(dTDElementInstance2, nArray[0], nArray[1]);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        if (!dTDElementInstance.isModelVisible()) {
            return;
        }
        NodeList nodeList = dTDElementInstance.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !(node instanceof DTDElementInstance) || ((DTDElementInstance)node).getPainter() == null) continue;
                ((DTDElementInstance)node).getPainter().updateLegendItem(abstractLinearGraphics, (DTDElementInstance)node);
            }
        }
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return "";
    }

    public void normalizeText(DTDElementInstance dTDElementInstance) {
        if (dTDElementInstance.hasChildNodes()) {
            Pattern pattern = Pattern.compile("[ \t\r\n]");
            StringBuffer stringBuffer = new StringBuffer(1000000);
            for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node node2 = node;
                int n = 0;
                while (node != null && (node instanceof Text || node instanceof CDATASection)) {
                    stringBuffer.append(pattern.matcher(node.getNodeValue()).replaceAll(""));
                    ++n;
                    node = node.getNextSibling();
                }
                if (n > 2) {
                    try {
                        node2.setNodeValue(stringBuffer.toString());
                        node = node2;
                        logger.debug(">>>>>>>>>>>>>>>>Replacing DOM node, new length " + stringBuffer.length());
                        Node node3 = node2.getNextSibling();
                        while (n > 1) {
                            Node node4 = node3.getNextSibling();
                            dTDElementInstance.removeChild(node3);
                            node3 = node4;
                            --n;
                        }
                    }
                    catch (Exception exception) {
                        logger.warn("Could NOT change DOM, BasicPainter.normalizeText() attempt to streamline the in-memory document representation failed");
                        System.out.println("Could NOT change DOM, BasicPainter.normalizeText() attempt to streamline the in-memory document representation failed");
                        return;
                    }
                }
                stringBuffer.setLength(0);
                if (node == null) break;
            }
        }
    }

    public void drawLaneLine(AbstractLinearGraphics abstractLinearGraphics, int n, double d) {
        try {
            Vector vector = abstractLinearGraphics.getVisiblePositionRange(n);
            if (vector == null || vector.size() == 0) {
                logger.debug("PG: No lane visible to paint");
            } else {
                for (int i = 0; i < vector.size(); ++i) {
                    int[] nArray = (int[])vector.elementAt(i);
                    abstractLinearGraphics.drawLine(n, nArray[0], nArray[1], d, d);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Error: Could not draw lane line: " + exception.getMessage());
            System.err.println("Error: Could not draw lane line: " + exception);
            exception.printStackTrace();
        }
    }

    public int[] getFeatureRange(DTDElementInstance dTDElementInstance) {
        return null;
    }

    public int[] getOrigFeatureRange(DTDElementInstance dTDElementInstance) {
        return null;
    }

    public void setFeatureRange(DTDElementInstance dTDElementInstance, int n, int n2) {
        throw new IllegalArgumentException("Tried to set the feature range for an element that does not have a range");
    }

    public Element getElementByTagName(Element element, String string) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !node.getNodeName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    public void preProcess(AbstractLinearGraphics abstractLinearGraphics, MaskPainter maskPainter, DTDElementInstance dTDElementInstance) {
        NodeList nodeList;
        if (!dTDElementInstance.isModelVisible()) {
            return;
        }
        int[] nArray = this.getFeatureRange(dTDElementInstance);
        if (nArray != null) {
            maskPainter.addFeature(dTDElementInstance, nArray[0], nArray[1]);
        }
        if ((nodeList = dTDElementInstance.getChildNodes()) != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !(node instanceof DTDElementInstance) || ((DTDElementInstance)node).getPainter() == null) continue;
                ((DTDElementInstance)node).getPainter().preProcess(abstractLinearGraphics, maskPainter, (DTDElementInstance)node);
            }
        }
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
    }

    public String getChildNodeText(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            System.err.println("Warning: " + element + " element did not contain a " + string + " child");
            return null;
        }
        if (!((Element)nodeList.item(0) instanceof Element)) {
            System.err.println("Warning: " + element + " element child " + string + " was not of type Element as expected");
            return null;
        }
        Element element2 = (Element)nodeList.item(0);
        element2.normalize();
        Node node = element2.getFirstChild();
        if (node == null) {
            System.err.println("Warning: child " + string + " of " + element + " did not contain text");
            return null;
        }
        return node.getNodeValue();
    }

    public static void requestLanes(LaneManager laneManager, LaneGetter laneGetter, int n, String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray = laneManager.getLane(stringArray[i], n);
            if (dArray != null) continue;
            laneManager.addLane(stringArray[i], n, laneGetter.getLaneNonStatic(n, stringArray[i]));
        }
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        if (dTDElementInstance == null) {
            return null;
        }
        return dTDElementInstance.getLocalName();
    }

    public String getDescription(DTDElementInstance dTDElementInstance) {
        return this.getToolTip(dTDElementInstance);
    }

    public void setDescription(DTDElementInstance dTDElementInstance, String string) throws Exception {
        throw new Exception("Setting of descriptions not implemented for basic features,the setDescription method must be overwritten");
    }

    public boolean isDescriptionEditable(DTDElementInstance dTDElementInstance) {
        return false;
    }

    public String getPrimaryID(DTDElementInstance dTDElementInstance) {
        return null;
    }

    public String[] getIDs(DTDElementInstance dTDElementInstance) {
        return null;
    }

    static {
        logger = Logger.getLogger(BasicPainter.class);
    }
}

