/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractSequencePainter;
import ca.ucalgary.bluejay.gui.painter.BasicPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.painter.LinePlotPainter;
import ca.ucalgary.bluejay.gui.util.REBASEParser;
import java.awt.Color;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;

public abstract class BasicSequencePainter
extends BasicPainter
implements AbstractSequencePainter {
    public static final String GCLocation = "GCLocation";
    public static final String AGLocation = "AGLocation";
    public static final String GCSkewLocation = "GCSkewLocation";
    private LinePlotPainter gc_plotter;
    private LinePlotPainter ag_plotter;
    private LinePlotPainter gcSkew_plotter;
    private double[] gc_pct_data = null;
    private double[] ag_pct_data = null;
    private double[] gcSkew_pct_data = null;
    private LaneManager laneMgr;
    private int LOD;
    private static Hashtable cleavageRecogs;
    private static TreeMap cleavageColors;
    private static Vector shownEnzymes;
    private static boolean showCleavageLanesSeparately;
    private final char g = (char)71;
    private final char c = (char)67;
    private Character baseG;
    private Character baseC;
    private int windowSize;
    private int stepSize;
    private TreeMap normSkewMap;
    private String sequence;
    int len;
    double gcSkew_min;
    double gcSkew_max;

    public BasicSequencePainter(LaneManager laneManager) {
        this.laneMgr = laneManager;
        this.ag_plotter = new LinePlotPainter(this.laneMgr);
        this.ag_plotter.setFillGraphEnabled(true);
        this.ag_plotter.setFillGraphColor(Color.red);
        this.ag_plotter.setBaseLineEnabled(true);
        this.ag_plotter.setBaseLineLabelEnabled(true);
        this.ag_plotter.setBaseLineValue(50.0);
        this.ag_plotter.setBaseLineColor(Color.pink);
        this.ag_plotter.setRangeLinesEnabled(true);
        this.ag_plotter.setRangeLinesColor(Color.pink);
        this.ag_plotter.setRangeLinesColor(Color.pink);
        this.gc_plotter = new LinePlotPainter(this.laneMgr);
        this.gc_plotter.setFillGraphEnabled(true);
        this.gc_plotter.setFillGraphColor(Color.black);
        this.gc_plotter.setAverageLineEnabled(true);
        this.gc_plotter.setAverageLineColor(Color.black);
        this.gc_plotter.setAverageLabelEnabled(true);
        this.gc_plotter.setRangeLinesEnabled(true);
        this.gc_plotter.setRangeLinesColor(Color.gray);
        this.gcSkew_plotter = new LinePlotPainter(this.laneMgr);
        this.gcSkew_plotter.setFillGraphEnabled(true);
        this.gcSkew_plotter.setFillGraphColor(Color.blue);
        this.gcSkew_plotter.setAverageLineEnabled(true);
        this.gcSkew_plotter.setAverageLineColor(Color.magenta);
        this.gcSkew_plotter.setAverageLabelEnabled(true);
        this.gcSkew_plotter.setRangeLinesEnabled(true);
        this.gcSkew_plotter.setRangeLinesColor(Color.green);
    }

    public abstract String getSequence(DTDElementInstance var1);

    public String getSequence(DTDElementInstance dTDElementInstance, int n, int n2) throws IndexOutOfBoundsException {
        String string;
        boolean bl;
        boolean bl2 = bl = n > n2;
        if (bl) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if ((string = this.getSequence(dTDElementInstance)) == null) {
            return null;
        }
        String string2 = string.substring(n - 1, n2);
        if (bl) {
            char[] cArray = string2.toCharArray();
            block16: for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case 'A': 
                    case 'a': {
                        cArray[i] = 116;
                        continue block16;
                    }
                    case 'C': 
                    case 'c': {
                        cArray[i] = 103;
                        continue block16;
                    }
                    case 'G': 
                    case 'g': {
                        cArray[i] = 116;
                        continue block16;
                    }
                    case 'T': 
                    case 't': {
                        cArray[i] = 97;
                        continue block16;
                    }
                    case 'S': 
                    case 's': {
                        cArray[i] = 119;
                        continue block16;
                    }
                    case 'W': 
                    case 'w': {
                        cArray[i] = 115;
                        continue block16;
                    }
                    case 'Y': 
                    case 'y': {
                        cArray[i] = 114;
                        continue block16;
                    }
                    case 'R': 
                    case 'r': {
                        cArray[i] = 121;
                        continue block16;
                    }
                    case 'K': 
                    case 'k': {
                        cArray[i] = 77;
                        continue block16;
                    }
                    case 'M': 
                    case 'm': {
                        cArray[i] = 107;
                        continue block16;
                    }
                    case 'B': 
                    case 'b': {
                        cArray[i] = 118;
                        continue block16;
                    }
                    case 'V': 
                    case 'v': {
                        cArray[i] = 98;
                        continue block16;
                    }
                    case 'D': 
                    case 'd': {
                        cArray[i] = 104;
                        continue block16;
                    }
                    case 'H': 
                    case 'h': {
                        cArray[i] = 100;
                        continue block16;
                    }
                    default: {
                        cArray[i] = 110;
                    }
                }
            }
            string2 = new String(cArray);
        }
        return string2;
    }

    public int getPriority() {
        return 60;
    }

    private static Hashtable getCleavageRecogs(int n) {
        try {
            cleavageRecogs = n == 1705 ? REBASEParser.getCommonEnzymes(10) : (n == 46487 ? REBASEParser.getCommonEnzymes(1) : REBASEParser.getEnzymes());
        }
        catch (Exception exception) {
            System.err.println("Failed to load REBASE for restriction enzyme tasks.");
            exception.printStackTrace();
            cleavageRecogs = new Hashtable();
        }
        return cleavageRecogs;
    }

    public void preProcess(AbstractLinearGraphics abstractLinearGraphics, MaskPainter maskPainter, DTDElementInstance dTDElementInstance) {
        if (!dTDElementInstance.isModelVisible()) {
            return;
        }
        int[] nArray = this.getFeatureRange(dTDElementInstance);
        if (nArray != null) {
            maskPainter.addFeature(dTDElementInstance, nArray[0], nArray[1]);
        }
    }

    public int[] getFeatureRange(DTDElementInstance dTDElementInstance) {
        String string = this.getSequence(dTDElementInstance);
        if (string == null) {
            return null;
        }
        return new int[]{1, string.length()};
    }

    public static void setSeparateCleavageLanes(boolean bl) {
        showCleavageLanesSeparately = bl;
    }

    public static boolean isSeparateCleavageLanes() {
        return showCleavageLanesSeparately;
    }

    public static void setShownRestrictionEnzymes(Vector vector) {
        shownEnzymes = vector;
    }

    public static String[] getShownRestrictionEnzymes() {
        String[] stringArray = new String[shownEnzymes.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)shownEnzymes.elementAt(i);
        }
        return stringArray;
    }

    public static String[] getRestrictionEnzymes(int n) {
        Object[] objectArray = BasicSequencePainter.getCleavageRecogs(n).keySet().toArray();
        Object[] objectArray2 = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = (String)objectArray[i];
        }
        Arrays.sort(objectArray2);
        return objectArray2;
    }

    protected void setLaneManager(LaneManager laneManager) {
        if (laneManager == this.laneMgr) {
            return;
        }
        this.laneMgr = laneManager;
        this.ag_plotter.setLaneManager(laneManager);
        this.gc_plotter.setLaneManager(laneManager);
        this.gcSkew_plotter.setLaneManager(laneManager);
    }

    protected LaneManager getLaneManager() {
        return this.laneMgr;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        String string = this.getSequence(dTDElementInstance);
        int n = dTDElementInstance.getSlaveNum();
        int n2 = dTDElementInstance.getTarget();
        TargetAppearance targetAppearance = (TargetAppearance)abstractLinearGraphics.getTargetAppearances().elementAt(n2);
        boolean bl = targetAppearance.isReverseComplement();
        boolean bl2 = targetAppearance.getShape() == 112;
        this.LOD = abstractLinearGraphics.getLOD();
        if (abstractLinearGraphics.isCleavageShown()) {
            this.drawCleavageSites(abstractLinearGraphics, dTDElementInstance, string, bl, bl2);
        }
        if (this.LOD == 80) {
            if (abstractLinearGraphics.isAGLevelShown() || abstractLinearGraphics.isGCLevelShown() || abstractLinearGraphics.isGCSkewShown()) {
                this.calculateSeqStats(dTDElementInstance, string, bl, bl2);
                if (abstractLinearGraphics.isGCLevelShown()) {
                    if (n != 0) {
                        this.paintLinePlot(abstractLinearGraphics, dTDElementInstance, this.gc_plotter, "slave_gc_location" + Integer.toString(n), this.LOD);
                    } else {
                        this.paintLinePlot(abstractLinearGraphics, dTDElementInstance, this.gc_plotter, GCLocation, this.LOD);
                    }
                }
                if (abstractLinearGraphics.isAGLevelShown()) {
                    if (n != 0) {
                        this.paintLinePlot(abstractLinearGraphics, dTDElementInstance, this.ag_plotter, "slave_ag_location" + Integer.toString(n), this.LOD);
                    } else {
                        this.paintLinePlot(abstractLinearGraphics, dTDElementInstance, this.ag_plotter, AGLocation, this.LOD);
                    }
                }
                if (abstractLinearGraphics.isGCSkewShown()) {
                    if (n != 0) {
                        this.paintLinePlot(abstractLinearGraphics, dTDElementInstance, this.gcSkew_plotter, "slave_gcskew_location" + Integer.toString(n), this.LOD);
                    } else {
                        this.paintLinePlot(abstractLinearGraphics, dTDElementInstance, this.gcSkew_plotter, GCSkewLocation, this.LOD);
                    }
                }
            }
            abstractLinearGraphics.drawString("\n", "", null);
        }
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n = abstractLinearGraphics.getLOD();
        if (abstractLinearGraphics.getLOD() == 80) {
            String[] stringArray;
            if (abstractLinearGraphics.isGCLevelShown()) {
                stringArray = new String[]{GCLocation};
                BasicSequencePainter.requestLanes(this.getLaneManager(), AGAVEPainter.getInstance(), n, stringArray);
            }
            if (abstractLinearGraphics.isAGLevelShown()) {
                stringArray = new String[]{AGLocation};
                BasicSequencePainter.requestLanes(this.getLaneManager(), AGAVEPainter.getInstance(), n, stringArray);
            }
            if (abstractLinearGraphics.isGCSkewShown()) {
                stringArray = new String[]{GCSkewLocation};
                BasicSequencePainter.requestLanes(this.getLaneManager(), AGAVEPainter.getInstance(), n, stringArray);
            }
        }
        super.updateLegendItem(abstractLinearGraphics, dTDElementInstance);
    }

    private void paintLinePlot(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, LinePlotPainter linePlotPainter, String string, int n) throws Exception {
        double[] dArray = this.laneMgr.getLane(string, n);
        linePlotPainter.setLane(dArray[1], dArray[0]);
        linePlotPainter.paint(abstractLinearGraphics, dTDElementInstance);
    }

    private void drawCleavageSites(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, String string, boolean bl, boolean bl2) throws Exception {
        string = string.toLowerCase();
        System.err.println("PG: About to draw restriction sites on sequence of length " + string.length());
        int n = dTDElementInstance.getTarget();
        TargetAppearance targetAppearance = (TargetAppearance)abstractLinearGraphics.getTargetAppearances().elementAt(n);
        int n2 = targetAppearance.getMinPosition();
        int n3 = targetAppearance.getMaxPosition();
        int n4 = abstractLinearGraphics.getPositionInFocus();
        if (n4 < n2 || n4 > n3) {
            n4 = n2;
        }
        int n5 = (int)(abstractLinearGraphics.getScale() * 0.0);
        double[] dArray = this.laneMgr.getLane("Restriction enzyme lane", this.LOD);
        double[] dArray2 = this.laneMgr.getLane("Restriction enzyme label lane", this.LOD);
        Color color = abstractLinearGraphics.getColor();
        int n6 = n4;
        Hashtable hashtable = BasicSequencePainter.getCleavageRecogs(278);
        for (int i = 0; i < shownEnzymes.size(); ++i) {
            String string2 = (String)shownEnzymes.elementAt(i);
            if (!hashtable.containsKey(string2)) {
                System.err.println("PG: " + string2 + " could not be found in REBASE");
                continue;
            }
            if (showCleavageLanesSeparately) {
                String string3 = "Restriction enzyme lane " + string2;
                dArray = this.laneMgr.getLane(string3, this.LOD);
            }
            dArray[0] = dArray[0] - 0.005;
            double d = (dArray[0] + dArray[1]) / 2.0;
            boolean bl3 = d > 0.0;
            String string4 = (String)hashtable.get(string2);
            Color color2 = (Color)cleavageColors.get(string2);
            if (color2 == null) {
                color2 = Color.BLACK;
            }
            string4 = string4.replaceAll("\\^", "").toLowerCase();
            abstractLinearGraphics.setColor(color2);
            System.err.println("PG: Trying to draw " + string2 + ", cut pattern is " + string4);
            boolean bl4 = true;
            int n7 = string.indexOf(string4);
            while (n7 >= 0) {
                if (bl4) {
                    System.err.println("Drawing lane for enzyme " + string2 + " in region (" + dArray[0] + ", " + dArray[1] + ")");
                    this.drawLaneLine(abstractLinearGraphics, n, dArray[0]);
                    this.drawLaneLine(abstractLinearGraphics, n, dArray[1]);
                    double d2 = bl3 ? 999.999 : dArray[0];
                    double d3 = bl3 ? dArray[1] : -999.999;
                    int n8 = bl3 ? 30 : 40;
                    abstractLinearGraphics.setColor(color);
                    abstractLinearGraphics.drawAngledString(n, string2, null, n6, d2, d3, n8, 90.0);
                    abstractLinearGraphics.setColor(color2);
                    bl4 = false;
                    if ((n6 += n5) > n3) {
                        n6 = n6 - n3 + n2 - 1;
                    }
                }
                int n9 = 1 + n7;
                abstractLinearGraphics.drawLine(n, n9, n9, dArray[0], dArray[1]);
                n7 = string.indexOf(string4, 1 + n7);
            }
        }
        abstractLinearGraphics.setColor(color);
    }

    private void calculateSeqStats(DTDElementInstance dTDElementInstance, String string, boolean bl, boolean bl2) {
        int n;
        int n2 = string.length();
        int n3 = n2 / 50 + 1;
        this.gc_pct_data = new double[n3];
        this.ag_pct_data = new double[n3];
        double d = 100.0;
        double d2 = 0.0;
        double d3 = 100.0;
        double d4 = 0.0;
        int[] nArray = new int[10];
        int[] nArray2 = new int[10];
        int[] nArray3 = new int[10];
        int[] nArray4 = new int[5];
        int[] nArray5 = new int[5];
        int[] nArray6 = new int[5];
        for (n = 0; n < 10; ++n) {
            nArray[n] = 0;
            nArray2[n] = 0;
            nArray3[n] = 0;
        }
        n = 0;
        int n4 = 0;
        for (int i = 0; i < n2; i += 50) {
            int n5;
            int n6;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            for (n6 = 0; n6 < 50 && i + n6 < n2; ++n6) {
                n5 = string.charAt(i + n6);
                if (!bl && (n5 == 97 || n5 == 65) || bl && (n5 == 116 || n5 == 84)) {
                    ++n7;
                    continue;
                }
                if (!bl && (n5 == 99 || n5 == 67) || bl && (n5 == 103 || n5 == 71)) {
                    ++n8;
                    continue;
                }
                if ((bl || n5 != 103 && n5 != 71) && (!bl || n5 != 99 && n5 != 67)) continue;
                ++n9;
            }
            n6 = i / 50 % 10;
            n += n9 + n8;
            n4 += n9 + n7;
            n5 = (i - 250) / 50;
            if (n5 < 0) {
                if (bl2) {
                    nArray6[n5 + 5] = n9;
                    nArray5[n5 + 5] = n8;
                    nArray4[n5 + 5] = n7;
                    System.err.println("Recording left flank for circular avg index " + (n5 + 5));
                    System.err.println("g: " + nArray6[n5 + 5] + "c: " + nArray5[n5 + 5] + "a: " + nArray4[n5 + 5]);
                }
                nArray[n6] = n7;
                nArray2[n6] = n8;
                nArray3[n6] = n9;
                continue;
            }
            n -= nArray3[n6] + nArray2[n6];
            n4 -= nArray3[n6] + nArray[n6];
            nArray[n6] = n7;
            nArray2[n6] = n8;
            nArray3[n6] = n9;
            if (n5 < 5) {
                this.gc_pct_data[n5] = (double)n / (50.0 * (double)(n5 + 6)) * 100.0;
                this.ag_pct_data[n5] = (double)n4 / (50.0 * (double)(n5 + 6)) * 100.0;
            } else if (n5 == n3 - 6) {
                this.gc_pct_data[n5] = (double)n / 500.0 * 100.0;
                this.ag_pct_data[n5] = (double)n4 / 500.0 * 100.0;
                int n10 = 0;
                int n11 = 0;
                for (int j = 1; j <= 5; ++j) {
                    ++n5;
                    n6 = (i / 50 + j) % 10;
                    if (bl2) {
                        if (j == 1) {
                            for (int k = 0; k < 5; ++k) {
                                int n12 = (i / 50 + j + k) % 10;
                                n11 += nArray3[n12] + nArray2[n12];
                                n10 += nArray3[n12] + nArray[n12];
                            }
                        }
                        this.gc_pct_data[n5] = (double)(n += nArray6[j - 1] + nArray5[j - 1] - (nArray3[n6] + nArray2[n6])) / 500.0 * 100.0;
                        this.ag_pct_data[n5] = (double)(n4 += nArray6[j - 1] + nArray4[j - 1] - (nArray3[n6] + nArray[n6])) / 500.0 * 100.0;
                        this.gc_pct_data[j - 1] = this.gc_pct_data[j - 1] * ((double)(j + 4) / 10.0) + (double)n11 / ((double)(6 - j) * 50.0) * 100.0 * ((double)(6 - j) / 10.0);
                        this.ag_pct_data[j - 1] = this.ag_pct_data[j - 1] * ((double)(j + 4) / 10.0) + (double)n10 / ((double)(6 - j) * 50.0) * 100.0 * ((double)(6 - j) / 10.0);
                        n11 -= nArray3[n6] + nArray2[n6];
                        n10 -= nArray3[n6] + nArray[n6];
                        continue;
                    }
                    this.gc_pct_data[n5] = (double)(n -= nArray3[n6] + nArray2[n6]) / (50.0 * (double)(10 - j)) * 100.0;
                    this.ag_pct_data[n5] = (double)(n4 -= nArray3[n6] + nArray[n6]) / (50.0 * (double)(10 - j)) * 100.0;
                }
            } else {
                this.gc_pct_data[n5] = (double)n / 500.0 * 100.0;
                this.ag_pct_data[n5] = (double)n4 / 500.0 * 100.0;
            }
            if (this.gc_pct_data[n5] > d2) {
                d2 = this.gc_pct_data[n5];
            }
            if (this.gc_pct_data[n5] < d) {
                d = this.gc_pct_data[n5];
            }
            if (this.ag_pct_data[n5] > d4) {
                d4 = this.ag_pct_data[n5];
            }
            if (!(this.ag_pct_data[n5] < d3)) continue;
            d3 = this.ag_pct_data[n5];
        }
        this.ag_plotter.setData(this.ag_pct_data, 50, 1, d3, d4);
        this.gc_plotter.setData(this.gc_pct_data, 50, 1, d, d2);
        this.gcSkew_plotter.setData(this.createDataset(dTDElementInstance), 50, 1, this.gcSkew_min, this.gcSkew_max);
    }

    public void initSlideWindow(DTDElementInstance dTDElementInstance) {
        this.sequence = this.getSequence(dTDElementInstance);
        this.len = this.sequence.length();
        this.windowSize = this.len / 1000;
        this.stepSize = 50;
        this.baseG = new Character('G');
        this.baseC = new Character('C');
        this.gcSkew_min = 1.0;
        this.gcSkew_max = -1.0;
    }

    public double[] createDataset(DTDElementInstance dTDElementInstance) {
        this.initSlideWindow(dTDElementInstance);
        TreeMap treeMap = this.createNormSkewMap(this.sequence, this.windowSize, this.stepSize);
        double[] dArray = new double[this.len];
        for (int i = 0; i < treeMap.size(); ++i) {
            Integer n = new Integer(i);
            Double d = (Double)treeMap.get(n);
            double d2 = d;
            int n2 = i * this.stepSize;
            dArray[i] = d2;
        }
        return dArray;
    }

    public TreeMap createNormSkewMap(String string, int n, int n2) {
        TreeMap<Integer, Comparable<Character>> treeMap = new TreeMap<Integer, Comparable<Character>>();
        String string2 = this.removeJunk(string.toUpperCase());
        char[] cArray = string2.toCharArray();
        int n3 = 0;
        for (int i = 0; i < cArray.length - n; i += n2) {
            Comparable<Character> comparable;
            int n4 = 0;
            int n5 = 0;
            for (int j = i; j < i + n; ++j) {
                comparable = new Character(cArray[j]);
                if (((Character)comparable).compareTo(this.baseG) == 0) {
                    ++n4;
                    continue;
                }
                if (((Character)comparable).compareTo(this.baseC) != 0) continue;
                ++n5;
            }
            Integer n6 = new Integer(n3);
            comparable = new Double(0.0);
            if (n4 + n5 != 0) {
                comparable = new Double((double)(n4 - n5) / (double)(n4 + n5));
                if ((Double)comparable > this.gcSkew_max) {
                    this.gcSkew_max = (Double)comparable;
                }
                if ((Double)comparable < this.gcSkew_min) {
                    this.gcSkew_min = (Double)comparable;
                }
            }
            treeMap.put(n6, comparable);
            ++n3;
        }
        return treeMap;
    }

    public String removeJunk(String string) {
        int n = 0;
        int n2 = string.length();
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            cArray[n] = c;
            ++n;
        }
        return new String(cArray).trim();
    }

    static {
        showCleavageLanesSeparately = true;
        cleavageColors = new TreeMap();
        cleavageColors.put("I-CeuI", new Color(210, 105, 30));
        cleavageColors.put("XbaI", Color.RED);
        cleavageColors.put("AvrII", Color.BLUE);
        cleavageColors.put("SpeI", Color.GREEN);
        shownEnzymes = new Vector();
        shownEnzymes.add("BamHI");
        shownEnzymes.add("EcoRI");
    }
}

