/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.painter.BasicTargetPainter;
import ca.ucalgary.bluejay.gui.painter.BioseqSetPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import java.awt.Color;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BioseqPainter
extends BasicTargetPainter {
    private LaneManager laneMgr;
    private static Logger logger = Logger.getLogger(BioseqPainter.class);

    public BioseqPainter(LaneManager laneManager, VisibilityManager visibilityManager) {
        super(laneManager, visibilityManager);
        this.setBackboneFillColor(Color.yellow);
        this.laneMgr = laneManager;
    }

    public String getPrimaryID(DTDElementInstance dTDElementInstance) {
        String string = this.getChildNodeText(dTDElementInstance, "name");
        if (string == null || string.length() == 0) {
            return super.getPrimaryID(dTDElementInstance);
        }
        return string;
    }

    public LinearTarget createTarget(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
        try {
            int[] nArray = this.getFeatureRange(dTDElementInstance);
            int n = nArray[1];
            LinearTarget linearTarget = this.createTarget(abstractLinearGraphics, dTDElementInstance, nArray[0], nArray[1] - nArray[0] + 1, false);
            logger.debug("got to after bioseq addtarget");
            abstractLinearGraphics.drawString("\n", "", null);
        }
        catch (Exception exception) {
            logger.warn("Could not create target for AGAVE Contig: " + exception);
        }
        return this.target;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        try {
            int[] nArray = this.getFeatureRange(dTDElementInstance);
            int n = nArray[1];
            if (this.maskPainter != null) {
                Vector vector = abstractLinearGraphics.getTargetAppearances();
                if (vector.size() == 0) {
                    this.maskPainter.paint(abstractLinearGraphics);
                } else {
                    logger.debug("PG: Calling paint for target element for final visualization (target is set)");
                    this.maskPainter.paint(abstractLinearGraphics);
                }
            } else {
                logger.warn("PG: There is no MaskPainter!!!\n");
            }
        }
        catch (Exception exception) {
            logger.warn("\n\nQUIT PAINTING BioSeq");
            exception.printStackTrace();
            throw exception;
        }
    }

    public int[] getFeatureRange(DTDElementInstance dTDElementInstance) {
        int[] nArray = new int[2];
        String string = this.getChildNodeText(dTDElementInstance, "length");
        if (string != null && string.length() != 0) {
            nArray[0] = 1;
            nArray[1] = Integer.parseInt(string);
        } else {
            String string2 = this.getChildNodeText(dTDElementInstance, "seq-data");
            if (string2 == null) {
                nArray[1] = 1;
                nArray[0] = 1;
            } else {
                nArray[0] = 1;
                nArray[1] = string2.replaceAll("[ \t\r\n]", "").length();
            }
        }
        return nArray;
    }

    protected void setupLaneGetter() {
        this.setLaneGetter(BioseqSetPainter.getInstance());
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n = (int)abstractLinearGraphics.getScale();
        if (n == 0) {
            n = 1;
        }
        abstractLinearGraphics.setLOD(n < 200 ? 80 : 60);
        super.updateLegendItem(abstractLinearGraphics, dTDElementInstance);
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return null;
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        return null;
    }
}

