/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.painter.BasicPainter;
import ca.ucalgary.bluejay.gui.util.ColorGenerator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Hashtable;

public abstract class ClassifiedPainter
extends BasicPainter {
    private String laneName;
    private int numColors;
    private Color colorNoType;
    private Color fillColor;
    private String defaultLabel;
    private String objectClass;
    private Hashtable legendSwatches;

    public ClassifiedPainter() {
        this(512, Color.gray, "No assigned class");
    }

    public ClassifiedPainter(int n, Color color, String string) {
        this.numColors = n;
        this.colorNoType = color;
        this.defaultLabel = string;
        classColorMapping = new Hashtable(this.numColors + 1, 0.8f);
        this.legendSwatches = new Hashtable(this.numColors + 1, 0.8f);
        BufferedImage bufferedImage = new BufferedImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(this.colorNoType);
        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        this.legendSwatches.put(this.defaultLabel, bufferedImage);
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        if (!dTDElementInstance.isModelVisible()) {
            // empty if block
        }
        Color color = abstractLinearGraphics.getColor();
        String string = this.getDataClass(dTDElementInstance);
        Color color2 = this.colorNoType;
        if (string != null) {
            color2 = (Color)classColorMapping.get(string);
        }
        abstractLinearGraphics.setColor(color2);
        this.drawGlyph(abstractLinearGraphics, dTDElementInstance);
        abstractLinearGraphics.setColor(color);
    }

    public abstract void drawGlyph(AbstractLinearGraphics var1, DTDElementInstance var2) throws Exception;

    public abstract String getDataClass(DTDElementInstance var1) throws Exception;

    public abstract String getClassXPath(DTDElementInstance var1) throws Exception;

    public abstract String getNullXPath(DTDElementInstance var1) throws Exception;

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        this.fillColor = this.colorNoType;
        Image image = null;
        String string = this.objectClass = this.getDataClass(dTDElementInstance);
        if (this.objectClass != null) {
            this.fillColor = (Color)classColorMapping.get(this.objectClass);
            if (this.fillColor == null) {
                int n = classColorMapping.size() + 1;
                try {
                    this.fillColor = ColorGenerator.getColor(this.numColors, n);
                    classColorMapping.put(this.objectClass, this.fillColor);
                    image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                    Graphics graphics = image.getGraphics();
                    graphics.setColor(this.fillColor);
                    graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                    this.legendSwatches.put(this.objectClass, image);
                }
                catch (Exception exception) {
                    this.fillColor = this.colorNoType;
                    image = (Image)this.legendSwatches.get(this.defaultLabel);
                }
            } else {
                image = (Image)this.legendSwatches.get(this.objectClass);
            }
        } else {
            image = (Image)this.legendSwatches.get(this.defaultLabel);
        }
        if (abstractLinearGraphics.getLegend().isAddingItems()) {
            if (string != null) {
                String string2 = string.replaceAll("'", "&apos;");
                abstractLinearGraphics.getLegend().addItem(image, string, this.getClassXPath(dTDElementInstance), dTDElementInstance.getXPointer(), this.fillColor);
            } else {
                abstractLinearGraphics.getLegend().addItem(image, this.defaultLabel, this.getNullXPath(dTDElementInstance), dTDElementInstance.getXPointer(), this.fillColor);
            }
        }
    }
}

