/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.painter.BasicPainter;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;

public class ExonPainter
extends BasicPainter {
    private static final Color colorNoType = Color.gray;
    private static final Color darkerGreen = new Color(102, 102, 0);
    private static final Color darkGreen = new Color(0, 102, 0);
    private static final Color green = new Color(0, 204, 0);
    private static final Color lightGreen = new Color(102, 255, 102);
    private static final Color lighterGreen = new Color(204, 255, 204);
    private static final Color darkerRed = new Color(102, 0, 0);
    private static final Color darkRed = new Color(204, 0, 0);
    private static final Color red = new Color(255, 51, 51);
    private static final Color orange = new Color(255, 153, 0);
    private static final Color lighterRed = new Color(255, 204, 204);
    private static final Color darkerPurple = new Color(102, 0, 102);
    private static final Color darkPurple = new Color(204, 0, 204);
    private static final Color purple = new Color(255, 122, 255);
    private static final Color brown = new Color(102, 51, 0);
    private static final Color darkerBlue = new Color(0, 0, 102);
    private static final Color darkBlue = new Color(0, 0, 204);
    private static final Color blue = new Color(51, 51, 255);
    private static final Color lightBlue = new Color(0, 204, 204);
    private static final Color lighterBlue = new Color(204, 255, 255);
    private static final Color khaki = new Color(240, 230, 110);
    private static final Color fuchsia = new Color(255, 0, 255);
    private static final int EXON_UPPER_BOUNDARY_PIXELS = 20;
    private static final int EXON_LOWER_BOUNDARY_PIXELS = 5;
    private static final int EXON_START_LABEL_PIXELS = 25;
    private static final double EXON_UPPER_BOUNDARY = 0.4;
    private static final double EXON_LOWER_BOUNDARY = 0.1;
    private static final double EXON_START_LABEL = 0.5;
    private static final double EXON_UPPER_BOUNDARY_DETAILED = 0.12;
    private static final double EXON_LOWER_BOUNDARY_DETAILED = 0.03;
    private static final double EXON_START_LABEL_DETAILED = 0.15;

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        boolean bl;
        double d;
        double d2;
        double d3;
        int n = dTDElementInstance.getTarget();
        if (n == -1) {
            return;
        }
        String string = dTDElementInstance.getAttribute("start");
        String string2 = dTDElementInstance.getAttribute("end");
        if (string == null || string.equals("")) {
            System.err.println("Cannot paint an exon: attribute 'start' is missing");
            return;
        }
        if (string2 == null || string2.equals("")) {
            System.err.println("Cannot paint an exon: attribute 'end' is missing");
            return;
        }
        int n2 = new Integer(string);
        int n3 = new Integer(string2);
        int n4 = abstractLinearGraphics.getLOD();
        if (n4 == 80) {
            d3 = 0.12;
            d2 = 0.03;
            d = 0.15;
        } else {
            d3 = 0.4;
            d2 = 0.1;
            d = 0.5;
        }
        boolean bl2 = n3 < n2;
        boolean bl3 = ((TargetAppearance)abstractLinearGraphics.getTargetAppearances().elementAt(n)).isReverseComplement();
        boolean bl4 = bl = bl2 == bl3;
        if (bl) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
            double d4 = d3;
            d3 = -d2;
            d2 = -d4;
            d = -d;
        }
        Color color = abstractLinearGraphics.getColor();
        String string3 = dTDElementInstance.getAttribute("type");
        if (string3 != null && !string3.equals("")) {
            Color color2 = Color.yellow;
            if (string3.equals("Amino Acid Biosynthesis")) {
                color2 = red;
            } else if (string3.equals("CDS")) {
                color2 = blue;
            } else if (string3.equals("Cell Envelope")) {
                color2 = orange;
            } else if (string3.equals("rRNA")) {
                color2 = brown;
            } else if (string3.equals("tRNA")) {
                color2 = purple;
            } else if (string3.equals("Cellular Processes")) {
                color2 = darkerRed;
            } else if (string3.equals("Central Intermediary Metabolism")) {
                color2 = green;
            } else if (string3.equals("Cofactor Biosynthesis")) {
                color2 = darkGreen;
            } else if (string3.equals("Energy Metabolism")) {
                color2 = darkRed;
            } else if (string3.equals("Lipid metabolism")) {
                color2 = darkBlue;
            } else if (string3.equals("Pigments")) {
                color2 = darkPurple;
            } else if (string3.equals("Proteases")) {
                color2 = lighterGreen;
            } else if (string3.equals("Purines")) {
                color2 = lighterRed;
            } else if (string3.equals("Pyrimidines")) {
                color2 = lighterBlue;
            } else if (string3.equals("Regulation")) {
                color2 = lightGreen;
            } else if (string3.equals("RBS")) {
                color2 = fuchsia;
            } else if (string3.equals("repeat_region")) {
                color2 = khaki;
            } else if (string3.equals("Replication and Repair")) {
                color2 = lightBlue;
            } else if (string3.equals("Transcription")) {
                color2 = darkerBlue;
            } else if (string3.equals("Translation")) {
                color2 = darkerGreen;
            } else if (string3.equals("Transport")) {
                color2 = darkerPurple;
            }
            abstractLinearGraphics.startHyperlink(dTDElementInstance, true);
            abstractLinearGraphics.setColor(color2);
            abstractLinearGraphics.fillRect(n, n2, n3, d3, d2);
            abstractLinearGraphics.updateHyperlink(abstractLinearGraphics.getPoint(n, n2, d3 > 0.0 ? d3 : d2));
            if (Debug.legend && abstractLinearGraphics.getLegend().isAddingItems()) {
                Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                Graphics graphics = image.getGraphics();
                graphics.setColor(color2);
                graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                abstractLinearGraphics.getLegend().addItem(image, string3, "//bioml:exon[@bioml:type='" + string3 + "']", dTDElementInstance.getXPointer(), color2);
            }
            abstractLinearGraphics.endHyperlink();
            double d5 = abstractLinearGraphics.getTarget(n).getScale();
            if (abstractLinearGraphics.getLOD() == 80 && d5 <= 1.0) {
                int n6;
                double d6 = (double)(n3 - n2 + 1) * d5;
                String string4 = string3;
                if (string4.length() > abstractLinearGraphics.getMaxLabelLength()) {
                    n6 = abstractLinearGraphics.getMaxLabelLength() - 3;
                    string4 = n6 > 0 ? string4.substring(0, n6) : "";
                    string4 = string4 + "...";
                }
                if (d6 >= 12.0) {
                    n6 = (n2 + n3) / 2;
                    if (d3 > 0.0) {
                        if (abstractLinearGraphics.isLabelSpaceAvailable(n, string4, null, n6, 1.0, d, 30)) {
                            abstractLinearGraphics.drawString(n, string4, null, n6, 1.0, d, 30);
                        }
                    } else if (abstractLinearGraphics.isLabelSpaceAvailable(n, string4, null, n6, d, -1.0, 40)) {
                        abstractLinearGraphics.drawString(n, string4, null, n6, d, -1.0, 40);
                    }
                }
            }
        } else {
            abstractLinearGraphics.startHyperlink(dTDElementInstance, true);
            if (Debug.legend && abstractLinearGraphics.getLegend().isAddingItems()) {
                Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                Graphics graphics = image.getGraphics();
                graphics.setColor(colorNoType);
                graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                ImageIcon imageIcon = new ImageIcon(image);
                abstractLinearGraphics.getLegend().addItem(image, "No assigned type", "//bioml:exon[not(@bioml:type)]", dTDElementInstance.getXPointer(), colorNoType);
            }
            abstractLinearGraphics.setColor(colorNoType);
            abstractLinearGraphics.fillRect(n, n2, n3, d3, d2);
            abstractLinearGraphics.updateHyperlink(abstractLinearGraphics.getPoint(n, n2, d3 > 0.0 ? d3 : d2));
            abstractLinearGraphics.endHyperlink();
        }
        abstractLinearGraphics.setColor(color);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        String string = dTDElementInstance.getAttribute("start");
        String string2 = dTDElementInstance.getAttribute("end");
        if (string == null || string.equals("")) {
            System.err.println("Cannot paint an exon: attribute 'start' is missing");
            return;
        }
        if (string2 == null || string2.equals("")) {
            System.err.println("Cannot paint an exon: attribute 'end' is missing");
            return;
        }
        String string3 = dTDElementInstance.getAttribute("type");
        if (string3 != null && !string3.equals("")) {
            Color color = Color.yellow;
            if (string3.equals("Amino Acid Biosynthesis")) {
                color = red;
            } else if (string3.equals("CDS")) {
                color = blue;
            } else if (string3.equals("Cell Envelope")) {
                color = orange;
            } else if (string3.equals("rRNA")) {
                color = brown;
            } else if (string3.equals("tRNA")) {
                color = purple;
            } else if (string3.equals("Cellular Processes")) {
                color = darkerRed;
            } else if (string3.equals("Central Intermediary Metabolism")) {
                color = green;
            } else if (string3.equals("Cofactor Biosynthesis")) {
                color = darkGreen;
            } else if (string3.equals("Energy Metabolism")) {
                color = darkRed;
            } else if (string3.equals("Lipid metabolism")) {
                color = darkBlue;
            } else if (string3.equals("Pigments")) {
                color = darkPurple;
            } else if (string3.equals("Proteases")) {
                color = lighterGreen;
            } else if (string3.equals("Purines")) {
                color = lighterRed;
            } else if (string3.equals("Pyrimidines")) {
                color = lighterBlue;
            } else if (string3.equals("Regulation")) {
                color = lightGreen;
            } else if (string3.equals("RBS")) {
                color = fuchsia;
            } else if (string3.equals("repeat_region")) {
                color = khaki;
            } else if (string3.equals("Replication and Repair")) {
                color = lightBlue;
            } else if (string3.equals("Transcription")) {
                color = darkerBlue;
            } else if (string3.equals("Translation")) {
                color = darkerGreen;
            } else if (string3.equals("Transport")) {
                color = darkerPurple;
            }
            if (Debug.legend) {
                Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                Graphics graphics = image.getGraphics();
                graphics.setColor(color);
                graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                abstractLinearGraphics.getLegend().addItem(image, string3, "//bioml:exon[@bioml:type='" + string3 + "']", dTDElementInstance.getXPointer(), color);
            }
        } else if (Debug.legend) {
            Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            Graphics graphics = image.getGraphics();
            graphics.setColor(colorNoType);
            graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            ImageIcon imageIcon = new ImageIcon(image);
            abstractLinearGraphics.getLegend().addItem(image, "No assigned type", "//bioml:exon[not(@bioml:type)]", dTDElementInstance.getXPointer(), colorNoType);
        }
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        String string = dTDElementInstance.getAttribute("type");
        if (string == null || string.equals("")) {
            string = "No assigned type";
        }
        return string;
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        return null;
    }
}

