/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.util;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.util.CheckNode;
import ca.ucalgary.bluejay.gui.util.DataObject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BluejayCheckTree
extends JTree
implements TreeModelListener,
TreeWillExpandListener {
    private BluejayDObjectList dlist;
    private boolean load = false;
    private JButton apply;
    private boolean numberMode = false;
    private static Logger logger = Logger.getLogger(BluejayCheckTree.class);

    public BluejayCheckTree(DefaultTreeModel defaultTreeModel, BluejayDObjectList bluejayDObjectList) {
        this.setModel(defaultTreeModel);
        this.getModel().addTreeModelListener(this);
        ((BasicTreeUI)this.getUI()).setLeftChildIndent(0);
        ((BasicTreeUI)this.getUI()).setRightChildIndent(5);
        ((BasicTreeUI)this.getUI()).setExpandedIcon(null);
        ((BasicTreeUI)this.getUI()).setCollapsedIcon(null);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.dlist = bluejayDObjectList;
        this.apply = new JButton("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CheckNode checkNode = (CheckNode)BluejayCheckTree.this.getModel().getRoot();
                if (checkNode.getUserObject() instanceof DataObject) {
                    BluejayCheckTree.this.applyToModel(checkNode);
                    BluejayCheckTree.this.dlist.repaint(true);
                }
            }
        });
        this.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new CheckRenderer());
        this.addTreeWillExpandListener(this);
        this.addMouseListener(new NodeSelectionListener(this));
    }

    private void applyToModel(CheckNode checkNode) {
        if (checkNode != null && checkNode.isEnabled() && checkNode.getUserObject() instanceof DataObject) {
            DataObject dataObject = (DataObject)checkNode.getUserObject();
            dataObject.setModelVisible(checkNode.isSelected());
            if (checkNode.children() != null) {
                Enumeration<TreeNode> enumeration = checkNode.children();
                while (enumeration.hasMoreElements()) {
                    CheckNode checkNode2 = (CheckNode)enumeration.nextElement();
                    this.applyToModel(checkNode2);
                }
            }
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        logger.debug("We are having a party, the treestructurechanged !!!");
        this.repaint();
    }

    public void expandAll() {
        this.load = true;
        if (this.numberMode) {
            this.applyNumberMode((CheckNode)this.getModel().getRoot());
            this.revalidate();
            this.repaint();
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
        this.load = false;
    }

    public void numberMode() {
        this.numberMode = true;
        ((BasicTreeUI)this.getUI()).setLeftChildIndent(0);
        ((BasicTreeUI)this.getUI()).setRightChildIndent(0);
        this.putClientProperty("JTree.lineStyle", "None");
        this.applyNumberMode((CheckNode)this.getModel().getRoot());
        this.revalidate();
        this.repaint();
    }

    private void applyNumberMode(CheckNode checkNode) {
        if (checkNode.getParagraphString() == null) {
            checkNode.setParagraphString("1");
        }
        String string = checkNode.getParagraphString();
        int n = 1;
        if (checkNode.children() != null) {
            Enumeration<TreeNode> enumeration = checkNode.children();
            while (enumeration.hasMoreElements()) {
                CheckNode checkNode2 = (CheckNode)enumeration.nextElement();
                checkNode2.setParagraphString(string + "." + Integer.toString(n));
                this.applyNumberMode(checkNode2);
                ++n;
            }
        }
    }

    public JButton getApplyButton() {
        return this.apply;
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        throw new ExpandVetoException(treeExpansionEvent);
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public boolean isPathEditable(TreePath treePath) {
        CheckNode checkNode = (CheckNode)treePath.getLastPathComponent();
        if (checkNode.isEnabled()) {
            return this.isEditable();
        }
        return false;
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        private void enableTree(CheckNode checkNode) {
            if (checkNode.isSelected()) {
                for (int i = 0; i < checkNode.getChildCount(); ++i) {
                    this.enableTree((CheckNode)checkNode.getChildAt(i));
                }
            } else {
                for (int i = 0; i < checkNode.getChildCount(); ++i) {
                    ((CheckNode)checkNode.getChildAt(i)).setEnabled(false);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            CheckNode checkNode;
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.tree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = this.tree.getPathForRow(n3);
            if (treePath != null && (checkNode = (CheckNode)treePath.getLastPathComponent()).isEnabled()) {
                boolean bl = !checkNode.isSelected();
                checkNode.setSelected(bl);
                if (checkNode.getChildCount() > 0) {
                    if (bl) {
                        for (int i = 0; i < checkNode.getChildCount(); ++i) {
                            ((CheckNode)checkNode.getChildAt(i)).setEnabled(true);
                            if (((CheckNode)checkNode.getChildAt(i)).getChildCount() <= 0) continue;
                            this.enableTree((CheckNode)checkNode.getChildAt(i));
                        }
                    } else {
                        for (int i = 0; i < checkNode.getChildCount(); ++i) {
                            ((CheckNode)checkNode.getChildAt(i)).setEnabled(false);
                        }
                    }
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(checkNode);
                this.tree.revalidate();
                this.tree.repaint();
            }
        }
    }

    class CheckRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected JCheckBox check;
        protected TreeLabel label;
        protected JLabel numberLabel;

        public CheckRenderer() {
            this.setLayout(null);
            this.setBorder(null);
            this.check = new JCheckBox();
            this.add(this.check);
            this.numberLabel = new JLabel();
            this.add(this.numberLabel);
            this.label = new TreeLabel();
            this.add(this.label);
            this.check.setBackground(UIManager.getColor("Tree.textBackground"));
            this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            this.check.setEnabled(((CheckNode)object).isEnabled());
            this.label.setEnabled(((CheckNode)object).isEnabled());
            this.check.setSelected(((CheckNode)object).isSelected());
            if (BluejayCheckTree.this.numberMode) {
                this.numberLabel.setEnabled(true);
                this.numberLabel.setFont(jTree.getFont());
                this.numberLabel.setText(((CheckNode)object).getParagraphString());
                this.setPreferredSize(this.getPreferredSize());
            }
            this.label.setFont(jTree.getFont());
            this.label.setText(string);
            this.label.setSelected(bl);
            this.label.setFocus(bl4);
            this.label.setIcon(null);
            return this;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.check.getPreferredSize();
            Dimension dimension2 = this.label.getPreferredSize();
            Dimension dimension3 = this.numberLabel.getPreferredSize();
            return new Dimension(dimension.width + dimension2.width + dimension3.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
        }

        public void doLayout() {
            Dimension dimension = this.numberLabel.getPreferredSize();
            Dimension dimension2 = this.check.getPreferredSize();
            Dimension dimension3 = this.label.getPreferredSize();
            int n = 0;
            int n2 = 0;
            if (dimension2.height < dimension3.height) {
                n = (dimension3.height - dimension2.height) / 2;
            } else {
                n2 = (dimension2.height - dimension3.height) / 2;
            }
            this.check.setLocation(0, n);
            this.check.setBounds(0, n, dimension2.width, dimension2.height);
            this.numberLabel.setLocation(dimension2.width, n2);
            this.numberLabel.setBounds(dimension2.width, n2, dimension.width, dimension.height);
            this.label.setLocation(dimension2.width + dimension.width, n2);
            this.label.setBounds(dimension2.width + dimension.width, n2, dimension3.width, dimension3.height);
        }

        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        protected boolean isVisible(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            DataObject dataObject = (DataObject)defaultMutableTreeNode.getUserObject();
            return dataObject.isModelVisible();
        }

        public class TreeLabel
        extends JLabel {
            boolean isSelected;
            boolean hasFocus;

            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }

            public void paint(Graphics graphics) {
                String string = this.getText();
                if (string != null && 0 < string.length()) {
                    if (this.isSelected) {
                        graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                    } else {
                        graphics.setColor(UIManager.getColor("Tree.textBackground"));
                    }
                    Dimension dimension = this.getPreferredSize();
                    int n = 0;
                    Icon icon = this.getIcon();
                    if (icon != null) {
                        n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                    }
                    graphics.fillRect(n, 0, dimension.width - 1 - n, dimension.height);
                    if (this.hasFocus) {
                        graphics.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        graphics.drawRect(n, 0, dimension.width - 1 - n, dimension.height - 1);
                    }
                }
                super.paint(graphics);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension != null) {
                    dimension = new Dimension(dimension.width + 3, dimension.height);
                }
                return dimension;
            }

            public void setSelected(boolean bl) {
                this.isSelected = bl;
            }

            public void setFocus(boolean bl) {
                this.hasFocus = bl;
            }
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon ghostIcon;
        Font oldFont;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof DataObject) {
                logger.debug("rendering tree node");
                if (this.isVisible(object)) {
                    this.setToolTipText("DoubleClick to hide ");
                } else {
                    this.setToolTipText("DoubleClick to show ");
                    logger.debug("ghosting");
                    JLabel jLabel = (JLabel)component;
                    Rectangle rectangle = jTree.getPathBounds(new TreePath(defaultMutableTreeNode.getPath()));
                    jLabel.setSize((int)rectangle.getWidth(), (int)rectangle.getHeight());
                    BufferedImage bufferedImage = new BufferedImage(jLabel.getWidth(), jLabel.getHeight(), 3);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setComposite(AlphaComposite.getInstance(2, 0.3f));
                    jLabel.paint(graphics2D);
                    this.ghostIcon = new ImageIcon(bufferedImage);
                    this.setIcon(this.ghostIcon);
                    graphics2D.dispose();
                }
            }
            return this;
        }

        protected boolean isVisible(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            DataObject dataObject = (DataObject)defaultMutableTreeNode.getUserObject();
            return dataObject.isModelVisible();
        }
    }
}

