/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.log4j.Logger;

public class History {
    private Vector internetURLs = new Vector();
    private Vector cacheURLs = new Vector();
    private Vector visitIDs = new Vector();
    private Vector comparisonURLs = new Vector(10);
    public int cur_pos = -1;
    private ca.ucalgary.bluejay.session.History trueHistory;
    private ca.ucalgary.bluejay.session.History h;
    private static Logger logger = Logger.getLogger(History.class);

    private void initHistory() {
        if (this.h != null) {
            this.trueHistory = this.h;
        }
        this.internetURLs = new Vector();
        this.cacheURLs = new Vector();
        this.visitIDs = new Vector();
        this.comparisonURLs = new Vector(10);
        if (this.h != null && !this.h.getInternetURLs().isEmpty()) {
            logger.debug("JS: Remote History has content, so parse and load");
            this.loadHistory(this.h);
        } else {
            logger.debug("JS: Remote History is empty!");
        }
        this.internetURLs.trimToSize();
        this.cacheURLs.trimToSize();
        this.visitIDs.trimToSize();
        if (this.internetURLs.size() == 0) {
            logger.debug("JS: NewBrowser - load a start page please!");
            this.cur_pos = -1;
        } else {
            logger.debug("JS: Loading Session's last page");
            this.cur_pos = this.internetURLs.size() - 1;
        }
    }

    private void loadHistory(ca.ucalgary.bluejay.session.History history) {
        int n = 0;
        Vector vector = new Vector(history.getInternetURLs());
        Vector vector2 = new Vector(history.getCacheURLs());
        Vector vector3 = new Vector(history.getvIDs());
        this.internetURLs.add(vector.elementAt(n));
        this.cacheURLs.add(vector2.elementAt(n));
        this.visitIDs.add(vector3.elementAt(n));
        ++n;
        for (int i = 1; i < vector.size(); ++i) {
            String string = vector.elementAt(i).toString();
            int n2 = -1;
            n2 = this.internetURLs.indexOf(string);
            if (n2 != -1) {
                this.visitIDs.set(n2, vector3.elementAt(i).toString());
                this.cacheURLs.set(n2, vector2.elementAt(i).toString());
                n = n2;
                this.internetURLs.setSize(n2 + 1);
                this.cacheURLs.setSize(n2 + 1);
                this.visitIDs.setSize(n2 + 1);
            } else {
                this.internetURLs.add(vector.elementAt(n));
                this.cacheURLs.add(vector2.elementAt(n));
                this.visitIDs.add(vector3.elementAt(n));
            }
            ++n;
        }
        logger.debug("\n\nJS: Done loading history properly in gui.util.History");
        logger.debug("JS: Remote History was: " + vector.toString());
        logger.debug("JS: Local History is: " + this.internetURLs.toString());
        logger.debug("JS: Remote Cache is:  " + this.cacheURLs.toString());
        logger.debug("JS: Remote Cache was:   " + vector2.toString());
    }

    public void addLocation(URL uRL, URL uRL2, Integer n) {
        if (this.cur_pos == this.internetURLs.size() - 1) {
            logger.debug("JS:  Adding URL to END of local history");
            this.addURLToHistory(uRL, uRL2, n, ++this.cur_pos);
        } else {
            logger.debug("JS:  Adding URL to SOMEWHERE in local history");
            this.addURLToHistory(uRL, uRL2, n, ++this.cur_pos);
            this.internetURLs.setSize(this.cur_pos + 1);
            this.cacheURLs.setSize(this.cur_pos + 1);
            this.visitIDs.setSize(this.cur_pos + 1);
        }
    }

    public void updateLocation(URL uRL, URL uRL2, Integer n) {
        if (this.cur_pos == this.internetURLs.size() - 1) {
            logger.debug("JS:  Adding URL to END of local history");
            this.addURLToHistory(uRL, uRL2, n, ++this.cur_pos);
            logger.debug("Updated " + uRL + " to local history");
        } else {
            logger.debug("JS:  Updating URL to SOMEWHERE in local history");
            this.addURLToHistory(uRL, uRL2, n, this.cur_pos);
        }
    }

    private URL retrieveLocation(Vector vector, int n) {
        URL uRL = null;
        try {
            logger.debug("JS: Loading a version of the page at position " + n);
            Object e = vector.elementAt(n);
            if (e != null) {
                String string = e.toString();
                logger.debug("JS: String version of the page is : " + string);
                uRL = new URL(string);
                logger.debug("JS: page is: " + uRL);
                if (uRL != null && vector == this.cacheURLs && !this.isValidCachedURL(uRL)) {
                    uRL = null;
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Caught some exception in gui.util.History.currentLocation " + exception.getMessage());
            System.out.println("Caught some exception in gui.util.History.currentLocation " + exception.getMessage());
        }
        return uRL;
    }

    public URL currentLocation() {
        URL uRL = null;
        if (this.cur_pos >= 0) {
            uRL = this.retrieveLocation(this.cacheURLs, this.cur_pos);
        } else {
            logger.debug("JS: We don't have a history to load");
        }
        return uRL;
    }

    public URL nextLocation() {
        URL uRL = null;
        logger.debug("JS: gui.History.nextLocation loading");
        if (this.cur_pos >= 0 && this.cur_pos != this.internetURLs.size() - 1) {
            ++this.cur_pos;
            logger.debug("Forwarding to " + this.cur_pos + " in internetURLs");
            uRL = this.retrieveLocation(this.cacheURLs, this.cur_pos);
        }
        return uRL;
    }

    public URL previousLocation() {
        URL uRL = null;
        logger.debug("JS: gui.History.previousLocation loading");
        if (this.cur_pos > 0) {
            --this.cur_pos;
            logger.debug("Backwarding to " + this.cur_pos + " in internetURLs");
            uRL = this.retrieveLocation(this.cacheURLs, this.cur_pos);
        }
        return uRL;
    }

    public void setHistory(Vector vector) {
        this.internetURLs = vector;
        this.cur_pos = this.internetURLs.size() - 1;
    }

    public Integer getCurrentVId() {
        Integer n = new Integer(this.visitIDs.elementAt(this.cur_pos).toString());
        return n;
    }

    public void setCurrentVId(Integer n) {
        this.visitIDs.set(this.cur_pos, n);
    }

    public URL lastLocation() {
        logger.debug("JS: History is about to repeat itself... loading the last page of loaded session");
        URL uRL = this.retrieveLocation(this.cacheURLs, this.cacheURLs.size() - 1);
        return uRL;
    }

    public String getRealURL() {
        return this.internetURLs.elementAt(this.cur_pos).toString();
    }

    public int historySize() {
        return this.internetURLs.size();
    }

    public String getInternetURLs() {
        return this.internetURLs.toString();
    }

    private void addURLToHistory(URL uRL, URL uRL2, Integer n, int n2) {
        logger.debug("JS: Explicitly Adding URL to local History");
        this.internetURLs.add(n2, uRL);
        this.cacheURLs.add(n2, uRL2);
        this.visitIDs.add(n2, n);
    }

    public void setRemoteHistory(ca.ucalgary.bluejay.session.History history) {
        this.h = history;
        this.initHistory();
    }

    private boolean isValidCachedURL(URL uRL) {
        logger.debug("JS: Checking the validity of this cachedURL");
        boolean bl = false;
        try {
            Object object;
            if (!uRL.toString().endsWith(".xml") && !uRL.toString().endsWith(".xml.gz")) {
                object = uRL.toString() + ".xml";
                uRL = new URL((String)object);
            }
            object = uRL.openStream();
            bl = true;
        }
        catch (MalformedURLException malformedURLException) {
            logger.warn("isValidCachedURL in LocalHistory " + malformedURLException.getMessage());
            System.out.println("isValidCachedURL in LocalHistory " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            logger.warn("JS: This cached file doesn't exist anymore!" + iOException.getMessage());
            System.out.println("JS: This cached file doesn't exist anymore!");
        }
        return bl;
    }

    public void appendComparison(URL uRL) {
        if (this.comparisonURLs.size() <= this.cur_pos) {
            this.comparisonURLs.setSize(this.cur_pos + 1);
        }
        if (this.comparisonURLs.elementAt(this.cur_pos) == null) {
            Vector<URL> vector = new Vector<URL>();
            vector.add(0, this.currentLocation());
            vector.add(uRL);
            this.comparisonURLs.add(this.cur_pos, vector);
        } else {
            Vector vector = (Vector)this.comparisonURLs.elementAt(this.cur_pos);
            vector.add(uRL);
            this.comparisonURLs.set(this.cur_pos, vector);
        }
    }

    public Vector getComparisonURLs(int n) {
        if (n >= this.comparisonURLs.size()) {
            return null;
        }
        return (Vector)this.comparisonURLs.elementAt(n);
    }

    public Vector getinternetURLVector() {
        return this.internetURLs;
    }
}

