/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.util;

import ca.ucalgary.bluejay.client.URLLoader;
import ca.ucalgary.bluejay.client.XPointerResolver;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.DataNavigator;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayGUI;
import ca.ucalgary.seahawk.gui.MobyServicesGUI;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MultipleSelectionFacilitator {
    private ActionListener actionListener;
    private MouseEvent e;
    private JPopupMenu linkPopup;
    private BluejayDObjectList canvas;
    private URLLoader url_loader;
    private TextNode currentTextNode;
    private JMenuItem checkingLinksPopupItem;
    private MicroArrayGUI microArrayGUI;
    private static MobyServicesGUI mobyGUI;
    private static Logger logger;

    public MultipleSelectionFacilitator(URLLoader uRLLoader, BluejayDObjectList bluejayDObjectList) {
        this.url_loader = uRLLoader;
        this.canvas = bluejayDObjectList;
    }

    public void select(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        DataNavigator dataNavigator = this.canvas.getDataNavigator();
        logger.debug("Canvas coordinates: (" + point.x + ", " + point.y + ")");
        Point2D point2D = dataNavigator.getCanvasToTrueCoords(point.x, point.y);
        logger.debug("Image coordinates: (" + point2D.getX() + ", " + point2D.getY() + ")");
        String string = dataNavigator.getHitGraphicsNodeXPointer(point2D.getX(), point2D.getY());
        Document document = this.canvas.getDocument();
        Node node = null;
        if (string != null && !string.equals("")) {
            if (document != null && document.getDocumentElement() != null ? (node = XPointerResolver.getNodeFromXPointer(document, string)) == null : this.url_loader != null && this.url_loader.getActualURLName() != null && (node = XPointerResolver.getNodeFromXPointer(this.url_loader.getActualURLName(), string, this.canvas.getBluejayParser())) == null) {
                return;
            }
        } else {
            return;
        }
        TreeMap treeMap = this.canvas.getDataManager().getXPtrToGVTMap();
        Vector vector = (Vector)treeMap.get(string);
        if (vector != null) {
            logger.warn("Parent Data= " + string);
            if (this.setLegendVisibility(point2D, vector)) {
                return;
            }
        }
    }

    public boolean setLegendVisibility(Point2D point2D, Collection collection) {
        for (GraphicsNode graphicsNode : collection) {
            if (!(graphicsNode instanceof TextNode) || ((TextNode)graphicsNode).getText().replaceAll("\\d", "").trim().equals("")) continue;
            AffineTransform affineTransform = null;
            try {
                affineTransform = graphicsNode.getTransform() != null ? graphicsNode.getTransform().createInverse() : new AffineTransform();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println("NoninvertibleTransformException");
            }
            affineTransform.concatenate(graphicsNode.getGlobalTransform());
            Rectangle2D rectangle2D = graphicsNode.getTransformedBounds(affineTransform);
            double d = Math.floor(rectangle2D.getX());
            double d2 = Math.floor(rectangle2D.getY());
            double d3 = Math.ceil(d + rectangle2D.getWidth());
            double d4 = Math.ceil(d2 + rectangle2D.getHeight());
            logger.debug("\t" + graphicsNode + " = " + ((TextNode)graphicsNode).getText().substring(0, 5) + " with bounds (" + d + "-" + d3 + ", " + d2 + "-" + d4 + ") and width " + rectangle2D.getWidth() + " and height " + rectangle2D.getHeight());
            double d5 = point2D.getX();
            double d6 = point2D.getY();
            if (!(d5 >= d) || !(d5 <= d3) || !(d6 >= d2) || !(d6 <= d4)) continue;
            String string = ((TextNode)graphicsNode).getText();
            double d7 = 1.0 / this.canvas.getScale();
            int n = (int)((d5 -= d) / d7);
            System.err.println("~" + string.charAt(n) + " (x = " + d5 + ", index = " + n + ")");
            return true;
        }
        return false;
    }

    public void setMouseEvent(MouseEvent mouseEvent) {
        this.e = mouseEvent;
    }

    static {
        logger = Logger.getLogger(MultipleSelectionFacilitator.class);
    }
}

