/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import ca.ucalgary.bluejay.session.CacheReturn;
import ca.ucalgary.bluejay.session.ConnectionPool;
import ca.ucalgary.bluejay.session.DeleteInvestigation;
import ca.ucalgary.bluejay.session.FreeCache;
import ca.ucalgary.bluejay.session.ProxyException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CacheMgmt {
    private String cacheRoot;
    private int waterMark;

    public CacheMgmt() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ca.ucalgary.bluejay.session.data.cacheProperties");
            this.cacheRoot = resourceBundle.getString("cacheRoot");
            this.waterMark = new Integer(resourceBundle.getString("waterMark"));
            char c = System.getProperty("file.separator").charAt(0);
            if (this.cacheRoot.charAt(this.cacheRoot.length() - 1) != c) {
                this.cacheRoot = this.cacheRoot + c;
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("cacheMgmt--IO" + missingResourceException.getMessage());
        }
    }

    public CacheReturn getURL(String string, String[] stringArray, String[] stringArray2, String string2) throws IOException, ProxyException {
        Object object;
        Object object2;
        System.err.println("\n\nurlS = " + string + "\nheaderNames = " + stringArray + "\nheaderValues = " + stringArray2 + "\npathSuffix = " + string2);
        String string3 = this.cacheRoot + string2;
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (SocketException socketException) {
            System.out.println("Can't connect to host: " + socketException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("resource not found: " + fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("General exception in cache management getURL: " + exception.getClass().getName() + ": " + exception.getMessage());
            exception.printStackTrace();
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                uRLConnection.setRequestProperty(stringArray[i], stringArray2[i]);
            }
        }
        try {
            Closeable closeable;
            if (string.endsWith(".gz")) {
                object2 = new DataInputStream(inputStream);
                closeable = new DataOutputStream(new FileOutputStream(string3 + ".xml.gz"));
                System.err.println("CACHED file: " + string3 + ".xml.gz");
                byte[] byArray = new byte[1];
                while (((DataInputStream)object2).read(byArray) != -1) {
                    ((DataOutputStream)closeable).write(byArray, 0, byArray.length);
                }
                ((FilterInputStream)object2).close();
                ((DataOutputStream)closeable).flush();
                ((FilterOutputStream)closeable).close();
            } else {
                String string4;
                object2 = new InputStreamReader(inputStream);
                closeable = null;
                PrintWriter printWriter = null;
                closeable = new BufferedReader((Reader)object2);
                object = new FileOutputStream(string3 + ".xml");
                System.err.println("CACHED file: " + string3 + ".xml");
                printWriter = new PrintWriter((OutputStream)object);
                while ((string4 = ((BufferedReader)closeable).readLine()) != null) {
                    printWriter.println(string4);
                }
                printWriter.flush();
                ((BufferedReader)closeable).close();
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("error cacheMgmt" + iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            System.err.println("error cacheMgmt" + exception.getMessage());
            exception.printStackTrace();
        }
        object2 = new CacheReturn();
        ((CacheReturn)object2).filePath = string3;
        long l = uRLConnection.getExpiration();
        object = new File(string3);
        ((CacheReturn)object2).fileSize = (int)((File)object).length();
        ((CacheReturn)object2).lModified = uRLConnection.getLastModified();
        long l2 = this.checkAfter(uRLConnection.getDate(), ((CacheReturn)object2).lModified);
        ((CacheReturn)object2).toCheckAfter = l != 0L ? l : l2;
        return object2;
    }

    protected CacheReturn postURL(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string2) throws IOException, ProxyException {
        int n;
        String string3 = this.cacheRoot + string2;
        InputStreamReader inputStreamReader = null;
        URLConnection uRLConnection = null;
        try {
            URL uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
        }
        catch (SocketException socketException) {
            System.out.println("Can't connect to host: " + socketException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("resource not found: " + fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("General exception in cache management postURL: " + exception.getClass().getName() + ": " + exception.getMessage());
            exception.printStackTrace();
        }
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        URLConnection.setDefaultAllowUserInteraction(false);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                uRLConnection.setRequestProperty(stringArray[i], stringArray2[i]);
            }
        }
        uRLConnection.setAllowUserInteraction(true);
        DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
        String string4 = null;
        if (stringArray3 != null) {
            string4 = URLEncoder.encode(stringArray3[0], "UTF-8") + "=" + URLEncoder.encode(stringArray4[0], "UTF-8");
            for (int i = 1; i < stringArray3.length; ++i) {
                string4 = string4 + "&" + URLEncoder.encode(stringArray3[i], "UTF-8") + "=" + URLEncoder.encode(stringArray4[i], "UTF-8");
            }
        }
        String string5 = new Integer(string4.length()).toString();
        uRLConnection.setRequestProperty("Content-Length", string5);
        if (string4 != null) {
            dataOutputStream.writeBytes(string4);
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        FileWriter fileWriter = null;
        uRLConnection.connect();
        fileWriter = new FileWriter(string3 + ".xml");
        bufferedWriter = new BufferedWriter(fileWriter);
        bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        while ((n = bufferedReader.read()) != -1) {
            bufferedWriter.write(n);
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        bufferedReader.close();
        if (stringArray3 != null) {
            for (int i = 0; i < stringArray3.length; ++i) {
                fileWriter = new FileWriter(string3 + ".post_" + stringArray3[i] + "_" + i);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(stringArray4[i]);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
        }
        CacheReturn cacheReturn = new CacheReturn();
        cacheReturn.filePath = string3;
        long l = uRLConnection.getExpiration();
        File file = new File(string3);
        cacheReturn.fileSize = (int)file.length();
        cacheReturn.lModified = uRLConnection.getLastModified();
        cacheReturn.toCheckAfter = l != 0L ? l : this.checkAfter(uRLConnection.getDate(), cacheReturn.lModified);
        return cacheReturn;
    }

    private long checkAfter(long l, long l2) {
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        if (l2 == 0L) {
            l2 = l;
        }
        long l3 = (long)(0.2 * (double)(l - l2));
        long l4 = l - System.currentTimeMillis();
        return l + l3 - l4;
    }

    protected void deleteInvestigation(ConnectionPool connectionPool, int n, int n2) {
        DeleteInvestigation deleteInvestigation = new DeleteInvestigation(connectionPool, this.cacheRoot, n, n2);
        deleteInvestigation.start();
    }

    protected void freeCache(ConnectionPool connectionPool, int n, int n2, int n3) {
        FreeCache freeCache = new FreeCache(connectionPool, this.cacheRoot, this.waterMark, n, n2, n3);
        freeCache.start();
    }

    protected void refresh(Connection connection, int n) throws SQLException, IOException, ProxyException {
        Statement statement = null;
        ResultSet resultSet = null;
        statement = connection.createStatement();
        resultSet = statement.executeQuery("SELECT cacheID FROM VISITS WHERE vID=" + n);
        resultSet.next();
        int n2 = resultSet.getInt("cacheID");
        resultSet = statement.executeQuery("SELECT urlOriginal, cachePath, HTTPprotocol FROM CACHE WHERE cacheID=" + n2);
        resultSet.next();
        String string = resultSet.getString("HTTPprotocol");
        String string2 = resultSet.getString("urlOriginal");
        String string3 = resultSet.getString("cachePath");
        CacheReturn cacheReturn = null;
        if (string.equals("G")) {
            cacheReturn = this.getURL(string2, null, null, string3);
        }
        Date date = new Date(System.currentTimeMillis());
        String string4 = "'" + date.toString() + "'";
        Date date2 = new Date(cacheReturn.toCheckAfter);
        String string5 = "'" + date2.toString() + "'";
        Date date3 = new Date(cacheReturn.lModified);
        String string6 = "'" + date3.toString() + "'";
        statement.executeUpdate("UPDATE CACHE SET toCheckAfter=" + date2 + " WHERE cacheID=" + n2);
        statement.executeUpdate("UPDATE CACHE SET lModified=" + date3 + " WHERE cacheID=" + n2);
        statement.executeUpdate("UPDATE CACHE SET stillSavedFlag='y' WHERE cacheID=" + n2);
        statement.executeUpdate("UPDATE CACHE SET docRetTime=" + cacheReturn.docRetTime + " WHERE cacheID=" + n2);
        statement.executeUpdate("UPDATE CACHE SET docConTime=" + cacheReturn.docConTime + " WHERE cacheID=" + n2);
    }

    protected int copyTo(String string, String string2) throws IOException {
        int n;
        String string3 = this.cacheRoot + string;
        String string4 = this.cacheRoot + string2;
        File file = new File(string3 + ".xml");
        int n2 = (int)file.length();
        file = new File(string3 + ".xsl");
        n2 += (int)file.length();
        FileReader fileReader = new FileReader(string3 + ".xml");
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        FileWriter fileWriter = new FileWriter(string4 + ".xml");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        while ((n = bufferedReader.read()) != -1) {
            bufferedWriter.write(n);
        }
        bufferedWriter.flush();
        fileReader = new FileReader(string3 + ".xsl");
        bufferedReader = new BufferedReader(fileReader);
        fileWriter = new FileWriter(string4 + ".xsl");
        bufferedWriter = new BufferedWriter(fileWriter);
        while ((n = bufferedReader.read()) != -1) {
            bufferedWriter.write(n);
        }
        bufferedWriter.flush();
        bufferedReader.close();
        bufferedWriter.close();
        return n2;
    }

    protected int deleteFiles(String string) {
        String string2 = this.cacheRoot + string;
        File file = new File(string2 + ".xml");
        int n = (int)file.length();
        file.delete();
        file = new File(string2 + ".xsl");
        file.delete();
        return n += (int)file.length();
    }

    protected void updateAppearance(String string, String string2) throws IOException {
        String string3 = this.cacheRoot + string;
        FileWriter fileWriter = new FileWriter(string3 + ".xsl");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(string2);
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    protected void createInvestigation(int n, int n2) {
        char c = System.getProperty("file.separator").charAt(0);
        String string = new Integer(n).toString();
        String string2 = new Integer(n2).toString();
        String string3 = this.cacheRoot + string + c + string2;
        File file = new File(string3);
        if (file.exists() || !file.mkdirs()) {
            // empty if block
        }
    }
}

