/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.session.TfIdfEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Entry
implements Serializable {
    private String ID;
    private int ranking;
    private Hashtable<String, Integer> wordsAndOccurances;
    private int totalTerms = 0;
    private static Vector<String> stopWords;

    public Entry(DTDElementInstance dTDElementInstance, int n) {
        this.ranking = n;
        if (stopWords == null) {
            this.fillStopWords();
        }
        this.wordsAndOccurances = new Hashtable();
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter != null) {
            String[] stringArray;
            String string = abstractLinearPainter.getDescription(dTDElementInstance);
            if (TfIdfEngine.DEBUG) {
                System.err.println("Description = " + string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                stringArray = stringTokenizer.nextToken().toLowerCase();
                if (this.wordsAndOccurances.contains(stringArray)) {
                    Integer n2 = this.wordsAndOccurances.get(stringArray);
                    n2 = new Integer(n2 + 1);
                    this.wordsAndOccurances.remove(stringArray);
                    this.add((String)stringArray, n2);
                } else {
                    this.add((String)stringArray, new Integer(1));
                }
                ++this.totalTerms;
            }
            stringArray = abstractLinearPainter.getIDs(dTDElementInstance);
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                String string2 = stringArray[i].toLowerCase();
                if (this.wordsAndOccurances.contains(string2)) {
                    Integer n3 = this.wordsAndOccurances.get(string2);
                    n3 = new Integer(n3 + 1);
                    this.add(string2, n3);
                } else {
                    this.add(string2, new Integer(1));
                }
                if (TfIdfEngine.DEBUG) {
                    System.err.println("ID" + i + " = " + string2);
                }
                ++this.totalTerms;
            }
            this.ID = abstractLinearPainter.getPrimaryID(dTDElementInstance);
        }
        if (TfIdfEngine.DEBUG) {
            this.printWordsAndOccurances();
        }
    }

    private void add(String string, Integer n) {
        if (!stopWords.contains(string)) {
            this.wordsAndOccurances.put(string, n);
        }
    }

    public void printWordsAndOccurances() {
        System.err.println("HASHTABLE:");
        if (this.wordsAndOccurances != null) {
            Enumeration<String> enumeration = this.wordsAndOccurances.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Integer n = this.wordsAndOccurances.get(string);
                System.err.println(string + " \t: " + n);
            }
        }
    }

    public int getOccurances(String string) {
        Integer n = this.wordsAndOccurances.get(string.toLowerCase());
        if (n == null) {
            return 0;
        }
        return n;
    }

    public boolean occursWord(String string) {
        Integer n = this.wordsAndOccurances.get(string.toLowerCase());
        return n != null;
    }

    public double getTf(String string) {
        double d = 0.0;
        if (this.occursWord(string)) {
            int n = this.getOccurances(string);
            int n2 = this.getTotalTerms();
            d = (double)n / (double)n2;
        }
        return d;
    }

    public String getID() {
        return this.ID;
    }

    public void setRank(int n) {
        this.ranking = n;
    }

    public int getRank() {
        return this.ranking;
    }

    public Hashtable getWordsAndOccurances() {
        return this.wordsAndOccurances;
    }

    public int getTotalTerms() {
        return this.totalTerms;
    }

    public void fillStopWords() {
        stopWords = new Vector();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResource("docs/stop_words.txt").openStream()));
            String string = bufferedReader.readLine();
            while (string != null) {
                stopWords.add(string);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception in ca.ucalgary.bluejay.session.Entry.fillStopWords");
        }
    }
}

