/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import ca.ucalgary.bluejay.session.Entry;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearningClass {
    private HashSet<Entry> entries;
    private static HashSet<LearningClass> allClasses;
    private int id = 0;
    private double gamma = 4.0;
    private double beta = 16.0;
    private Hashtable<String, Double> termToWeight;

    public LearningClass(int n) {
        this.id = n;
        this.entries = new HashSet();
        if (allClasses == null) {
            allClasses = new HashSet();
        }
        allClasses.add(this);
        this.termToWeight = new Hashtable();
    }

    public void add(Object object) {
        if (!(object instanceof Entry)) {
            System.err.println("LearningClass WARNING: The object should be an instance of ca.ucalgary.bluejay.session.Entry.");
            return;
        }
        this.entries.add((Entry)object);
        Set set = ((Entry)object).getWordsAndOccurances().keySet();
        this.update(set);
        this.updateOthers(set);
    }

    public void update(Set set) {
        for (String string : set) {
            double d = this.getSumTfIdfs(string);
            int n = this.size();
            double d2 = 0.0;
            int n2 = 0;
            for (LearningClass learningClass : allClasses) {
                if (learningClass.getId() == this.id) continue;
                d2 += learningClass.getSumTfIdfs(string);
                n2 += learningClass.size();
            }
            double d3 = this.beta * (1.0 / (double)n) * d;
            double d4 = this.gamma * (1.0 / (double)n2) * d2;
            d4 = this.checkAndCorrect(d4);
            d3 = this.checkAndCorrect(d3);
            double d5 = d3 - d4;
            if (this.termToWeight.contains(string)) {
                this.termToWeight.remove(string);
            }
            this.termToWeight.put(string, new Double(d5));
        }
    }

    public void updateOthers(Set set) {
        for (LearningClass learningClass : allClasses) {
            if (learningClass.getId() == this.id) continue;
            learningClass.update(set);
        }
    }

    public double checkAndCorrect(double d) {
        if (Double.isNaN(d) || d > 9.99999999E8 || d < -9.99999999E8) {
            d = 0.0;
        }
        return d;
    }

    public int size() {
        return this.entries.size();
    }

    public int getId() {
        return this.id;
    }

    public double getSumTfIdfs(String string) {
        return this.getSumTfIdfs(string, this.entries);
    }

    public double getSumTfIdfs(String string, HashSet hashSet) {
        double d = this.calculateIdf(string, hashSet);
        double d2 = 0.0;
        for (Entry entry : hashSet) {
            d2 += entry.getTf(string) * d;
        }
        return d2;
    }

    public double calculateIdf(String string, HashSet hashSet) {
        int n = 0;
        int n2 = 0;
        for (LearningClass learningClass : allClasses) {
            n += learningClass.findDocumentOccurances(string);
            n2 += learningClass.size();
        }
        double d = Math.log((double)n2 / (double)n);
        return d;
    }

    public int findDocumentOccurances(String string) {
        return this.findDocumentOccurances(string, this.entries);
    }

    public int findDocumentOccurances(String string, HashSet<Entry> hashSet) {
        int n = 0;
        for (Entry entry : hashSet) {
            if (!entry.occursWord(string)) continue;
            ++n;
        }
        return n;
    }

    public void printHashtable(Hashtable hashtable) {
        System.err.println("\nUSER PROFILE " + this.id + ":\n");
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable.get(k);
                System.err.println(k + " \t: " + v);
            }
        }
    }

    public HashSet<Entry> getEntries() {
        return this.entries;
    }

    public Hashtable<String, Double> getUserProfile() {
        return this.termToWeight;
    }
}

