/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.session.SessionManager;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;

public class StateCollection
implements PropertyChangeListener {
    public static final String EDIT_UNDO_PROPERTY = "edit undo enabled";
    private PropertyChangeListener changeListener;
    private static String internetURL;
    private static String cacheURL;
    private static boolean isReverse;
    private static String zoomFactor;
    private static int cut;
    private static Hashtable unclicked;
    private static Hashtable greyed;
    private static int shape;
    private static int topPosition;
    private static String view;
    private static int navPosition;
    private static int position;
    private static String target;
    private static Color fgcolor;
    private static Color bgcolor;
    private static Font font;
    private static int rating;
    private static SessionManager sessionManager;
    private Vector documentUndo = new Vector();
    private Vector documentRedo = new Vector();
    public int cur_pos = -1;
    private Object current = null;
    private int count = 0;

    public StateCollection() {
    }

    public StateCollection(String string, String string2) {
        this.documentUndo = new Vector();
        this.cur_pos = -1;
        internetURL = string;
        cacheURL = string2;
        this.add("url", internetURL.toString());
    }

    public StateCollection(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    private void add(Object object, Object object2) {
        this.addState(this.createNewState((String)object, (String)object2));
    }

    private void add(Object object, Object object2, Object object3) {
        this.addState(this.createNewState(object, object2, object3));
    }

    private void add(String string, String string2, String string3) {
        this.addState(this.createNewState(string, string2, string3));
    }

    private void addState(Object object) {
        if (this.documentUndo.size() < 100 || this.cur_pos != this.documentUndo.size() - 1) {
            this.documentUndo.add(++this.cur_pos, object);
            if (this.cur_pos != this.documentUndo.size() - 1) {
                this.documentUndo.setSize(this.cur_pos + 1);
            }
        } else {
            for (int i = 1; i < 100; ++i) {
                this.documentUndo.set(i - 1, this.documentUndo.elementAt(i));
            }
            this.documentUndo.add(this.cur_pos, object);
            this.documentUndo.setSize(this.cur_pos + 1);
        }
    }

    public Object getCurrentState() {
        return this.documentUndo.elementAt(this.cur_pos);
    }

    public Object getPreviousState() {
        return this.documentUndo.elementAt(this.cur_pos - 1);
    }

    public Object getNextState() {
        return this.documentRedo.elementAt(this.documentRedo.size() - 1);
    }

    private void watchHistory() {
        for (int i = 0; i <= this.cur_pos; ++i) {
            if (this.documentUndo.elementAt(i) instanceof String[]) {
                if (this.cur_pos == i) {
                    System.err.print(">");
                }
                System.err.println(i + ": " + ((String[])this.documentUndo.elementAt(i))[0].toString());
                System.err.println("\t " + ((String[])this.documentUndo.elementAt(i))[1].toString());
                continue;
            }
            if (!(this.documentUndo.elementAt(i) instanceof Object[])) continue;
            if (this.cur_pos == i) {
                System.err.print(">");
            }
            System.err.println(i + ": " + ((String)((Object[])this.documentUndo.elementAt(i))[0]).toString());
            System.err.println(i + ": " + (Hashtable)((Object[])this.documentUndo.elementAt(i))[1]);
            System.err.println(i + ": " + (Hashtable)((Object[])this.documentUndo.elementAt(i))[2]);
        }
    }

    public boolean undoMostRecent(int n) {
        this.cur_pos -= n;
        this.documentRedo.add(this.documentUndo.elementAt(this.cur_pos + 1));
        this.documentUndo.setSize(this.cur_pos + 1);
        return this.documentUndo.size() > 2;
    }

    public boolean redoMostRecent(int n) {
        if (this.documentRedo.size() > 0) {
            this.documentUndo.setSize(this.documentUndo.size() - n);
            this.documentUndo.add(this.documentRedo.remove(this.documentRedo.size() - 1));
            this.cur_pos = this.documentUndo.size() - 1;
        }
        return this.noMoreToRedo();
    }

    public boolean curPosIsUrl() {
        return this.cur_pos <= 0;
    }

    public boolean noMoreToRedo() {
        return this.documentRedo.size() < 1;
    }

    private String[] createNewState(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        return stringArray;
    }

    private Object[] createNewState(Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{(String)object, (Hashtable)object2, (Hashtable)object3};
        return objectArray;
    }

    private String[] createNewState(String string, String string2, String string3) {
        String[] stringArray = new String[]{string, string2, string3};
        return stringArray;
    }

    public String getCacheAppearance() {
        String string = new String();
        string = bgcolor != null ? string.concat("bgcolor: " + bgcolor.toString()) : string.concat("bgcolor: null");
        string = cacheURL != null ? string.concat("\ncacheURL: " + cacheURL.toString()) : string.concat("\ncacheURL: null");
        string = string.concat("\ncut: " + cut);
        string = fgcolor != null ? string.concat("\nfgcolor: " + fgcolor.toString()) : string.concat("\nfgcolor: null");
        string = font != null ? string.concat("\nfont: " + font.toString()) : string.concat("\nfont: null");
        string = internetURL != null ? string.concat("\ninternetURL: " + internetURL.toString()) : string.concat("\ninternetURL: null");
        string = string.concat("\nisReverse: " + this.getString(isReverse));
        string = string.concat("\nposition: " + this.getString(position));
        string = string.concat("\nshape: " + this.getString(shape));
        string = string.concat("\ntopPosition: " + this.getString(topPosition));
        string = view != null ? string.concat("\nview: " + view) : string.concat("\nview: null");
        string = zoomFactor != null ? string.concat("\nzoomFactor: " + zoomFactor.toString()) : string.concat("\nzoomFactor: null");
        return string;
    }

    public int getRating() {
        return rating;
    }

    public Hashtable getUnclicked() {
        return (Hashtable)unclicked.clone();
    }

    public Hashtable getGreyed() {
        return (Hashtable)greyed.clone();
    }

    public void setContextPane() {
    }

    public void setCut(int n) {
        this.add("cut", this.getString(cut), target);
        cut = n;
    }

    public void setDrawingPrefs(Font font, Color color, Color color2) {
        StateCollection.font = font;
        fgcolor = color;
        bgcolor = color2;
    }

    public void setGear() {
    }

    public void setLane() {
    }

    public void setLegendChange(Hashtable hashtable, Hashtable hashtable2) {
        this.add((Object)"legend", unclicked, greyed);
        unclicked = hashtable;
        greyed = hashtable2;
    }

    public void setLegendSelectAll(Hashtable hashtable, Hashtable hashtable2) {
        this.add((Object)"selectall", unclicked, greyed);
        unclicked = hashtable;
        greyed = hashtable2;
    }

    public void setNavigationPosition(int n) {
        if (n != navPosition) {
            this.add("navigation position", this.getString(navPosition), target);
            navPosition = n;
        }
    }

    public void setRating(int n) {
        rating = n;
    }

    public void setReverse(boolean bl) {
        this.add("reversecomplement", this.getString(isReverse), target);
        isReverse = bl;
    }

    public void setRotation(int n) {
        this.add("rotate", this.getString(topPosition), target);
        topPosition = n;
    }

    public void setSessionManager(SessionManager sessionManager) {
        StateCollection.sessionManager = sessionManager;
    }

    public void setShape(int n) {
        this.add("shape", this.getString(shape), target);
        shape = n;
    }

    public void setTarget(int n) {
        target = this.getString(n);
    }

    public void setView(String string) {
        this.add("view", view);
        view = string;
    }

    public String getFrameView() {
        return view == null ? null : view;
    }

    private String getString(int n) {
        String string = new String();
        Integer n2 = new Integer(n);
        string = n2.toString();
        return string;
    }

    private String getString(boolean bl) {
        String string = new String();
        Boolean bl2 = new Boolean(bl);
        string = bl2.toString();
        return string;
    }

    public int getTopPosition() {
        return topPosition;
    }

    public int getCur_Pos() {
        return this.cur_pos;
    }

    public int getUndoSize() {
        return this.documentUndo.size();
    }

    public int getRedoSize() {
        return this.documentRedo.size();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent, boolean bl) {
        this.propertyChange(propertyChangeEvent);
        if (bl) {
            this.count = 2;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("scale in bases per pixel")) {
            zoomFactor = new Double(((VisibilityManager)propertyChangeEvent.getSource()).getScale()).toString();
            Double d = new Double(((VisibilityManager)propertyChangeEvent.getSource()).getScale());
            if (d > 0.0) {
                this.add("zoom", zoomFactor);
            }
        }
        if (this.count == 2) {
            --this.count;
            return;
        }
        if (this.count == 1) {
            this.removeState();
            --this.count;
        }
    }

    public void combine(StateCollection stateCollection) {
        int n = stateCollection.getUndoSize();
        for (int i = 1; i < n; ++i) {
            this.addState(stateCollection.removeState());
        }
        stateCollection = this;
    }

    public Object removeState() {
        Object object = this.getCurrentState();
        this.documentUndo.setSize(this.documentUndo.size() - 1);
        --this.cur_pos;
        return object;
    }

    public void outputStatus() {
        System.err.println("\n\n");
        System.err.println("unclicked: " + unclicked);
        System.err.println("greyed: " + greyed);
        System.err.println("\n\n");
    }

    public void resetLegendHashtables(Hashtable hashtable, Hashtable hashtable2) {
        unclicked = hashtable;
        greyed = hashtable2;
    }

    public PropertyChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    public boolean hasUndo() {
        return this.documentUndo.size() > 2;
    }

    public boolean hasRedo() {
        return this.documentRedo.size() > 0;
    }

    static {
        isReverse = false;
        zoomFactor = "Fit to Screen";
        cut = 0;
        unclicked = new Hashtable();
        greyed = new Hashtable();
        shape = 112;
        topPosition = 1;
        view = "Two Frame";
        navPosition = 1;
        position = 1;
        target = "0";
        fgcolor = Color.black;
        bgcolor = Color.white;
        font = new Font("SansSerif", 0, 12);
        rating = 0;
    }
}

