/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.util;

import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.util.History;
import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;

public class SafeURLLoader
implements Runnable {
    private static BluejayURLLoader urlLoader = new BluejayURLLoader();
    Thread poller = null;
    Applet applet = null;
    History history = null;
    String form_name = "";
    String field_name = "";
    int polling_interval = 2000;
    boolean is_started = false;

    public SafeURLLoader(Applet applet, History history, String string, String string2) {
        this.applet = applet;
        this.history = history;
        this.form_name = string;
        this.field_name = string2;
        this.poller = new Thread(this);
        this.poller.setDaemon(true);
        this.poller.setPriority(1);
    }

    public SafeURLLoader(Applet applet, History history, String string, String string2, int n) {
        this(applet, history, string, string2);
        this.polling_interval = n;
    }

    public void run() {
        String string = "";
        JSObject jSObject = JSObject.getWindow(this.applet);
        JSObject jSObject2 = (JSObject)jSObject.getMember("document");
        JSObject jSObject3 = (JSObject)jSObject2.getMember(this.form_name);
        if (jSObject3 == null) {
            System.err.println("No '" + this.form_name + "' object was found in the loading document");
            return;
        }
        JSObject jSObject4 = (JSObject)jSObject3.getMember(this.field_name);
        if (jSObject4 == null) {
            System.err.println("No '" + this.field_name + "' object was found in the loading document's bluejay_form");
            return;
        }
        while (true) {
            String string2;
            if (!((string2 = (String)jSObject4.getMember("value")) == null || string2.length() == 0 || string2.equals("undefined") || string2.equals(string) || string2.equals(this.getCurrentURL()))) {
                URL uRL = null;
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("URL to load from Javascript (" + string2 + ") could not be parsed:" + malformedURLException);
                }
                if (uRL != null) {
                    string = string2;
                    try {
                        System.out.println("Loading " + uRL.toString());
                        SwingUtilities.invokeAndWait(new SwingLoader(uRL));
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Cannot load " + uRL + ", thread was interrupted: " + interruptedException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.err.println("Cannot load " + uRL + ", invoker was invalid (security restriction?): " + invocationTargetException);
                    }
                }
            }
            try {
                Thread.sleep(this.polling_interval);
                continue;
            }
            catch (InterruptedException interruptedException) {
                System.out.println("URL monitor was interrupted: " + interruptedException);
                continue;
            }
            break;
        }
    }

    public String getCurrentURL() {
        if (this.history.currentLocation() == null) {
            return "";
        }
        return this.history.currentLocation().toString();
    }

    public void startMonitoring() {
        if (!this.is_started) {
            this.poller.run();
            this.is_started = true;
        }
    }

    public void setURLLoader(BluejayURLLoader bluejayURLLoader) {
        urlLoader = bluejayURLLoader;
    }

    class SwingLoader
    implements Runnable {
        private URL swing_url_to_load = null;

        public SwingLoader(URL uRL) {
            this.swing_url_to_load = uRL;
        }

        public void run() {
            urlLoader.gotoURL(this.swing_url_to_load, true);
        }
    }
}

