/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.util;

public class Sequence {
    public static boolean isNucleicAcid(String string) {
        String string2 = string.replaceAll("[^acgtunxACGTUNX]", "");
        String string3 = string.replaceAll("[acgtumrwsykvhdbnxACGTUMRWSYKVHDBNX \\-\t\r\n]", "");
        double d = string.length();
        return (double)string2.length() / d > 0.66 && (double)string3.length() / d < 0.05;
    }

    public static boolean isDNA(String string) {
        String string2 = string.replaceAll("[^acgtnxACGTNX]", "");
        String string3 = string.replaceAll("[acgtmrwsykvhdbnxACGTMRWSYKVHDBNX \\-\t\r\n]", "");
        double d = string.length();
        return (double)string2.length() / d > 0.66 && (double)string3.length() / d < 0.05;
    }

    public static boolean isRNA(String string) {
        String string2 = string.replaceAll("[^acgunxACGUNX]", "");
        String string3 = string.replaceAll("[acgumrwsykvhdbnxACGUMRWSYKVHDBNX \\-\t\r\n]", "");
        double d = string.length();
        return (double)string2.length() / d > 0.66 && (double)string3.length() / d < 0.05;
    }

    public static boolean isProtein(String string) {
        String string2 = string.replaceAll("[^ARNDCQEGHILKMFPSTWYVBZXarndcqeghilkmfpstwyvbz*]", "");
        String string3 = string.replaceAll("[ARNDCQEGHILKMFPSTWYVBZXarndcqeghilkmfpstwyvbz \\-\t\r\n]", "");
        double d = string.length();
        return (double)string2.length() / d > 0.95 && (double)string3.length() / d < 0.02;
    }

    public static String reverseComplement(String string) {
        if (string == null) {
            return null;
        }
        char c = 't';
        char c2 = 'T';
        if (Sequence.isRNA(string)) {
            c = 'u';
            c2 = 'U';
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.setLength(n);
        for (int i = 0; i < n; ++i) {
            char c3 = 'X';
            switch (string.charAt(i)) {
                case 'a': {
                    c3 = c;
                    break;
                }
                case 'A': {
                    c3 = c2;
                    break;
                }
                case 'c': {
                    c3 = 'g';
                    break;
                }
                case 'C': {
                    c3 = 'G';
                    break;
                }
                case 'g': {
                    c3 = 'c';
                    break;
                }
                case 'G': {
                    c3 = 'C';
                    break;
                }
                case 't': 
                case 'u': {
                    c3 = 'a';
                    break;
                }
                case 'T': 
                case 'U': {
                    c3 = 'A';
                    break;
                }
                case 'b': {
                    c3 = 'v';
                    break;
                }
                case 'B': {
                    c3 = 'V';
                    break;
                }
                case 'd': {
                    c3 = 'h';
                    break;
                }
                case 'D': {
                    c3 = 'H';
                    break;
                }
                case 'h': {
                    c3 = 'd';
                    break;
                }
                case 'H': {
                    c3 = 'd';
                    break;
                }
                case 'k': {
                    c3 = 'm';
                    break;
                }
                case 'K': {
                    c3 = 'M';
                    break;
                }
                case 'm': {
                    c3 = 'k';
                    break;
                }
                case 'M': {
                    c3 = 'K';
                    break;
                }
                case 'r': {
                    c3 = 'y';
                    break;
                }
                case 'R': {
                    c3 = 'Y';
                    break;
                }
                case 's': {
                    c3 = 's';
                    break;
                }
                case 'S': {
                    c3 = 'S';
                    break;
                }
                case 'v': {
                    c3 = 'b';
                    break;
                }
                case 'V': {
                    c3 = 'B';
                    break;
                }
                case 'w': {
                    c3 = 'w';
                    break;
                }
                case 'W': {
                    c3 = 'W';
                    break;
                }
                case 'y': {
                    c3 = 'r';
                    break;
                }
                case 'Y': {
                    c3 = 'R';
                    break;
                }
                case 'n': {
                    c3 = 'n';
                    break;
                }
                case 'N': {
                    c3 = 'N';
                    break;
                }
                case 'x': {
                    c3 = 'x';
                }
            }
            stringBuffer.setCharAt(n - i - 1, c3);
        }
        return stringBuffer.toString();
    }
}

