/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBBulkUpdateHandler;
import com.hp.hpl.jena.db.impl.DBPrefixMappingImpl;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.db.impl.DBReifier;
import com.hp.hpl.jena.db.impl.DBTransactionHandler;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphRDB
extends GraphBase
implements Graph {
    public static final String DEFAULT = "DEFAULT";
    protected IRDBDriver m_driver = null;
    protected DBPropGraph m_properties = null;
    protected DBPrefixMappingImpl m_prefixMapping = null;
    protected List m_specializedGraphs = null;
    protected List m_specializedGraphReifiers = null;
    protected List m_specializedGraphAsserted = null;
    protected List m_specializedGraphsAll = null;
    protected Reifier m_reifier = null;
    protected int m_reificationBehaviour = 0;
    public static final int OPTIMIZE_ALL_REIFICATIONS_AND_HIDE_NOTHING = 1;
    public static final int OPTIMIZE_AND_HIDE_FULL_AND_PARTIAL_REIFICATIONS = 2;
    public static final int OPTIMIZE_AND_HIDE_ONLY_FULL_REIFICATIONS = 3;
    private DBQueryHandler q = null;

    public static int styleRDB(ReificationStyle style) {
        if (style == ReificationStyle.Standard) {
            return 1;
        }
        if (style == ReificationStyle.Convenient) {
            return 2;
        }
        if (style == ReificationStyle.Minimal) {
            return 3;
        }
        throw new JenaException("unsupported reification style");
    }

    public static ReificationStyle styleRDB(int behaviour) {
        if (behaviour == 1) {
            return ReificationStyle.Standard;
        }
        if (behaviour == 2) {
            return ReificationStyle.Convenient;
        }
        if (behaviour == 3) {
            return ReificationStyle.Minimal;
        }
        throw new JenaException("unsupported reification behaviour");
    }

    public GraphRDB(IDBConnection con, String graphID, Graph requestedProperties, boolean isNew) {
        this(con, graphID, requestedProperties, 2, isNew);
    }

    public GraphRDB(IDBConnection con, String graphID, Graph requestedProperties, int reificationBehaviour, boolean isNew) {
        super(GraphRDB.styleRDB(reificationBehaviour));
        this.m_reificationBehaviour = reificationBehaviour;
        if (graphID == null) {
            graphID = DEFAULT;
        } else if (graphID.equals(DEFAULT)) {
            throw new JenaException("The model name \"DEFAULT\" is reserved.");
        }
        this.m_driver = con.getDriver();
        SpecializedGraph sysGraph = this.m_driver.getSystemSpecializedGraph(true);
        this.m_properties = DBPropGraph.findPropGraphByName(sysGraph, graphID);
        if (this.m_properties != null) {
            if (isNew) {
                throw new AlreadyExistsException(graphID);
            }
            if (requestedProperties != null) {
                throw new RDFRDBException("Error: attempt to change a graph's properties after it has been used.");
            }
            this.m_specializedGraphsAll = this.m_driver.recreateSpecializedGraphs(this.m_properties);
        } else {
            if (!isNew) {
                throw new DoesNotExistException(graphID);
            }
            if (requestedProperties == null) {
                throw new RDFRDBException("Error: requested properties is null");
            }
            this.m_specializedGraphsAll = this.m_driver.createSpecializedGraphs(graphID, requestedProperties);
            this.m_properties = DBPropGraph.findPropGraphByName(sysGraph, graphID);
            if (this.m_properties == null) {
                throw new RDFRDBException("Graph properties not found after creating graph.");
            }
        }
        this.m_specializedGraphReifiers = new ArrayList();
        this.m_specializedGraphAsserted = new ArrayList();
        Iterator it = this.m_specializedGraphsAll.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof SpecializedGraphReifier) {
                this.m_specializedGraphReifiers.add(o);
                continue;
            }
            this.m_specializedGraphAsserted.add(o);
        }
        this.m_specializedGraphs = this.m_specializedGraphsAll;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities(){

                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return this.capabilities;
    }

    public Node getNode() {
        if (this.m_properties == null) {
            throw new RDFRDBException("Error - attempt to call getNode() on a GraphRDB that has already been removed");
        }
        return this.m_properties.getNode();
    }

    public ExtendedIterator getPropertyTriples() {
        if (this.m_properties == null) {
            throw new RDFRDBException("Error - attempt to call getPropertyTriples on a GraphRDB that has been removed.");
        }
        return this.m_properties.listTriples();
    }

    protected boolean isOpen() {
        return this.m_specializedGraphs != null;
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new ClosedException("GraphRDB", this);
        }
    }

    public void performAdd(Triple t) {
        this.checkOpen();
        SpecializedGraph.CompletionFlag complete = new SpecializedGraph.CompletionFlag();
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            SpecializedGraph sg = (SpecializedGraph)it.next();
            if (sg instanceof SpecializedGraphReifier && this.m_reificationBehaviour == 3) continue;
            sg.add(t, complete);
            if (!complete.isDone()) continue;
            return;
        }
        throw new JenaException("Error - GraphRDB.add(Triple) failed to find a suitable store for the triple:" + t.toString());
    }

    public void add(List triples) {
        this.checkOpen();
        ArrayList localTriples = new ArrayList(triples);
        SpecializedGraph.CompletionFlag complete = new SpecializedGraph.CompletionFlag();
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            SpecializedGraph sg = (SpecializedGraph)it.next();
            if (sg instanceof SpecializedGraphReifier && this.m_reificationBehaviour == 3) continue;
            sg.add(localTriples, complete);
            if (!complete.isDone()) continue;
            return;
        }
        throw new JenaException("Error - GraphRDB.add(List) failed to find a suitable store for at least one triple:" + triples.get(0).toString());
    }

    public void performDelete(Triple t) {
        this.checkOpen();
        SpecializedGraph.CompletionFlag complete = new SpecializedGraph.CompletionFlag();
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            SpecializedGraph sg = (SpecializedGraph)it.next();
            if (sg instanceof SpecializedGraphReifier && this.m_reificationBehaviour == 3) continue;
            sg.delete(t, complete);
            if (!complete.isDone()) continue;
            return;
        }
        throw new JenaException("Error - GraphRDB.delete(Triple) failed to find a suitable store for the triple:" + t.toString());
    }

    public void delete(List triples) {
        this.checkOpen();
        ArrayList localTriples = new ArrayList(triples);
        SpecializedGraph.CompletionFlag complete = new SpecializedGraph.CompletionFlag();
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            SpecializedGraph sg = (SpecializedGraph)it.next();
            if (sg instanceof SpecializedGraphReifier && this.m_reificationBehaviour == 3) continue;
            sg.delete(localTriples, complete);
            if (!complete.isDone()) continue;
            return;
        }
        throw new JenaException("Error - GraphRDB.delete(Triple) failed to find a suitable store for at least one triple:" + triples.get(0).toString());
    }

    public int graphBaseSize() {
        this.checkOpen();
        int result = 0;
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            SpecializedGraph sg = (SpecializedGraph)it.next();
            if (sg instanceof SpecializedGraphReifier && (this.m_reificationBehaviour == 3 || this.m_reificationBehaviour == 2)) continue;
            result += sg.tripleCount();
        }
        return result;
    }

    public boolean graphBaseContains(Triple t) {
        this.checkOpen();
        SpecializedGraph.CompletionFlag complete = new SpecializedGraph.CompletionFlag();
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            boolean result;
            SpecializedGraph sg = (SpecializedGraph)it.next();
            if (sg instanceof SpecializedGraphReifier && (this.m_reificationBehaviour == 3 || this.m_reificationBehaviour == 2) || !(result = sg.contains(t, complete)) && !complete.isDone()) continue;
            return result;
        }
        return false;
    }

    public ExtendedIterator graphBaseFind(TripleMatch m) {
        this.checkOpen();
        ExtendedIterator result = NullIterator.instance;
        SpecializedGraph.CompletionFlag complete = new SpecializedGraph.CompletionFlag();
        Iterator it = this.m_specializedGraphs.iterator();
        while (it.hasNext()) {
            SpecializedGraph sg = (SpecializedGraph)it.next();
            if (sg instanceof SpecializedGraphReifier && (this.m_reificationBehaviour == 3 || this.m_reificationBehaviour == 2)) continue;
            ExtendedIterator partialResult = sg.find(m, complete);
            result = result.andThen(partialResult);
            if (!complete.isDone()) continue;
            break;
        }
        return SimpleEventManager.notifyingRemove(this, result);
    }

    public ExtendedIterator reifierTriples(TripleMatch m) {
        return NullIterator.instance;
    }

    public int reifierSize() {
        return 0;
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return new DBBulkUpdateHandler(this);
    }

    public Reifier getReifier() {
        if (this.m_reifier == null) {
            this.m_reifier = new DBReifier(this, this.style, this.m_specializedGraphReifiers, this.m_specializedGraphReifiers);
        }
        return this.m_reifier;
    }

    public PrefixMapping getPrefixMapping() {
        if (this.m_prefixMapping == null) {
            this.m_prefixMapping = new DBPrefixMappingImpl(this.m_properties);
        }
        return this.m_prefixMapping;
    }

    public TransactionHandler getTransactionHandler() {
        return new DBTransactionHandler(this.m_driver, this);
    }

    public synchronized void close() {
        if (this.m_specializedGraphs != null) {
            Iterator it = this.m_specializedGraphs.iterator();
            while (it.hasNext()) {
                SpecializedGraph sg = (SpecializedGraph)it.next();
                sg.close();
            }
            this.m_specializedGraphs = null;
        }
    }

    public synchronized void remove() {
        this.checkOpen();
        this.m_driver.removeSpecializedGraphs(this.m_properties, this.m_specializedGraphs);
        this.m_properties = null;
        this.m_specializedGraphs = null;
    }

    public IDBConnection getConnection() {
        if (this.m_driver == null) {
            return null;
        }
        return this.m_driver.getConnection();
    }

    public int reificationBehavior() {
        return this.m_reificationBehaviour;
    }

    public Iterator getSpecializedGraphs() {
        return this.m_specializedGraphs.iterator();
    }

    public QueryHandler queryHandler() {
        if (this.q == null) {
            this.q = new DBQueryHandler(this);
        }
        return this.q;
    }

    public DBQueryHandler DBqueryHandler() {
        if (this.q == null) {
            this.queryHandler();
        }
        return this.q;
    }

    public boolean getDoDuplicateCheck() {
        return this.m_driver.getDoDuplicateCheck();
    }

    public void setDoDuplicateCheck(boolean bool) {
        boolean nb;
        this.m_driver.setDoDuplicateCheck(bool);
        boolean bl = nb = !bool;
        if (this.isOpen()) {
            Iterator it = this.m_specializedGraphs.iterator();
            while (it.hasNext()) {
                SpecializedGraph sg = (SpecializedGraph)it.next();
                sg.getPSet().setSkipDuplicateCheck(nb);
            }
        }
    }

    public void setDoFastpath(boolean val) {
        this.DBqueryHandler().setDoFastpath(val);
    }

    public boolean getDoFastpath() {
        return this.DBqueryHandler().getDoFastpath();
    }

    public void setQueryOnlyAsserted(boolean opt) {
        if (opt) {
            this.m_specializedGraphs = this.m_specializedGraphAsserted;
            this.DBqueryHandler().setQueryOnlyReified(false);
        } else {
            this.m_specializedGraphs = this.m_specializedGraphsAll;
        }
        this.DBqueryHandler().setQueryOnlyAsserted(opt);
    }

    public boolean getQueryOnlyAsserted() {
        return this.DBqueryHandler().getQueryOnlyAsserted();
    }

    public void setQueryOnlyReified(boolean opt) {
        if (opt) {
            this.m_specializedGraphs = this.m_specializedGraphReifiers;
            this.DBqueryHandler().setQueryOnlyAsserted(false);
        } else {
            this.m_specializedGraphs = this.m_specializedGraphsAll;
        }
        this.DBqueryHandler().setQueryOnlyReified(opt);
    }

    public boolean getQueryOnlyReified() {
        return this.DBqueryHandler().getQueryOnlyReified();
    }

    public void setQueryFullReified(boolean opt) {
        this.DBqueryHandler().setQueryFullReified(opt);
    }

    public boolean getQueryFullReified() {
        return this.DBqueryHandler().getQueryFullReified();
    }

    public void setDoImplicitJoin(boolean val) {
        this.DBqueryHandler().setDoImplicitJoin(val);
    }
}

