/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;

public abstract class DBProp {
    protected SpecializedGraph graph = null;
    protected Node self = null;

    public DBProp(SpecializedGraph g) {
        this.graph = g;
        this.self = DBProp.generateNodeURI();
    }

    public DBProp(SpecializedGraph g, Node n) {
        this.graph = g;
        this.self = n;
    }

    public Node getNode() {
        return this.self;
    }

    protected static SpecializedGraph.CompletionFlag newComplete() {
        return new SpecializedGraph.CompletionFlag();
    }

    protected void putPropString(Node_URI predicate, String value) {
        this.putPropNode(predicate, Node.createLiteral(value));
    }

    protected void putPropNode(Node_URI predicate, Node node) {
        this.graph.add(Triple.create(this.self, predicate, node), DBProp.newComplete());
    }

    protected String getPropString(Node_URI predicate) {
        ExtendedIterator it = this.graph.find(this.self, predicate, null, DBProp.newComplete());
        if (!it.hasNext()) {
            it.close();
            return null;
        }
        Node result = ((Triple)it.next()).getObject();
        it.close();
        return result.getLiteralLexicalForm();
    }

    protected void remove() {
        SpecializedGraph.CompletionFlag complete = DBProp.newComplete();
        ExtendedIterator it = this.graph.find(this.self, null, null, complete);
        while (it.hasNext()) {
            this.graph.delete((Triple)it.next(), complete);
        }
        it.close();
        this.self = null;
        this.graph = null;
    }

    void showGraph() {
        SpecializedGraph.CompletionFlag complete = DBProp.newComplete();
        ExtendedIterator it = this.graph.find(this.self, null, null, complete);
        while (it.hasNext()) {
            System.err.println(">> " + it.next());
        }
    }

    public static ExtendedIterator listTriples(SpecializedGraph g, Node self) {
        return g.find(self, null, null, DBProp.newComplete());
    }

    protected static Node findProperty(Graph graph, Node_URI predicate) {
        ExtendedIterator it = graph.find(null, predicate, null);
        Node result = null;
        if (it.hasNext()) {
            result = ((Triple)it.next()).getObject();
        }
        it.close();
        return result;
    }

    public static String generateUniqueID() {
        String hostname;
        UID uid = new UID();
        try {
            hostname = InetAddress.getLocalHost().getHostAddress().toString();
        }
        catch (UnknownHostException e) {
            hostname = "localhost";
        }
        return (hostname + uid.toString()).replace('.', '_').replace(':', '_').replace('-', '_');
    }

    public static Node generateNodeURI() {
        Object generateUniqueID = null;
        return Node.createURI("http://jena.hpl.hp.com/2003/04/DB#" + DBProp.generateUniqueID());
    }
}

