/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBPattern;
import com.hp.hpl.jena.db.impl.DBQuery;
import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.db.impl.Free;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarDesc;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Element;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Fixed;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DBQueryStageCompiler {
    protected static Log logger = LogFactory.getLog(DBQueryStageCompiler.class);

    public static DBQuery compile(DBQueryStageCompiler compiler, DBQueryHandler qh, SpecializedGraph sg, List varList, List dbPat, ExpressionSet constraints) {
        DBQuery query = new DBQuery(sg, varList, qh.queryOnlyStmt, qh.queryOnlyReif, qh.queryFullReif);
        if (qh.getQueryOnlyReified() && !qh.getQueryFullReified()) {
            throw new JenaException("Fastpath currently requires QueryFullReified to be true if QueryOnlyReified is also true");
        }
        if (!query.isEmpty) {
            for (int i = 0; i < dbPat.size(); ++i) {
                DBQueryStageCompiler.compilePattern(compiler, query, (DBPattern)dbPat.get(i));
            }
            DBQueryStageCompiler.compileConstraints(compiler, query, constraints);
            DBQueryStageCompiler.compileQuery(compiler, query);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("generated SQL: " + query.stmt);
        }
        return query;
    }

    private static void compilePattern(DBQueryStageCompiler compiler, DBQuery query, DBPattern dbpat) {
        Element subj = dbpat.S;
        Element obj = dbpat.O;
        Element pred = dbpat.P;
        String qual = "";
        int alias = query.aliasCnt;
        if (query.isReifier) {
            char reifProp;
            boolean newAlias = true;
            if (!(pred instanceof Fixed)) {
                throw new JenaException("Reifier predicate not bound");
            }
            Node p = ((Fixed)pred).asNodeMatch(null);
            if (p.equals(RDF.Nodes.subject)) {
                reifProp = 'S';
            } else if (p.equals(RDF.Nodes.predicate)) {
                reifProp = 'P';
            } else if (p.equals(RDF.Nodes.object)) {
                reifProp = 'O';
            } else if (p.equals(RDF.Nodes.type)) {
                reifProp = 'T';
            } else {
                throw new JenaException("Unexpected reifier predicate");
            }
            if (!subj.equals(Element.ANY)) {
                if (query.qryFullReif && subj instanceof Free && query.getBinding(((Free)subj).getListing()).isBoundToCol()) {
                    alias = query.getBinding((int)((Free)subj).getListing()).alias;
                    newAlias = false;
                } else {
                    qual = query.sqlAnd.gen(DBQueryStageCompiler.getQual(query, alias, 'N', subj));
                }
            }
            qual = qual + query.sqlAnd.gen(DBQueryStageCompiler.getQual(query, alias, reifProp, obj));
            qual = qual + query.sqlAnd.gen(query.driver.genSQLQualGraphId(alias, query.graphId));
            if (newAlias) {
                query.newAlias();
            }
        } else {
            qual = query.sqlAnd.gen(DBQueryStageCompiler.getQual(query, alias, 'S', subj));
            qual = qual + query.sqlAnd.gen(DBQueryStageCompiler.getQual(query, alias, 'P', pred));
            qual = qual + query.sqlAnd.gen(DBQueryStageCompiler.getQual(query, alias, 'O', obj));
            qual = qual + query.sqlAnd.gen(query.driver.genSQLQualGraphId(alias, query.graphId));
            query.newAlias();
        }
        query.stmt = query.stmt + qual;
    }

    private static String getQual(DBQuery query, int alias, char pred, Element spo) {
        String qual = "";
        if (spo instanceof Fixed) {
            Node obj = ((Fixed)spo).asNodeMatch(null);
            qual = query.isReifier ? query.driver.genSQLReifQualConst(alias, pred, obj) : query.driver.genSQLQualConst(alias, pred, obj);
        } else if (spo instanceof Free) {
            Free v = (Free)spo;
            VarDesc bind = query.getBinding(v.getListing());
            if (v.isArg() && !bind.isBoundToCol) {
                ++query.argCnt;
                query.argType = query.argType + pred;
                query.argIndex.add(new Integer(v.getMapping()));
                qual = query.driver.genSQLQualParam(alias, pred);
                bind.bindToCol(alias, pred);
            } else if (bind.isBoundToCol()) {
                qual = query.driver.genSQLJoin(bind.alias, bind.column, alias, pred);
            } else {
                bind.bindToCol(alias, pred);
                qual = "";
            }
        } else if (spo != Element.ANY) {
            throw new JenaException("Invalid Element in qualifier");
        }
        return qual;
    }

    private static void compileConstraints(DBQueryStageCompiler compiler, DBQuery query, ExpressionSet constraints) {
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            VarDesc bind = query.findBinding(e.getArg(0).getName());
            if (bind == null) {
                throw new JenaException("Unbound variable in constraint");
            }
            String strMat = ((Expression.Fixed)e.getArg(1)).toString();
            query.stmt = query.stmt + query.sqlAnd.gen(query.driver.genSQLStringMatch(bind.alias, bind.column, e.getFun(), strMat));
        }
    }

    private static void compileQuery(DBQueryStageCompiler compiler, DBQuery query) {
        int resCnt = query.vars.length - query.argCnt;
        query.resList = new int[resCnt];
        query.stmt = query.driver.genSQLSelectStmt(query.driver.genSQLResList(query.resList, query.vars), query.driver.genSQLFromList(query.aliasCnt, query.table), query.stmt);
    }
}

