/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri;

import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import java.net.URISyntaxException;
import org.xml.sax.Locator;

public class IRIException
extends RuntimeException {
    final int conformanceLevel;
    final int line;
    final int column;
    final String file;

    public IRIException(int lvl, IRIFactory f, String message) {
        super(message);
        this.conformanceLevel = lvl;
        Locator l = f.locator;
        this.file = l.getSystemId();
        this.line = l.getLineNumber();
        this.column = l.getColumnNumber();
    }

    public IRIException(int lvl, IRIFactory f, URISyntaxException cause) {
        this(lvl, f, (Exception)cause);
    }

    public IRIException(int lvl, IRIFactory f, MalformedURIException cause) {
        this(lvl, f, (Exception)cause);
    }

    private IRIException(int lvl, IRIFactory fact, Exception e) {
        super(e);
        this.conformanceLevel = lvl;
        Locator l = fact.locator;
        this.file = l.getSystemId();
        this.line = l.getLineNumber();
        this.column = l.getColumnNumber();
    }

    public int getConformance() {
        return this.conformanceLevel;
    }
}

