/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.shared.JenaException;

public class ModelFactoryBase {
    public static String guessDBURL() {
        return ModelFactoryBase.gp("db.url");
    }

    public static String guessDBUser() {
        return ModelFactoryBase.gp("db.user", "test");
    }

    public static String guessDBPassword() {
        return ModelFactoryBase.gp("db.password", "");
    }

    public static String guessDBType() {
        String possible = ModelFactoryBase.gp("db.type", null);
        if (possible == null) {
            possible = ModelFactoryBase.extractType(ModelFactoryBase.guessDBURL());
        }
        if (possible == null) {
            throw new JenaException("cannot guess database type");
        }
        return possible;
    }

    public static String guessDBDriver() {
        return ModelFactoryBase.gp("db.driver", null);
    }

    public static String extractType(String dbURL) {
        int a = dbURL.indexOf(58);
        int b = dbURL.indexOf(58, a + 1);
        return dbURL.substring(a + 1, b);
    }

    protected static String gp(String name) {
        String answer = ModelFactoryBase.gp(name, null);
        if (answer == null) {
            throw new JenaException("no binding for " + name);
        }
        return answer;
    }

    protected static String gp(String name, String ifAbsent) {
        String answer = System.getProperty("jena." + name);
        return answer == null ? ifAbsent : answer;
    }
}

