/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.vocabulary.RDF;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyImpl
extends ResourceImpl
implements Property {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node n, EnhGraph eg) {
            return n.isURI();
        }

        public EnhNode wrap(Node n, EnhGraph eg) {
            return new PropertyImpl(n, eg);
        }
    };
    protected static Log logger = LogFactory.getLog(PropertyImpl.class);
    protected int ordinal = 0;

    public PropertyImpl(String uri) {
        super(uri);
        this.checkLocalName();
        this.checkOrdinal();
    }

    public RDFNode inModel(Model m) {
        return this.getModel() == m ? this : m.createProperty(this.getURI());
    }

    private void checkLocalName() {
        String localName = this.getLocalName();
        if (localName == null || localName.equals("")) {
            throw new InvalidPropertyURIException(this.getURI());
        }
    }

    public PropertyImpl(String nameSpace, String localName) {
        super(nameSpace, localName);
        this.checkLocalName();
        this.checkOrdinal();
    }

    public PropertyImpl(String uri, ModelCom m) {
        super(uri, m);
        this.checkOrdinal();
    }

    public PropertyImpl(String nameSpace, String localName, ModelCom m) {
        super(nameSpace, localName, m);
        this.checkOrdinal();
    }

    public PropertyImpl(Node n, EnhGraph m) {
        super(n, m);
        this.checkOrdinal();
    }

    public PropertyImpl(String nameSpace, String localName, int ordinal, ModelCom m) {
        super(nameSpace, localName, m);
        this.checkLocalName();
        this.ordinal = ordinal;
    }

    public boolean isProperty() {
        return true;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    protected void checkOrdinal() {
        String nameSpace = this.getNameSpace();
        String localName = this.getLocalName();
        if (localName.length() > 0 && localName.charAt(0) == '_' && nameSpace.equals(RDF.getURI()) && nameSpace.equals(RDF.getURI()) && localName.length() > 1) {
            for (int i = 1; i < localName.length(); ++i) {
                char c = localName.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return;
            }
            try {
                this.ordinal = Integer.parseInt(localName.substring(1));
            }
            catch (NumberFormatException e) {
                logger.error("checkOrdinal fails on " + localName, e);
            }
        }
    }
}

