/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import org.apache.xerces.util.XMLChar;

public class Util {
    public static final String CLASSPATH = "com.hp.hpl.jena";

    public static int splitNamespace(String uri) {
        int j;
        char ch;
        int lg = uri.length();
        if (lg == 0) {
            return 0;
        }
        for (int i = lg - 1; i >= 1 && !Util.notNameChar(ch = uri.charAt(i)); --i) {
        }
        for (j = i + 1; j < lg && (!XMLChar.isNCNameStart(ch = uri.charAt(j)) || uri.charAt(j - 1) == ':' && uri.lastIndexOf(58, j - 2) == -1); ++j) {
        }
        return j;
    }

    public static boolean notNameChar(char ch) {
        return !XMLChar.isNCName(ch);
    }

    public static String substituteStandardEntities(String s) {
        s = Util.replace(s, "&", "&amp;");
        s = Util.replace(s, "<", "&lt;");
        s = Util.replace(s, ">", "&gt;");
        s = Util.replace(s, "'", "&apos;");
        s = Util.replace(s, "\t", "&#9;");
        s = Util.replace(s, "\n", "&#xA;");
        s = Util.replace(s, "\r", "&#xD;");
        return Util.replace(s, "\"", "&quot;");
    }

    public static String substituteEntitiesInElementContent(String s) {
        s = Util.replace(s, "&", "&amp;");
        return Util.replace(s, "<", "&lt;");
    }

    public static String replace(String s, String oldString, String newString) {
        String result = "";
        int length = oldString.length();
        int pos = s.indexOf(oldString);
        int lastPos = 0;
        while (pos >= 0) {
            result = result + s.substring(lastPos, pos) + newString;
            lastPos = pos + length;
            pos = s.indexOf(oldString, lastPos);
        }
        return result + s.substring(lastPos, s.length());
    }

    public static String XgetProperty(String p) {
        return Util.XgetProperty(p, null);
    }

    public static String XgetProperty(String p, String def) {
        try {
            return System.getProperty(p, def);
        }
        catch (SecurityException e) {
            return def;
        }
    }
}

