/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.parser.Q_URI;
import com.hp.hpl.jena.rdql.parser.RDQLParser;

public class Q_QuotedURI
extends Q_URI {
    String seen = "";
    boolean isAbsolute = false;
    static final String prefixOperator = ":";

    Q_QuotedURI(int id) {
        super(id);
    }

    Q_QuotedURI(RDQLParser p, int id) {
        super(p, id);
    }

    void set(String s) {
        this.seen = s;
    }

    public void jjtClose() {
        super._setURI(this.seen);
    }

    public void postParse(Query query) {
        super.postParse(query);
        if (!this.isAbsolute) {
            this.absolute(query);
        }
    }

    private void absolute(Query query) {
        if (query == null) {
            this.isAbsolute = true;
            return;
        }
        int i = this.seen.indexOf(prefixOperator);
        if (i < 0) {
            this.isAbsolute = true;
            return;
        }
        String prefix = this.seen.substring(0, i);
        String full = query.getPrefix(prefix);
        if (full == null) {
            this.isAbsolute = true;
            return;
        }
        String remainder = this.seen.substring(i + prefixOperator.length());
        super._setURI(full + remainder);
        this.isAbsolute = true;
    }

    public static Q_URI makeURI(String s) {
        Q_URI uri = new Q_URI(0);
        uri._setURI(s);
        return uri;
    }

    public String asQuotedString() {
        return "<" + this.seen + ">";
    }

    public String asUnquotedString() {
        return this.seen;
    }

    public String valueString() {
        return super.getURI();
    }

    public String toString() {
        return this.seen;
    }
}

