/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinRegistry;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasoner;
import com.hp.hpl.jena.reasoner.rulesys.OWLMiniReasoner;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasoner;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.RulesetNotFoundException;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.Tokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Rule
implements ClauseEntry {
    protected ClauseEntry[] body;
    protected ClauseEntry[] head;
    protected String name;
    protected int numVars = -1;
    protected boolean isBackward = false;
    protected boolean isMonotonic = true;
    static Log logger = LogFactory.getLog(Rule.class);

    public Rule(List head, List body) {
        this(null, head, body);
    }

    public Rule(String name, List head, List body) {
        this(name, head.toArray(new ClauseEntry[head.size()]), body.toArray(new ClauseEntry[body.size()]));
    }

    public Rule(String name, ClauseEntry[] head, ClauseEntry[] body) {
        this.name = name;
        this.head = head;
        this.body = body;
        this.isMonotonic = this.allMonotonic(head);
    }

    private boolean allMonotonic(ClauseEntry[] elts) {
        for (int i = 0; i < elts.length; ++i) {
            ClauseEntry elt = elts[i];
            if (!(elt instanceof Functor) || ((Functor)elt).getImplementor().isMonotonic()) continue;
            return false;
        }
        return true;
    }

    public int bodyLength() {
        return this.body.length;
    }

    public ClauseEntry getBodyElement(int n) {
        return this.body[n];
    }

    public ClauseEntry[] getBody() {
        return this.body;
    }

    public int headLength() {
        return this.head.length;
    }

    public ClauseEntry getHeadElement(int n) {
        return this.head[n];
    }

    public ClauseEntry[] getHead() {
        return this.head;
    }

    public boolean isBackward() {
        return this.isBackward;
    }

    public void setBackward(boolean flag) {
        this.isBackward = flag;
    }

    public String getName() {
        return this.name;
    }

    public void setNumVars(int n) {
        this.numVars = n;
    }

    public int getNumVars() {
        if (this.numVars == -1) {
            int max = this.findVars(this.body, -1);
            max = this.findVars(this.head, max);
            this.numVars = max + 1;
        }
        return this.numVars;
    }

    private int findVars(Object[] nodes, int maxIn) {
        int max = maxIn;
        for (int i = 0; i < nodes.length; ++i) {
            Object node = nodes[i];
            max = node instanceof TriplePattern ? this.findVars((TriplePattern)node, max) : this.findVars((Functor)node, max);
        }
        return max;
    }

    private int findVars(TriplePattern t, int maxIn) {
        int max = maxIn;
        max = this.maxVarIndex(t.getSubject(), max);
        max = this.maxVarIndex(t.getPredicate(), max);
        Node obj = t.getObject();
        if (obj instanceof Node_RuleVariable) {
            max = this.maxVarIndex(obj, max);
        } else if (Functor.isFunctor(obj)) {
            max = this.findVars((Functor)obj.getLiteralValue(), max);
        }
        return max;
    }

    private int findVars(Functor f, int maxIn) {
        int max = maxIn;
        Node[] args = f.getArgs();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].isVariable()) continue;
            max = this.maxVarIndex(args[i], max);
        }
        return max;
    }

    private int maxVarIndex(Node var, int max) {
        int index;
        if (var instanceof Node_RuleVariable && (index = ((Node_RuleVariable)var).index) > max) {
            return index;
        }
        return max;
    }

    public Rule instantiate(BindingEnvironment env) {
        HashMap vmap = new HashMap();
        return new Rule(this.name, this.cloneClauseArray(this.head, vmap, env), this.cloneClauseArray(this.body, vmap, env));
    }

    public Rule cloneRule() {
        if (this.getNumVars() > 0) {
            HashMap vmap = new HashMap();
            return new Rule(this.name, this.cloneClauseArray(this.head, vmap, null), this.cloneClauseArray(this.body, vmap, null));
        }
        return this;
    }

    private ClauseEntry[] cloneClauseArray(ClauseEntry[] clauses, Map vmap, BindingEnvironment env) {
        ClauseEntry[] cClauses = new ClauseEntry[clauses.length];
        for (int i = 0; i < clauses.length; ++i) {
            cClauses[i] = this.cloneClause(clauses[i], vmap, env);
        }
        return cClauses;
    }

    private ClauseEntry cloneClause(ClauseEntry clause, Map vmap, BindingEnvironment env) {
        if (clause instanceof TriplePattern) {
            TriplePattern tp = (TriplePattern)clause;
            return new TriplePattern(this.cloneNode(tp.getSubject(), vmap, env), this.cloneNode(tp.getPredicate(), vmap, env), this.cloneNode(tp.getObject(), vmap, env));
        }
        return this.cloneFunctor((Functor)clause, vmap, env);
    }

    private Functor cloneFunctor(Functor f, Map vmap, BindingEnvironment env) {
        Node[] args = f.getArgs();
        Node[] cargs = new Node[args.length];
        for (int i = 0; i < args.length; ++i) {
            cargs[i] = this.cloneNode(args[i], vmap, env);
        }
        Functor fn = new Functor(f.getName(), cargs);
        fn.setImplementor(f.getImplementor());
        return fn;
    }

    private Node cloneNode(Node nIn, Map vmap, BindingEnvironment env) {
        Node n;
        Node node = n = env == null ? nIn : env.getGroundVersion(nIn);
        if (n instanceof Node_RuleVariable) {
            Node_RuleVariable nv = (Node_RuleVariable)n;
            Node c = (Node)vmap.get(nv);
            if (c == null) {
                c = ((Node_RuleVariable)n).cloneNode();
                vmap.put(nv, c);
            }
            return c;
        }
        if (Functor.isFunctor(n)) {
            Functor f = (Functor)n.getLiteralValue();
            return Functor.makeFunctorNode(this.cloneFunctor(f, vmap, env));
        }
        return n;
    }

    public boolean isMonotonic() {
        return this.isMonotonic;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[ ");
        if (this.name != null) {
            buff.append(this.name);
            buff.append(": ");
        }
        if (this.isBackward) {
            int i;
            for (i = 0; i < this.head.length; ++i) {
                buff.append(PrintUtil.print(this.head[i]));
                buff.append(" ");
            }
            buff.append("<- ");
            for (i = 0; i < this.body.length; ++i) {
                buff.append(PrintUtil.print(this.body[i]));
                buff.append(" ");
            }
        } else {
            int i;
            for (i = 0; i < this.body.length; ++i) {
                buff.append(PrintUtil.print(this.body[i]));
                buff.append(" ");
            }
            buff.append("-> ");
            for (i = 0; i < this.head.length; ++i) {
                buff.append(PrintUtil.print(this.head[i]));
                buff.append(" ");
            }
        }
        buff.append("]");
        return buff.toString();
    }

    public String toShortString() {
        if (this.name != null) {
            return this.name;
        }
        return this.toString();
    }

    public static Rule parseRule(String source) throws ParserException {
        Parser parser2 = new Parser(source);
        return parser2.parseRule();
    }

    public static List rulesFromURL(String uri) {
        try {
            BufferedReader br = FileUtils.readerFromURL(uri);
            return Rule.parseRules(Rule.rulesParserFromReader(br));
        }
        catch (WrappedIOException e) {
            throw new RulesetNotFoundException(uri);
        }
    }

    public static String rulesStringFromReader(BufferedReader src) {
        try {
            String line;
            StringBuffer result = new StringBuffer();
            while ((line = src.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith("//")) continue;
                result.append(line);
                result.append("\n");
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    public static Parser rulesParserFromReader(BufferedReader src) {
        try {
            String line;
            StringBuffer result = new StringBuffer();
            HashMap<String, String> prefixes = new HashMap<String, String>();
            ArrayList preloadedRules = new ArrayList();
            while ((line = src.readLine()) != null) {
                if (line.startsWith("#") || (line = line.trim()).startsWith("//")) continue;
                if (line.startsWith("@prefix")) {
                    line = line.substring("@prefix".length());
                    String prefix = Rule.nextArg(line);
                    String rest = Rule.nextAfterArg(line);
                    if (prefix.endsWith(":")) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    String url = Rule.extractURI(rest);
                    prefixes.put(prefix, url);
                    continue;
                }
                if (line.startsWith("@include")) {
                    String url = Rule.extractURI(line = line.substring("@include".length()));
                    if (url.equalsIgnoreCase("rdfs")) {
                        preloadedRules.addAll(RDFSFBRuleReasoner.loadRules());
                        continue;
                    }
                    if (url.equalsIgnoreCase("owl")) {
                        preloadedRules.addAll(OWLFBRuleReasoner.loadRules());
                        continue;
                    }
                    if (url.equalsIgnoreCase("owlmicro")) {
                        preloadedRules.addAll(OWLMicroReasoner.loadRules());
                        continue;
                    }
                    if (url.equalsIgnoreCase("owlmini")) {
                        preloadedRules.addAll(OWLMiniReasoner.loadRules());
                        continue;
                    }
                    preloadedRules.addAll(Rule.rulesFromURL(url));
                    continue;
                }
                result.append(line);
                result.append("\n");
            }
            Parser parser2 = new Parser(result.toString());
            parser2.registerPrefixMap(prefixes);
            parser2.addRulesPreload(preloadedRules);
            return parser2;
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    private static String extractURI(String lineSoFar) {
        String token = lineSoFar.trim();
        if (token.startsWith("<")) {
            int split = token.indexOf(62);
            token = token.substring(1, split);
        }
        return token;
    }

    private static String nextArg(String token) {
        int start = Rule.nextSplit(0, false, token);
        int stop = Rule.nextSplit(start, true, token);
        return token.substring(start, stop);
    }

    private static String nextAfterArg(String token) {
        int start = Rule.nextSplit(0, false, token);
        int stop = Rule.nextSplit(start, true, token);
        int rest = Rule.nextSplit(stop, false, token);
        return token.substring(rest);
    }

    private static int nextSplit(int start, boolean white, String line) {
        int i;
        for (i = start; i < line.length(); ++i) {
            boolean isWhite = Character.isWhitespace(line.charAt(i));
            if (!(white & isWhite) && !(!white & !isWhite)) continue;
            return i;
        }
        return i;
    }

    public static void main(String[] args) {
        String test3 = " <http://myuri/fool>.";
        String arg = Rule.nextArg(test3);
        String rest = Rule.nextAfterArg(test3);
        String uri = Rule.extractURI(rest);
        System.out.println("ARG = [" + arg + "], URI = [" + uri + "]");
    }

    public static List parseRules(Parser parser2) throws ParserException {
        boolean finished = false;
        ArrayList<Rule> ruleset = new ArrayList<Rule>();
        ruleset.addAll(parser2.getRulesPreload());
        while (!finished) {
            try {
                parser2.peekToken();
            }
            catch (NoSuchElementException e) {
                finished = true;
                break;
            }
            Rule rule = parser2.parseRule();
            ruleset.add(rule);
        }
        return ruleset;
    }

    public static List parseRules(String source) throws ParserException {
        return Rule.parseRules(new Parser(source));
    }

    public boolean equals(Object o) {
        int i;
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)o;
        if (other.head.length != this.head.length) {
            return false;
        }
        if (other.body.length != this.body.length) {
            return false;
        }
        for (i = 0; i < this.body.length; ++i) {
            if (this.body[i].sameAs(other.body[i])) continue;
            return false;
        }
        for (i = 0; i < this.head.length; ++i) {
            if (this.head[i].sameAs(other.head[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i;
        int hash = 0;
        for (i = 0; i < this.body.length; ++i) {
            hash = hash << 1 ^ this.body[i].hashCode();
        }
        for (i = 0; i < this.head.length; ++i) {
            hash = hash << 1 ^ this.head[i].hashCode();
        }
        return hash;
    }

    public boolean sameAs(Object o) {
        return this.equals(o);
    }

    public static class ParserException
    extends JenaException {
        public ParserException(String message, Parser parser2) {
            super(ParserException.constructMessage(message, parser2));
        }

        private static String constructMessage(String baseMessage, Parser parser2) {
            StringBuffer message = new StringBuffer();
            message.append(baseMessage);
            message.append("\nAt '");
            message.append(parser2.recentTokens());
            message.append("'");
            return message.toString();
        }
    }

    public static class Parser {
        private Tokenizer stream;
        private String lookahead;
        private static final int NORMAL = 0;
        private static final int STARTED_LITERAL = 1;
        private int literalState = 0;
        protected List priorTokens = new ArrayList();
        private static final int maxPriors = 20;
        private Map varMap;
        private PrefixMapping prefixMapping = PrefixMapping.Factory.create();
        private List preloadedRules = new ArrayList();

        Parser(String source) {
            this.stream = new Tokenizer(source, "()[], \t\n\r", "'\"", true);
            this.lookahead = null;
        }

        public void registerPrefix(String prefix, String namespace) {
            this.prefixMapping.setNsPrefix(prefix, namespace);
        }

        public void registerPrefixMap(Map map) {
            this.prefixMapping.setNsPrefixes(map);
        }

        public Map getPrefixMap() {
            return this.prefixMapping.getNsPrefixMap();
        }

        void addRulesPreload(List rules) {
            this.preloadedRules.addAll(rules);
        }

        public List getRulesPreload() {
            return this.preloadedRules;
        }

        String nextToken() {
            if (this.lookahead != null) {
                String temp = this.lookahead;
                this.lookahead = null;
                return temp;
            }
            String token = this.stream.nextToken();
            if (this.literalState == 0) {
                while (this.isSeparator(token)) {
                    token = this.stream.nextToken();
                }
            }
            if (token.equals("'")) {
                this.literalState = this.literalState == 0 ? 1 : 0;
            }
            this.priorTokens.add(0, token);
            if (this.priorTokens.size() > 20) {
                this.priorTokens.remove(this.priorTokens.size() - 1);
            }
            return token;
        }

        public String recentTokens() {
            StringBuffer trace = new StringBuffer();
            for (int i = this.priorTokens.size() - 1; i >= 0; --i) {
                trace.append(this.priorTokens.get(i));
                trace.append(" ");
            }
            return trace.toString();
        }

        String peekToken() {
            if (this.lookahead == null) {
                this.lookahead = this.nextToken();
            }
            return this.lookahead;
        }

        void pushback(String token) {
            this.lookahead = token;
        }

        boolean isSeparator(String token) {
            if (token.length() == 1) {
                char c = token.charAt(0);
                return c == ',' || Character.isWhitespace(c);
            }
            return false;
        }

        boolean isSyntax(String token) {
            if (token.length() == 1) {
                char c = token.charAt(0);
                return c == '(' || c == ')' || c == '[' || c == ']';
            }
            return false;
        }

        Node_RuleVariable getNodeVar(String name) {
            Node_RuleVariable node = (Node_RuleVariable)this.varMap.get(name);
            if (node == null) {
                node = new Node_RuleVariable(name, this.varMap.size());
                this.varMap.put(name, node);
            }
            return node;
        }

        Node parseNode(String token) {
            if (token.startsWith("?")) {
                return this.getNodeVar(token);
            }
            if (token.equals("*") || token.equals("_")) {
                throw new ParserException("Wildcard variables no longer supported", this);
            }
            if (token.indexOf(58) != -1) {
                String prefix;
                String exp = this.prefixMapping.expandPrefix(token);
                if (!((exp = PrintUtil.expandQname(exp)) != token || (prefix = token.substring(0, token.indexOf(58))).equals("http") || prefix.equals("urn") || prefix.equals("ftp") || prefix.equals("mailto"))) {
                    throw new ParserException("Unrecognized qname prefix (" + prefix + ") in rule", this);
                }
                return Node.createURI(exp);
            }
            if (this.peekToken().equals("(")) {
                Functor f = new Functor(token, this.parseNodeList(), BuiltinRegistry.theRegistry);
                return Functor.makeFunctorNode(f);
            }
            if (token.equals("'") || token.equals("\"")) {
                String lit = this.nextToken();
                this.nextToken();
                if (this.peekToken().startsWith("^^")) {
                    String dtURI = this.nextToken().substring(2);
                    if (dtURI.startsWith("xsd:")) {
                        dtURI = "http://www.w3.org/2001/XMLSchema#" + dtURI.substring(4);
                    }
                    RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
                    return Node.createLiteral(lit, "", dt);
                }
                return Node.createLiteral(lit, "", false);
            }
            if (Character.isDigit(token.charAt(0)) || token.charAt(0) == '-' && token.length() > 1 && Character.isDigit(token.charAt(1))) {
                return this.parseNumber(token);
            }
            return Node.createURI(token);
        }

        Node parseNumber(String lit) {
            if (Character.isDigit(lit.charAt(0)) || lit.charAt(0) == '-' && lit.length() > 1 && Character.isDigit(lit.charAt(1))) {
                if (lit.indexOf(".") != -1) {
                    if (XSDDatatype.XSDfloat.isValid(lit)) {
                        return Node.createLiteral(lit, "", XSDDatatype.XSDfloat);
                    }
                } else if (XSDDatatype.XSDint.isValid(lit)) {
                    return Node.createLiteral(lit, "", XSDDatatype.XSDint);
                }
            }
            return Node.createLiteral(lit, "", false);
        }

        List parseNodeList() {
            String token = this.nextToken();
            if (!token.equals("(")) {
                throw new ParserException("Expected '(' at start of clause, found " + token, this);
            }
            token = this.nextToken();
            ArrayList<Node> nodeList = new ArrayList<Node>();
            while (!this.isSyntax(token)) {
                nodeList.add(this.parseNode(token));
                token = this.nextToken();
            }
            if (!token.equals(")")) {
                throw new ParserException("Expected ')' at end of clause, found " + token, this);
            }
            return nodeList;
        }

        Object parseClause() {
            List args;
            String token = this.peekToken();
            if (token.equals("(")) {
                List nodes = this.parseNodeList();
                if (nodes.size() != 3) {
                    throw new ParserException("Triple with " + nodes.size() + " nodes!", this);
                }
                if (Functor.isFunctor((Node)nodes.get(0))) {
                    throw new ParserException("Functors not allowed in subject position of pattern", this);
                }
                if (Functor.isFunctor((Node)nodes.get(1))) {
                    throw new ParserException("Functors not allowed in predicate position of pattern", this);
                }
                return new TriplePattern((Node)nodes.get(0), (Node)nodes.get(1), (Node)nodes.get(2));
            }
            if (token.equals("[")) {
                this.nextToken();
                return this.doParseRule(true);
            }
            String name = this.nextToken();
            Functor clause = new Functor(name, args = this.parseNodeList(), BuiltinRegistry.theRegistry);
            if (clause.getImplementor() == null) {
                logger.warn("Rule references unimplemented functor: " + name);
            }
            return clause;
        }

        public Rule parseRule() {
            return this.doParseRule(false);
        }

        private Rule doParseRule(boolean retainVarMap) {
            try {
                if (this.peekToken().equals("[")) {
                    this.nextToken();
                }
                String name = null;
                String token = this.peekToken();
                if (token.endsWith(":")) {
                    name = token.substring(0, token.length() - 1);
                    this.nextToken();
                }
                if (!retainVarMap) {
                    this.varMap = new HashMap();
                }
                ArrayList<Object> body = new ArrayList<Object>();
                token = this.peekToken();
                while (!token.equals("->") && !token.equals("<-")) {
                    body.add(this.parseClause());
                    token = this.peekToken();
                }
                boolean backwardRule = token.equals("<-");
                ArrayList<Object> head = new ArrayList<Object>();
                token = this.nextToken();
                token = this.peekToken();
                while (!token.equals(".") && !token.equals("]")) {
                    head.add(this.parseClause());
                    token = this.peekToken();
                }
                this.nextToken();
                Rule r = null;
                r = backwardRule ? new Rule(name, body, head) : new Rule(name, head, body);
                r.numVars = this.varMap.keySet().size();
                r.isBackward = backwardRule;
                return r;
            }
            catch (NoSuchElementException e) {
                throw new ParserException("Malformed rule", this);
            }
        }
    }
}

