/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.LocationMappingVocab;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocationMapper {
    static Log log = LogFactory.getLog(LocationMapper.class);
    public static final String DEFAULT_PATH = "file:location-mapping.rdf;file:location-mapping.n3;file:etc/location-mapping.rdf;file:etc/location-mapping.n3;";
    public static final String GlobalMapperSystemProperty1 = "http://jena.hpl.hp.com/2004/08/LocationMap";
    public static final String GlobalMapperSystemProperty2 = "LocationMap";
    static String s_globalMapperPath = null;
    Map altLocations = new HashMap();
    Map altPrefixes = new HashMap();
    static LocationMapper theMapper = null;

    public static LocationMapper get() {
        if (theMapper == null) {
            theMapper = new LocationMapper();
            if (LocationMapper.getGlobalConfigPath() != null) {
                theMapper.initFromPath(LocationMapper.getGlobalConfigPath(), false);
            }
        }
        return theMapper;
    }

    public static LocationMapper makeGlobal() {
        LocationMapper lMap = new LocationMapper();
        if (LocationMapper.getGlobalConfigPath() != null) {
            lMap.initFromPath(LocationMapper.getGlobalConfigPath(), false);
        }
        return lMap;
    }

    public LocationMapper() {
    }

    public LocationMapper(LocationMapper locMapper) {
        this.altLocations.putAll(locMapper.altLocations);
        this.altPrefixes.putAll(locMapper.altPrefixes);
    }

    public LocationMapper(Model model) {
        this.processConfig(model);
    }

    public LocationMapper(String config) {
        this.initFromPath(config, true);
    }

    private void initFromPath(String configPath, boolean configMustExist) {
        if (configPath == null) {
            log.warn("Null configuration");
            return;
        }
        FileManager fm = new FileManager();
        fm.addLocatorFile();
        fm.addLocatorClassLoader(fm.getClass().getClassLoader());
        try {
            String uriConfig = null;
            InputStream in = null;
            StringTokenizer pathElems = new StringTokenizer(configPath, ";");
            while (pathElems.hasMoreTokens()) {
                String uri = pathElems.nextToken();
                in = fm.openNoMap(uri);
                if (in == null) continue;
                uriConfig = uri;
                break;
            }
            if (in == null) {
                if (!configMustExist) {
                    log.debug("Failed to find configuration: " + configPath);
                }
                return;
            }
            String syntax = FileUtils.guessLang(uriConfig);
            Model model = ModelFactory.createDefaultModel();
            model.read(in, uriConfig, syntax);
            this.processConfig(model);
        }
        catch (JenaException ex) {
            LogFactory.getLog(LocationMapper.class).warn("Error in configuration file: " + ex.getMessage());
        }
    }

    public String altMapping(String uri) {
        return this.altMapping(uri, uri);
    }

    public String altMapping(String uri, String otherwise) {
        if (this.altLocations.containsKey(uri)) {
            return (String)this.altLocations.get(uri);
        }
        String newStart = null;
        String oldStart = null;
        Iterator iter = this.altPrefixes.keySet().iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            if (!uri.startsWith(prefix)) continue;
            String s = (String)this.altPrefixes.get(prefix);
            if (newStart != null && newStart.length() >= s.length()) continue;
            oldStart = prefix;
            newStart = s;
        }
        if (newStart != null) {
            return newStart + uri.substring(oldStart.length());
        }
        return otherwise;
    }

    public void addAltEntry(String uri, String alt) {
        this.altLocations.put(uri, alt);
    }

    public void addAltPrefix(String uriPrefix, String altPrefix) {
        this.altPrefixes.put(uriPrefix, altPrefix);
    }

    public Iterator listAltEntries() {
        return this.altLocations.keySet().iterator();
    }

    public Iterator listAltPrefixes() {
        return this.altPrefixes.keySet().iterator();
    }

    public void removeAltEntry(String uri) {
        this.altLocations.remove(uri);
    }

    public void removeAltPrefix(String uriPrefix) {
        this.altPrefixes.remove(uriPrefix);
    }

    public String getAltEntry(String uri) {
        return (String)this.altLocations.get(uri);
    }

    public String getAltPrefix(String uriPrefix) {
        return (String)this.altPrefixes.get(uriPrefix);
    }

    private static String getGlobalConfigPath() {
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty1, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty2, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = DEFAULT_PATH;
        }
        return s_globalMapperPath;
    }

    public String toString() {
        String v;
        String k;
        String s = "";
        Iterator iter = this.altLocations.keySet().iterator();
        while (iter.hasNext()) {
            k = (String)iter.next();
            v = (String)this.altLocations.get(k);
            s = s + "(Loc:" + k + "=>" + v + ") ";
        }
        iter = this.altPrefixes.keySet().iterator();
        while (iter.hasNext()) {
            k = (String)iter.next();
            v = (String)this.altLocations.get(k);
            s = s + "(Prefix:" + k + "=>" + v + ") ";
        }
        return s;
    }

    public void processConfig(Model m) {
        StmtIterator mappings = m.listStatements(null, LocationMappingVocab.mapping, (RDFNode)null);
        while (mappings.hasNext()) {
            Statement s = mappings.nextStatement();
            Resource mapping = s.getResource();
            if (mapping.hasProperty(LocationMappingVocab.name)) {
                try {
                    String name = mapping.getRequiredProperty(LocationMappingVocab.name).getString();
                    String altName = mapping.getRequiredProperty(LocationMappingVocab.altName).getString();
                    this.addAltEntry(name, altName);
                    log.debug("Mapping: " + name + " => " + altName);
                }
                catch (JenaException ex) {
                    log.warn("Error processing name mapping: " + ex.getMessage());
                    return;
                }
            }
            if (!mapping.hasProperty(LocationMappingVocab.prefix)) continue;
            try {
                String prefix = mapping.getRequiredProperty(LocationMappingVocab.prefix).getString();
                String altPrefix = mapping.getRequiredProperty(LocationMappingVocab.altPrefix).getString();
                this.addAltPrefix(prefix, altPrefix);
                log.debug("Prefix mapping: " + prefix + " => " + altPrefix);
            }
            catch (JenaException ex) {
                log.warn("Error processing prefix mapping: " + ex.getMessage());
                return;
            }
        }
    }
}

