/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.web.filter;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.web.ServletCacheAdministrator;
import com.opensymphony.oscache.web.filter.CacheHttpServletResponseWrapper;
import com.opensymphony.oscache.web.filter.ResponseContent;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheFilter
implements Filter {
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_CACHE_CONTROL = "Cache-control";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private final Log log = LogFactory.getLog(this.getClass());
    private FilterConfig config;
    private ServletCacheAdministrator admin = null;
    private int cacheScope = 4;
    private int time = 3600;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info("<cache>: filter in scope " + this.cacheScope);
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String key = this.admin.generateEntryKey(null, httpRequest, this.cacheScope);
        Cache cache = this.admin.getCache(httpRequest, this.cacheScope);
        try {
            long clientLastModified;
            ResponseContent respContent = (ResponseContent)cache.getFromCache(key, this.time);
            if (this.log.isInfoEnabled()) {
                this.log.info("<cache>: Using cached entry for " + key);
            }
            if ((clientLastModified = httpRequest.getDateHeader(HEADER_IF_MODIFIED_SINCE)) != -1L && clientLastModified >= respContent.getLastModified()) {
                ((HttpServletResponse)response).setStatus(304);
                return;
            }
            respContent.writeTo(response);
        }
        catch (NeedsRefreshException nre) {
            boolean updateSucceeded = false;
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info("<cache>: New cache entry, cache stale or cache scope flushed for " + key);
                }
                CacheHttpServletResponseWrapper cacheResponse = new CacheHttpServletResponseWrapper((HttpServletResponse)response);
                chain.doFilter(request, cacheResponse);
                cacheResponse.flushBuffer();
                if (cacheResponse.getStatus() == 200) {
                    cache.putInCache(key, cacheResponse.getContent());
                    updateSucceeded = true;
                }
            }
            finally {
                if (!updateSucceeded) {
                    cache.cancelUpdate(key);
                }
            }
        }
    }

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
        this.admin = ServletCacheAdministrator.getInstance(this.config.getServletContext());
        try {
            this.time = Integer.parseInt(this.config.getInitParameter("time"));
        }
        catch (Exception e) {
            this.log.info("Could not get init paramter 'time', defaulting to one hour.");
        }
        try {
            String scopeString = this.config.getInitParameter("scope");
            if (scopeString.equals("session")) {
                this.cacheScope = 3;
            } else if (scopeString.equals("application")) {
                this.cacheScope = 4;
            } else if (scopeString.equals("request")) {
                this.cacheScope = 2;
            } else if (scopeString.equals("page")) {
                this.cacheScope = 1;
            }
        }
        catch (Exception e) {
            this.log.info("Could not get init paramter 'scope', defaulting to 'application'");
        }
    }
}

