/*
 * Decompiled with CFR 0.152.
 */
package com.simonstl.sax.xlink;

import com.simonstl.sax.xlink.Link;
import com.simonstl.sax.xlink.LinkArc;
import com.simonstl.sax.xlink.LinkInfo;
import com.simonstl.sax.xlink.LinkNode;
import com.simonstl.sax.xlink.LinkSet;
import com.simonstl.sax.xlink.XPointerLocator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XLinkFilter
implements ContentHandler,
DTDHandler,
EntityResolver,
ErrorHandler,
XMLFilter,
XMLReader {
    protected ContentHandler thisContentHandler = new DefaultHandler();
    protected DTDHandler thisDTDHandler = new DefaultHandler();
    protected EntityResolver thisEntityResolver = new DefaultHandler();
    protected ErrorHandler thisErrorHandler = new DefaultHandler();
    protected XMLReader parentXMLReader;
    protected Locator docLocator;
    protected LinkSet theLinkSet;
    protected Vector holdingInfoTank;
    protected Vector holdingNodeTank;
    protected Vector holdingArcTank;
    protected URL inputURL;
    protected XPointerLocator xpLoc;
    protected int outerExtendedLinkDepth;
    protected static final int NO_OUTER_EXTENDED_LINK = -1;
    protected boolean collectingLinksOnly;
    public static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    public static final String FRAGMENT_CONNECTOR = "#";
    public static final String NO_ROLE = "";
    public static final String NO_ARCROLE = "";
    public static final String NO_TITLE = "";
    public static final String NO_SHOW = "none";
    public static final String NO_ACTUATE = "none";
    public static final String NO_LABEL = "";
    public static final String NO_FROM = "";
    public static final String NO_TO = "";
    public static final String NO_XLINK_TYPE = "";
    private URL newURL;
    private String newRole;
    private String newArcRole;
    private String newTitle;
    private String newShow;
    private String newActuate;
    private String newLabel;
    private String newFromLabel;
    private String newToLabel;
    private String newLinkType;
    private String localXPointer;

    public XLinkFilter(XMLReader xMLReader) {
        this.setParent(xMLReader);
        this.collectingLinksOnly = false;
    }

    public void setParent(XMLReader xMLReader) {
        this.parentXMLReader = xMLReader;
        this.parentXMLReader.setContentHandler(this);
        this.parentXMLReader.setDTDHandler(this);
        this.parentXMLReader.setEntityResolver(this);
        this.parentXMLReader.setErrorHandler(this);
    }

    public XMLReader getParent() {
        return this.parentXMLReader;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        try {
            this.inputURL = new URL(inputSource.getSystemId());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.err.println("XLinkFilter error: Invalid input source URI=" + inputSource.getSystemId());
        }
        this.parentXMLReader.parse(inputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        try {
            this.inputURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.err.println("XLinkFilter error: Invalid input source URI=" + string);
        }
        this.parentXMLReader.parse(string);
    }

    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
        this.getContentHandler().setDocumentLocator(locator);
    }

    public void setLinkSet(LinkSet linkSet) {
        this.theLinkSet = linkSet;
    }

    public LinkSet getLinkSet() {
        return this.theLinkSet;
    }

    public void startDocument() throws SAXException {
        this.holdingNodeTank = new Vector();
        this.holdingArcTank = new Vector();
        this.holdingInfoTank = new Vector();
        this.xpLoc = new XPointerLocator();
        this.outerExtendedLinkDepth = -1;
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        this.holdingNodeTank = null;
        this.holdingArcTank = null;
        this.holdingInfoTank = null;
        this.outerExtendedLinkDepth = -1;
        this.xpLoc.endDocument();
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.endDocument();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        boolean bl = string2 == null || string2.equals("");
        String string4 = bl ? string3 : string2;
        this.xpLoc.startElement();
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = attributes.getLength();
        for (n = 0; n < n2; ++n) {
            if (!XLINK_NAMESPACE_URI.equals(attributes.getURI(n))) continue;
            if (!bl2) {
                bl2 = true;
                this.newURL = null;
                this.newRole = "";
                this.newArcRole = "";
                this.newTitle = "";
                this.newShow = "none";
                this.newActuate = "none";
                this.newLabel = "";
                this.newFromLabel = "";
                this.newToLabel = "";
                this.newLinkType = "";
                this.localXPointer = this.xpLoc.getXPointer();
            }
            object4 = attributes.getLocalName(n);
            object3 = attributes.getValue(n);
            object2 = attributes.getType(n);
            if (((String)object4).equals("href")) {
                try {
                    this.newURL = new URL(this.inputURL, (String)object3);
                }
                catch (MalformedURLException malformedURLException) {
                    bl3 = true;
                    System.err.println("XLink parsing error: " + this.whereInDoc() + "Invalid URI in href=\"" + (String)object3 + "\".");
                }
            } else if (((String)object4).equals("type")) {
                this.newLinkType = object3;
            } else if (((String)object4).equals("role")) {
                this.newRole = object3;
                try {
                    object = new URL((String)object3);
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("XLink parsing error: " + this.whereInDoc() + "Invalid absolute URI in role=\"" + (String)object3 + "\".");
                }
            } else if (((String)object4).equals("arcrole")) {
                this.newArcRole = object3;
                try {
                    object = new URL((String)object3);
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("XLink parsing error: " + this.whereInDoc() + "Invalid absolute URI in arcrole=\"" + (String)object3 + "\".");
                }
            } else if (((String)object4).equals("title")) {
                this.newTitle = object3;
            } else if (((String)object4).equals("show")) {
                if (((String)object3).equals("new") || ((String)object3).equals("replace") || ((String)object3).equals("embed") || ((String)object3).equals("other") || ((String)object3).equals("none")) {
                    this.newShow = object3;
                } else {
                    System.err.println("XLink parsing error: " + this.whereInDoc() + "Unrecognized attribute value show=\"" + (String)object3 + "\", replaced by default value \"" + "none" + "\".");
                    object3 = "none";
                }
            } else if (((String)object4).equals("actuate")) {
                if (((String)object3).equals("onLoad") || ((String)object3).equals("onRequest") || ((String)object3).equals("other") || ((String)object3).equals("none")) {
                    this.newActuate = object3;
                } else {
                    System.err.println("XLink parsing error: " + this.whereInDoc() + "Unrecognized attribute value actuate=\"" + (String)object3 + "\", replaced by default value \"" + "none" + "\".");
                    object3 = "none";
                }
            } else if (((String)object4).equals("label")) {
                this.newLabel = object3;
            } else if (((String)object4).equals("from")) {
                this.newFromLabel = object3;
            } else if (((String)object4).equals("to")) {
                this.newToLabel = object3;
            } else {
                System.err.println("XLink parsing error: " + this.whereInDoc() + "Unrecognized XLink attribute \"" + (String)object4 + "\".");
            }
            if (!((String)object2).equals("ID")) continue;
            this.localXPointer = object3;
        }
        if (bl2) {
            n = this.xpLoc.currentDepth();
            LinkInfo linkInfo = new LinkInfo(this.newLinkType, this.newRole, this.newTitle);
            if (this.newLinkType.equals("simple")) {
                if (-1 == this.outerExtendedLinkDepth && !bl3) {
                    try {
                        object4 = new URL(this.inputURL, FRAGMENT_CONNECTOR + this.localXPointer);
                        if (this.newURL == null) {
                            this.newURL = object4;
                        }
                        object3 = new LinkNode("resource", (URL)object4, "", "", "");
                        object2 = new LinkNode("locator", this.newURL, this.newRole, this.newTitle, "");
                        object = new LinkArc(this.newArcRole, "", this.newShow, this.newActuate, "", "");
                        Link link = new Link((LinkNode)object3, (LinkNode)object2, (LinkArc)object, linkInfo);
                        this.theLinkSet.addLink(link);
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            } else if (this.newLinkType.equals("extended")) {
                if (-1 == this.outerExtendedLinkDepth) {
                    this.outerExtendedLinkDepth = n;
                    this.holdingInfoTank.add(linkInfo);
                }
            } else if (this.newLinkType.equals("locator")) {
                if (1 == n - this.outerExtendedLinkDepth && !bl3) {
                    if (this.newURL == null) {
                        System.err.println("XLink parsing error: " + this.whereInDoc() + "Missing attribute \"href\" in a locator-type element.");
                    } else {
                        object4 = new LinkNode(this.newLinkType, this.newURL, this.newRole, this.newTitle, this.newLabel);
                        this.holdingNodeTank.add(object4);
                    }
                }
            } else if (this.newLinkType.equals("resource")) {
                if (1 == n - this.outerExtendedLinkDepth) {
                    try {
                        object4 = new URL(this.inputURL, FRAGMENT_CONNECTOR + this.localXPointer);
                        object3 = new LinkNode(this.newLinkType, (URL)object4, this.newRole, this.newTitle, this.newLabel);
                        this.holdingNodeTank.add(object3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            } else if (this.newLinkType.equals("arc")) {
                if (1 == n - this.outerExtendedLinkDepth) {
                    object4 = new LinkArc(this.newArcRole, this.newTitle, this.newShow, this.newActuate, this.newFromLabel, this.newToLabel);
                    this.holdingArcTank.add(object4);
                }
            } else if (!this.newLinkType.equals("title") && !this.newLinkType.equals("none")) {
                System.err.println("XLink parsing error: " + this.whereInDoc() + "Unrecognized attribute value type=\"" + this.newLinkType + "\".");
            }
        }
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        boolean bl = string2 == null || string2.equals("");
        String string4 = bl ? string3 : string2;
        int n = this.xpLoc.currentDepth();
        if (n == this.outerExtendedLinkDepth) {
            Object object;
            this.outerExtendedLinkDepth = -1;
            if (this.holdingArcTank.isEmpty()) {
                object = new LinkArc("", "", "none", "none", "", "");
                this.holdingArcTank.add(object);
            }
            LinkInfo linkInfo = (LinkInfo)this.holdingInfoTank.firstElement();
            int n2 = this.holdingArcTank.size();
            for (int i = 0; i < n2; ++i) {
                LinkArc linkArc = (LinkArc)this.holdingArcTank.elementAt(i);
                object = linkArc.getFromLabel();
                String string5 = linkArc.getToLabel();
                boolean bl2 = object == null || ((String)object).equals("");
                boolean bl3 = string5 == null || string5.equals("");
                boolean bl4 = false;
                boolean bl5 = false;
                int n3 = this.holdingNodeTank.size();
                for (int j = 0; j < n3; ++j) {
                    LinkNode linkNode = (LinkNode)this.holdingNodeTank.elementAt(j);
                    if (!bl2 && !((String)object).equals(linkNode.getLabel())) continue;
                    bl5 = true;
                    for (int k = 0; k < n3; ++k) {
                        LinkNode linkNode2 = (LinkNode)this.holdingNodeTank.elementAt(k);
                        if (!bl3 && !string5.equals(linkNode2.getLabel())) continue;
                        bl4 = true;
                        Link link = new Link(linkNode, linkNode2, linkArc, linkInfo);
                        this.theLinkSet.addLink(link);
                    }
                }
                if (!bl5 && !bl2) {
                    System.err.println("XLink parsing error: " + this.whereInDoc() + "Cannot find a valid locator/resource with a label matching the arc attribute from=\"" + (String)object + "\".");
                    continue;
                }
                if (bl4 || bl3) continue;
                System.err.println("XLink parsing error: " + this.whereInDoc() + "Cannot find a valid locator/resource with a label matching the arc attribute to=\"" + string5 + "\".");
            }
            this.holdingInfoTank.removeAllElements();
            this.holdingNodeTank.removeAllElements();
            this.holdingArcTank.removeAllElements();
        }
        this.xpLoc.endElement();
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.endElement(string, string2, string3);
        }
    }

    public void setCollectingLinksOnly(boolean bl) {
        this.collectingLinksOnly = bl;
    }

    public boolean isCollectingLinksOnly() {
        return this.collectingLinksOnly;
    }

    protected LinkSet createLinkSet() {
        return new LinkSet();
    }

    protected String whereInDoc() {
        String string = this.docLocator == null ? "" : "[" + this.docLocator.getLineNumber() + "," + this.docLocator.getColumnNumber() + "] ";
        return string;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.characters(cArray, n, n2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.endPrefixMapping(string);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.processingInstruction(string, string2);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.skippedEntity(string);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisContentHandler.startPrefixMapping(string, string2);
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisDTDHandler.notationDecl(string, string2, string3);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisDTDHandler.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return this.thisEntityResolver.resolveEntity(string, string2);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisErrorHandler.warning(sAXParseException);
        } else {
            System.err.println(this.inputURL.toString() + ": XLink collecting warning: " + this.whereInDoc() + sAXParseException.getMessage());
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisErrorHandler.error(sAXParseException);
        } else {
            System.err.println(this.inputURL.toString() + ": XLink collecting error: " + this.whereInDoc() + sAXParseException.getMessage());
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (!this.collectingLinksOnly) {
            this.thisErrorHandler.fatalError(sAXParseException);
        } else {
            System.err.println(this.inputURL.toString() + ": Fatal XLink collecting error: " + this.whereInDoc() + sAXParseException.getMessage());
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parentXMLReader.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parentXMLReader.setFeature(string, bl);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parentXMLReader.getProperty(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parentXMLReader.setProperty(string, object);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.thisEntityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.thisEntityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.thisDTDHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.thisDTDHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.thisContentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.thisContentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.thisErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.thisErrorHandler;
    }
}

