/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.javaxml.example;

import com.skaringa.javaxml.ObjectTransformer;
import com.skaringa.javaxml.ObjectTransformerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.transform.stream.StreamSource;

public class PreAndPostprocessingExample {
    private static final String xmlInRes = "com/skaringa/javaxml/example/Items.xml";
    private static final String xmlOutFile = "NewItems.xml";
    private static final String xslPreRes = "com/skaringa/javaxml/example/PreItems.xsl";
    private static final String xslPostRes = "com/skaringa/javaxml/example/PostItems.xsl";

    public static void main(String[] stringArray) {
        try {
            ObjectTransformer objectTransformer = ObjectTransformerFactory.getInstance().getImplementation();
            objectTransformer.setProperty("indent", "yes");
            objectTransformer.setPreprocessorInstruction(new StreamSource(ClassLoader.getSystemResourceAsStream(xslPreRes)));
            objectTransformer.setPostprocessorInstruction(new StreamSource(ClassLoader.getSystemResourceAsStream(xslPostRes)));
            Collection collection = (Collection)objectTransformer.deserialize(new StreamSource(ClassLoader.getSystemResourceAsStream(xmlInRes)));
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(PreAndPostprocessingExample.firstUp((String)iterator.next()));
            }
            System.out.println(objectTransformer.serializeToString(arrayList));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String firstUp(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 1).toUpperCase());
            stringBuffer.append(string.substring(1));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }
}

