/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.javaxml.handler.sax;

import com.skaringa.javaxml.SerializerException;
import com.skaringa.javaxml.handler.DocumentOutputHandlerInterface;
import com.skaringa.javaxml.handler.sax.ObjectInputSource;
import com.skaringa.javaxml.handler.sax.SAXOutputHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public abstract class AbstractXMLReader
implements XMLReader {
    protected Map featureMap = new HashMap();
    protected Map propertyMap = new HashMap();
    protected EntityResolver entityResolver;
    protected DTDHandler dtdHandler;
    protected ContentHandler contentHandler;
    protected ErrorHandler errorHandler;

    public abstract void parseObject(Object var1, Class var2, String var3, DocumentOutputHandlerInterface var4) throws SerializerException;

    public void parse(InputSource inputSource) throws IOException, SAXException {
        ContentHandler contentHandler = this.getContentHandler();
        if (contentHandler == null) {
            throw new SAXException("AbstractXMLReader: No content handler registered");
        }
        if (!(inputSource instanceof ObjectInputSource)) {
            throw new SAXException("AbstractXMLReader: Invalid InputSource object");
        }
        SAXOutputHandler sAXOutputHandler = new SAXOutputHandler(contentHandler);
        ObjectInputSource objectInputSource = (ObjectInputSource)inputSource;
        Object object = objectInputSource.getObj();
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        try {
            this.parseObject(object, clazz, string, sAXOutputHandler);
        }
        catch (SerializerException serializerException) {
            throw new SAXException(serializerException);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bl = (Boolean)this.featureMap.get(string);
        return bl == null ? false : bl;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.featureMap.put(string, new Boolean(bl));
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.propertyMap.get(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.propertyMap.put(string, object);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }
}

