/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.perftest;

import com.skaringa.perftest.config.PerfTestParams;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Category;

public abstract class PerfTest
extends Thread {
    protected String _id = "ID" + String.valueOf(System.currentTimeMillis());
    protected String _method = "undefined";
    protected int _loopCount = 0;
    protected String _dataType = "unknown";
    protected int _dataSize = 0;
    protected boolean _randomData = false;
    protected boolean _cleanup = true;
    protected long _time = 0L;
    protected boolean _error = false;
    private static Category _category = Category.getInstance(class$com$skaringa$perftest$PerfTest == null ? (class$com$skaringa$perftest$PerfTest = PerfTest.class$("com.skaringa.perftest.PerfTest")) : class$com$skaringa$perftest$PerfTest);
    static /* synthetic */ Class class$com$skaringa$perftest$PerfTest;

    protected PerfTest() {
    }

    public void setParams(PerfTestParams perfTestParams) {
        this._method = perfTestParams.method;
        this._loopCount = perfTestParams.loopCount;
        this._dataType = perfTestParams.dataType;
        this._dataSize = perfTestParams.dataSize;
        this._randomData = perfTestParams.randomData;
        this._cleanup = perfTestParams.cleanup;
    }

    protected void setupTest() {
        try {
            _category.debug("Setup test " + this.toString());
            String string = "setup";
            string = string + this._method;
            Method method = this.getClass().getDeclaredMethod(string, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            this._error = true;
            _category.error(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this._error = true;
            _category.error(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this._error = true;
            _category.error(invocationTargetException);
        }
    }

    protected void runTest() {
        try {
            _category.debug("Running test " + this.toString());
            String string = "test";
            string = string + this._method;
            Method method = this.getClass().getDeclaredMethod(string, new Class[0]);
            long l = System.currentTimeMillis();
            method.invoke((Object)this, new Object[0]);
            this._time = System.currentTimeMillis() - l;
            _category.debug("Finished test " + this.toString() + " after " + this._time + " ms.");
        }
        catch (IllegalAccessException illegalAccessException) {
            this._error = true;
            _category.error(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this._error = true;
            _category.error(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this._error = true;
            _category.error(invocationTargetException);
        }
    }

    protected void cleanupTest() {
        if (!this._cleanup) {
            return;
        }
        try {
            _category.debug("Cleanup test " + this.toString());
            String string = "cleanup";
            string = string + this._method;
            Method method = this.getClass().getDeclaredMethod(string, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            this._error = true;
            _category.error(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this._error = true;
            _category.error(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this._error = true;
            _category.error(invocationTargetException);
        }
    }

    public void run() {
        _category.info("Starting test " + this.toString());
        this.setupTest();
        this.runTest();
        this.cleanupTest();
        _category.info("Finished test " + this.toString() + " after " + this._time + " ms.");
    }

    public String toString() {
        return this._id + " " + this._method + " DT:" + this._dataType + " SZ:" + this._dataSize + " LC:" + this._loopCount;
    }

    public int getDataSize() {
        return this._dataSize;
    }

    public void setDataSize(int n) {
        this._dataSize = n;
    }

    public boolean getError() {
        return this._error;
    }

    public void setError(boolean bl) {
        this._error = bl;
    }

    public int getLoopCount() {
        return this._loopCount;
    }

    public void setLoopCount(int n) {
        this._loopCount = n;
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String string) {
        this._method = string;
    }

    public boolean getRandomData() {
        return this._randomData;
    }

    public void setRandomData(boolean bl) {
        this._randomData = bl;
    }

    public long getTime() {
        return this._time;
    }

    public void setTime(long l) {
        this._time = l;
    }

    public boolean getCleanup() {
        return this._cleanup;
    }

    public void setCleanup(boolean bl) {
        this._cleanup = bl;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String string) {
        this._id = string;
    }

    public String getDataType() {
        return this._dataType;
    }

    public void setDataType(String string) {
        this._dataType = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

