/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.perftest;

import com.skaringa.javaxml.NoImplementationException;
import com.skaringa.javaxml.ObjectTransformer;
import com.skaringa.javaxml.ObjectTransformerFactory;
import com.skaringa.perftest.PerfTest;
import com.skaringa.perftest.config.PerfTestParams;
import com.skaringa.perftest.config.PerfTestSuiteParams;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Category;

public class PerfTestSuite {
    private String _name;
    private static Category _category = Category.getInstance(class$com$skaringa$perftest$PerfTestSuite == null ? (class$com$skaringa$perftest$PerfTestSuite = PerfTestSuite.class$("com.skaringa.perftest.PerfTestSuite")) : class$com$skaringa$perftest$PerfTestSuite);
    private ObjectTransformer _trans = null;
    private ObjectTransformer _htmlTrans = null;
    private String _xsltResource;
    private PerfTestSuiteParams _suite = null;
    private Class _testClass;
    static /* synthetic */ Class class$com$skaringa$perftest$PerfTestSuite;
    static /* synthetic */ Class class$com$skaringa$perftest$config$PerfTestParams;
    static /* synthetic */ Class class$com$skaringa$perftest$config$PerfTestSuiteParams;

    public PerfTestSuite(String string) {
        this._name = string;
    }

    public PerfTestSuite(String string, String string2) {
        this._name = string;
        this._xsltResource = string2;
    }

    public void setup() {
        File file = new File(this._name + ".xml");
        if (!file.canRead()) {
            _category.error("No readable configuration file found for suite with name: " + this._name);
            return;
        }
        try {
            this.initObjectTransformer();
            this._suite = (PerfTestSuiteParams)this._trans.deserialize(new StreamSource(file));
            if (this._suite.name != null && this._suite.name.length() > 0) {
                this._name = this._suite.name;
            }
            if (this._suite.testclass == null || this._suite.testclass.length() == 0) {
                _category.error("Attribute testclass is not defined.");
                return;
            }
        }
        catch (Exception exception) {
            _category.error("Can't setup test: " + exception);
        }
        try {
            this._testClass = Class.forName(this._suite.testclass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            _category.error("Test class " + this._suite.testclass + " not found in CLASSPATH.");
        }
        this._suite.os = System.getProperty("os.name") + " " + System.getProperty("os.version") + " / " + System.getProperty("os.arch");
        this._suite.jvm = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        _category.info("Test suite " + this._name + " for class " + this._suite.testclass + " has been set up.");
    }

    public void run() {
        if (this._testClass == null) {
            _category.error("Suite was not set up properly.");
            return;
        }
        this._suite.testDate = new Date();
        Hashtable<String, PerfTest> hashtable = new Hashtable<String, PerfTest>();
        ThreadGroup threadGroup = new ThreadGroup("perftestThreadGroup");
        int n = this._suite.perftests.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                PerfTest perfTest = (PerfTest)this._testClass.newInstance();
                perfTest.setParams(this._suite.perftests[n2]);
                hashtable.put(perfTest.getId(), perfTest);
                this._suite.perftests[n2].id = perfTest.getId();
                if (this._suite.parallel) {
                    perfTest.start();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    perfTest.run();
                }
            }
            catch (InstantiationException instantiationException) {
                _category.error("Failed to create test: " + instantiationException);
                this._suite.perftests[n2].error = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                _category.error("Failed to create test: " + illegalAccessException);
                this._suite.perftests[n2].error = true;
            }
            ++n2;
        }
        if (this._suite.parallel) {
            _category.info("waiting for the tests to finish ...");
        }
        int n3 = 0;
        while (n3 < n) {
            String string = this._suite.perftests[n3].id;
            PerfTest perfTest = (PerfTest)hashtable.get(string);
            if (this._suite.parallel) {
                try {
                    perfTest.join();
                }
                catch (InterruptedException interruptedException) {
                    _category.error(interruptedException);
                }
            }
            long l = perfTest.getTime() / (long)perfTest.getLoopCount();
            this._suite.perftests[n3].time = l;
            this._suite.perftests[n3].error = perfTest.getError();
            ++n3;
        }
    }

    public void writeResultXML(File file) {
        if (this._testClass == null) {
            _category.error("Suite was not set up properly.");
            return;
        }
        try {
            _category.info("Writing xml result file " + file.toString());
            this._trans.serialize(this._suite, new StreamResult(file));
            _category.info("done.");
        }
        catch (Exception exception) {
            _category.error("Can't write resulting XML: " + exception);
        }
    }

    public void writeResultHTML(File file) {
        if (this._testClass == null) {
            _category.error("Suite was not set up properly.");
            return;
        }
        if (this._htmlTrans == null) {
            _category.error("No HTML output available (possible cause: invalid stylesheet");
        }
        try {
            _category.info("Writing html result file " + file.toString());
            this._htmlTrans.serialize(this._suite, new StreamResult(file));
            _category.info("done.");
        }
        catch (Exception exception) {
            _category.error("Can't write resulting HTML: " + exception);
        }
    }

    private void initObjectTransformer() throws NoImplementationException {
        if (this._trans == null) {
            this._trans = ObjectTransformerFactory.getInstance().getImplementation();
            this._trans.setProperty("indent", "yes");
            this._trans.setProperty("encoding", "ISO-8859-1");
            this._trans.setProperty("omit_xsi_type", "true");
        }
        if (this._htmlTrans == null && this._xsltResource != null) {
            this._htmlTrans = ObjectTransformerFactory.getInstance().getImplementation();
            this._htmlTrans.setProperty("indent", "yes");
            this._htmlTrans.setProperty("encoding", "ISO-8859-1");
            this._htmlTrans.setPostprocessorInstruction(new StreamSource(ClassLoader.getSystemResourceAsStream(this._xsltResource)));
        }
    }

    private void writeExampleConfigFile() {
        Object object;
        PerfTestSuiteParams perfTestSuiteParams = new PerfTestSuiteParams();
        perfTestSuiteParams.name = "SamplePerfTestSuite";
        perfTestSuiteParams.testclass = "full.name.of.testclass";
        perfTestSuiteParams.parallel = false;
        perfTestSuiteParams.hardware = "Z80, 4 Mhz, 64 KByte Memory";
        perfTestSuiteParams.comment = "This is a sample configuration file for a performance test suite.";
        perfTestSuiteParams.perftests = new PerfTestParams[5];
        int n = 0;
        while (n < 5) {
            object = new PerfTestParams();
            ((PerfTestParams)object).method = "testMethod" + n;
            ((PerfTestParams)object).loopCount = 10;
            ((PerfTestParams)object).dataSize = 500;
            ((PerfTestParams)object).dataType = "full.name.of.class.of.testobject";
            ((PerfTestParams)object).randomData = false;
            ((PerfTestParams)object).cleanup = true;
            perfTestSuiteParams.perftests[n] = object;
            ++n;
        }
        object = this._name + ".xml";
        String string = "perftest_config.xsd";
        try {
            this.initObjectTransformer();
            this._trans.serialize(perfTestSuiteParams, new StreamResult(new File((String)object)));
            Vector<Class> vector = new Vector<Class>();
            vector.add(class$com$skaringa$perftest$config$PerfTestParams == null ? (class$com$skaringa$perftest$config$PerfTestParams = PerfTestSuite.class$("com.skaringa.perftest.config.PerfTestParams")) : class$com$skaringa$perftest$config$PerfTestParams);
            this._trans.writeXMLSchema(class$com$skaringa$perftest$config$PerfTestSuiteParams == null ? (class$com$skaringa$perftest$config$PerfTestSuiteParams = PerfTestSuite.class$("com.skaringa.perftest.config.PerfTestSuiteParams")) : class$com$skaringa$perftest$config$PerfTestSuiteParams, vector, new StreamResult(new File(string)));
        }
        catch (Exception exception) {
            _category.error(exception);
            return;
        }
        System.err.println("An example configuration file was created.");
        System.err.println("Filename :" + (String)object);
        System.err.println("An XML schema definition of the configuaration file was saved to " + string);
    }

    public static void main(String[] stringArray) {
        String string = "com/skaringa/perftest/result.xsl";
        if (stringArray.length == 0) {
            System.err.println("usage: java " + (class$com$skaringa$perftest$PerfTestSuite == null ? (class$com$skaringa$perftest$PerfTestSuite = PerfTestSuite.class$("com.skaringa.perftest.PerfTestSuite")) : class$com$skaringa$perftest$PerfTestSuite).getName() + " suite_name");
            PerfTestSuite perfTestSuite = new PerfTestSuite("perftest_example_config");
            perfTestSuite.writeExampleConfigFile();
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            File file = new File(string2 + "-result.xml");
            File file2 = new File(string2 + "-result.html");
            PerfTestSuite perfTestSuite = new PerfTestSuite(string2, string);
            perfTestSuite.setup();
            perfTestSuite.run();
            perfTestSuite.writeResultXML(file);
            perfTestSuite.writeResultHTML(file2);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

