/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.perftest;

import com.skaringa.javaxml.ObjectTransformer;
import com.skaringa.javaxml.ObjectTransformerFactory;
import com.skaringa.perftest.PerfTest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Category;

public class SkaringaPerfTest
extends PerfTest {
    private static Category _category = Category.getInstance(class$com$skaringa$perftest$SkaringaPerfTest == null ? (class$com$skaringa$perftest$SkaringaPerfTest = SkaringaPerfTest.class$("com.skaringa.perftest.SkaringaPerfTest")) : class$com$skaringa$perftest$SkaringaPerfTest);
    private Object _testObj;
    private ObjectTransformer _trans;
    private ObjectOutputStream _objOutStr;
    private ObjectInputStream _objInStream;
    static /* synthetic */ Class class$com$skaringa$perftest$SkaringaPerfTest;

    public SkaringaPerfTest() {
        _category.debug("new test " + this.getClass().getName() + " created with id " + this._id);
    }

    private void createTestObject() {
        try {
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            classArray[0] = Integer.TYPE;
            objectArray[0] = new Integer(this._dataSize);
            Class<?> clazz = Class.forName(this.getDataType());
            Constructor<?> constructor = clazz.getConstructor(classArray);
            this._testObj = constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            _category.error("no ctor(String) found for class: " + this.getDataType());
            this._error = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            _category.error("exception in initializer: " + invocationTargetException.getMessage());
            this._error = true;
        }
        catch (IllegalAccessException illegalAccessException) {
            _category.error("can't access ctor(int) for class: " + this.getDataType());
            this._error = true;
        }
        catch (InstantiationException instantiationException) {
            _category.error("can't instantiate class: " + this.getDataType());
            this._error = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            _category.error("Test object class " + this.getDataType() + " not found in CLASSPATH.");
            this._error = true;
        }
    }

    protected void setupSerializeSkaringa() {
        try {
            this.createTestObject();
            this._trans = ObjectTransformerFactory.getInstance().getImplementation();
        }
        catch (Exception exception) {
            this._error = true;
            _category.error(exception);
        }
    }

    protected void testSerializeSkaringa() {
        try {
            int n = 0;
            while (n < this._loopCount) {
                FileOutputStream fileOutputStream = new FileOutputStream(this._id + n);
                this._trans.serialize(this._testObj, new StreamResult(fileOutputStream));
                fileOutputStream.close();
                ++n;
            }
        }
        catch (Exception exception) {
            this._error = true;
            _category.error(exception);
        }
    }

    protected void cleanupSerializeSkaringa() {
        try {
            int n = 0;
            while (n < this._loopCount) {
                File file = new File(this._id + n);
                file.delete();
                ++n;
            }
        }
        catch (Exception exception) {
            _category.error(exception);
        }
    }

    protected void setupDeserializeSkaringa() {
        try {
            this.createTestObject();
            this._trans = ObjectTransformerFactory.getInstance().getImplementation();
            int n = 0;
            while (n < this._loopCount) {
                FileOutputStream fileOutputStream = new FileOutputStream(this._id + n);
                this._trans.serialize(this._testObj, new StreamResult(fileOutputStream));
                fileOutputStream.close();
                ++n;
            }
        }
        catch (Exception exception) {
            this._error = true;
            _category.error(exception);
        }
    }

    protected void testDeserializeSkaringa() {
        try {
            int n = 0;
            while (n < this._loopCount) {
                FileInputStream fileInputStream = new FileInputStream(this._id + n);
                Object object = this._trans.deserialize(new StreamSource(fileInputStream));
                this._error = !this._testObj.equals(object);
                fileInputStream.close();
                ++n;
            }
        }
        catch (Exception exception) {
            this._error = true;
            _category.error(exception);
        }
    }

    protected void cleanupDeserializeSkaringa() {
        try {
            int n = 0;
            while (n < this._loopCount) {
                File file = new File(this._id + n);
                file.delete();
                ++n;
            }
        }
        catch (Exception exception) {
            _category.error(exception);
        }
    }

    protected void setupSerializeJava() {
        try {
            this.createTestObject();
        }
        catch (Exception exception) {
            this._error = true;
            _category.error(exception);
        }
    }

    protected void testSerializeJava() {
        try {
            int n = 0;
            while (n < this._loopCount) {
                FileOutputStream fileOutputStream = new FileOutputStream(this._id + n);
                this._objOutStr = new ObjectOutputStream(fileOutputStream);
                this._objOutStr.writeObject(this._testObj);
                this._objOutStr.flush();
                fileOutputStream.close();
                ++n;
            }
        }
        catch (Exception exception) {
            this._error = true;
            _category.error(exception);
        }
    }

    protected void cleanupSerializeJava() {
        try {
            int n = 0;
            while (n < this._loopCount) {
                File file = new File(this._id + n);
                file.delete();
                ++n;
            }
        }
        catch (Exception exception) {
            _category.error(exception);
        }
    }

    protected void setupDeserializeJava() {
        try {
            this.createTestObject();
            int n = 0;
            while (n < this._loopCount) {
                FileOutputStream fileOutputStream = new FileOutputStream(this._id + n);
                this._objOutStr = new ObjectOutputStream(fileOutputStream);
                this._objOutStr.writeObject(this._testObj);
                this._objOutStr.flush();
                fileOutputStream.close();
                ++n;
            }
        }
        catch (Exception exception) {
            this._error = true;
            _category.error(exception);
        }
    }

    protected void testDeserializeJava() {
        try {
            int n = 0;
            while (n < this._loopCount) {
                FileInputStream fileInputStream = new FileInputStream(this._id + n);
                this._objInStream = new ObjectInputStream(fileInputStream);
                Object object = this._objInStream.readObject();
                this._error = !this._testObj.equals(object);
                fileInputStream.close();
                ++n;
            }
        }
        catch (Exception exception) {
            this._error = true;
            _category.error(exception);
        }
    }

    protected void cleanupDeserializeJava() {
        try {
            int n = 0;
            while (n < this._loopCount) {
                File file = new File(this._id + n);
                file.delete();
                ++n;
            }
        }
        catch (Exception exception) {
            _category.error(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

