/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.util;

import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SAXValidator {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public static void validate(InputSource inputSource, InputSource inputSource2) throws SAXNotRecognizedException, SAXException, IOException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        sAXParser.setProperty(JAXP_SCHEMA_SOURCE, inputSource2);
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setErrorHandler(new MyErrorHandler(System.err));
        xMLReader.parse(inputSource);
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintStream out;

        MyErrorHandler(PrintStream printStream) {
            this.out = printStream;
        }

        private String getParseExceptionInfo(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }
    }
}

