/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.Debug;
import flybase.FastVector;
import flybase.OpenString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class Utils {
    static Hashtable htmlcodes;
    static Hashtable isocodes;
    static final String spaces;
    protected static final int pipesize = 2048;
    private static final int Crypt1 = 52895;
    private static final int Crypt2 = 22419;
    private static final int Cryptkey = 23647;

    public static final String[] splitString(String string) {
        return Utils.splitString(string, "\n\r\t", -1);
    }

    public static final String[] splitString(String string, String string2) {
        return Utils.splitString(string, string2, -1);
    }

    public static String[] splitString(String string, String string2, int n) {
        String[] stringArray;
        boolean bl;
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n2 = stringTokenizer.countTokens();
        if (n > 0 && n2 > n) {
            n2 = n - 1;
            bl = true;
            stringArray = new String[n];
        } else {
            bl = false;
            stringArray = new String[n2];
        }
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        if (bl) {
            string = stringTokenizer.nextToken("\u0000");
            if (string.length() > 0 && string2.indexOf(string.charAt(0)) >= 0) {
                string = string.substring(1);
            }
            stringArray[n2] = string;
        }
        return stringArray;
    }

    private static final int skipDelimiters(OpenString openString, String string, int n, int n2) {
        while (n < n2 && string.indexOf(openString.charAt(n)) >= 0) {
            ++n;
        }
        return n;
    }

    public static final OpenString[] splitString(OpenString openString) {
        return Utils.splitString(openString, "\n\r\t", -1);
    }

    public static final OpenString[] splitString(OpenString openString, String string) {
        return Utils.splitString(openString, string, -1);
    }

    public static OpenString[] splitString(OpenString openString, String string, int n) {
        Object object;
        if (openString == null) {
            return null;
        }
        FastVector fastVector = new FastVector();
        int n2 = openString.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            if (n > 0 && n4 >= n) {
                object = openString.substring(n3);
                if (((OpenString)object).length() > 0 && string.indexOf(((OpenString)object).charAt(0)) >= 0) {
                    object = ((OpenString)object).substring(1);
                }
                fastVector.addElement(object);
                n3 = n2;
                break;
            }
            if ((n3 = Utils.skipDelimiters(openString, string, n3, n2)) >= n2) continue;
            int n5 = n3;
            while (n3 < n2 && string.indexOf(openString.charAt(n3)) < 0) {
                ++n3;
            }
            fastVector.addElement(openString.substring(n5, n3));
            ++n4;
        }
        object = new OpenString[fastVector.size()];
        fastVector.copyInto((Object[])object);
        return object;
    }

    public static String joinStrings(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (!bl) {
                stringBuffer.append(string);
            }
            bl = false;
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String joinStrings(OpenString[] openStringArray, String string) {
        if (openStringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < openStringArray.length; ++i) {
            if (openStringArray[i] == null) continue;
            if (!bl) {
                stringBuffer.append(string);
            }
            bl = false;
            stringBuffer.append(openStringArray[i].toString());
        }
        return stringBuffer.toString();
    }

    public static String removeChars(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) >= 0) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static int countChars(String string, String string2) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) < 0) continue;
            ++n;
        }
        return n;
    }

    public static int countChar(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (c != string.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    public static int stringHashCode(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + string.charAt(i);
        }
        return n;
    }

    public static String quote(String string) {
        if (string.indexOf(32) >= 0) {
            char c = '\"';
            char c2 = '\'';
            int n = string.length();
            if (string.charAt(0) == c && string.charAt(n - 1) == c) {
                return string;
            }
            if (string.charAt(0) == c2 && string.charAt(n - 1) == c2) {
                return string;
            }
            String string2 = string.indexOf(c) >= 0 ? "'" : "\"";
            return string2 + string + string2;
        }
        return string;
    }

    public static final String stuffLink(String string, String string2) {
        return Utils.stuffLink(string, string2, false);
    }

    public static String stuffLink(String string, String string2, boolean bl) {
        if (!bl) {
            string2 = URLEncoder.encode(Utils.quote(string2));
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("%s");
        if (n >= 0) {
            stringBuffer.append(string.substring(0, n));
            int n2 = string.indexOf("%s", n += 2);
            if (n2 > 0) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string2);
                int n3 = string.indexOf(">", n2 += 2);
                if (n3 > 0) {
                    stringBuffer.append(string.substring(n2, n3 + 1));
                } else {
                    n = string.indexOf("%s", n2);
                    if (n > 0) {
                        stringBuffer.append(string.substring(n2, n));
                        stringBuffer.append(string.substring(n + 2));
                    } else {
                        stringBuffer.append(string.substring(n2));
                    }
                }
            } else {
                stringBuffer.append(string2);
                stringBuffer.append(string.substring(n));
            }
        } else {
            stringBuffer.append(string);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static boolean isUrl(String string) {
        try {
            URL uRL = new URL(string);
            return uRL != null;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static String stripHtmlCodes(String string) {
        int n;
        int n2 = string.indexOf(60);
        if (n2 >= 0 && (n = string.indexOf(62, n2)) > n2) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
            int n3 = n + 1;
            int n4 = string.length();
            int n5 = n2 = n3 >= n4 ? -1 : string.indexOf(60, n3);
            while (n2 > 0) {
                n = string.indexOf(62, n2);
                if (n > n2) {
                    stringBuffer.append(string.substring(n3, n2));
                    n3 = n + 1;
                    n2 = n3 >= n4 ? -1 : string.indexOf(60, n3);
                    continue;
                }
                n2 = -1;
            }
            if (n3 < n4) {
                stringBuffer.append(string.substring(n3));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    static void initHtmlCodes() {
        htmlcodes = new Hashtable();
        htmlcodes.put("<p>", "\n");
        htmlcodes.put("<br>", "\n");
        htmlcodes.put("<hr>", "\n---------------------------\n");
        htmlcodes.put("<sup>", "[");
        htmlcodes.put("</sup>", "]");
        htmlcodes.put("<sub>", "[[");
        htmlcodes.put("</sub>", "]]");
        isocodes = new Hashtable();
        isocodes.put("&lt;", "<");
        isocodes.put("&gt;", ">");
        isocodes.put("&amp;", "&");
        isocodes.put("&quot;", "\"");
        isocodes.put("&reg;", "TM");
        isocodes.put("&copy;", "(C)");
        isocodes.put("&nbsp;", " ");
    }

    public static String convertHtmlCode(String string) {
        if (htmlcodes == null) {
            Utils.initHtmlCodes();
        }
        return (String)htmlcodes.get(string.toLowerCase());
    }

    public static String convertIsoCode(String string) {
        String string2;
        if (isocodes == null) {
            Utils.initHtmlCodes();
        }
        if ((string2 = (String)isocodes.get(string.toLowerCase())) != null) {
            return string2;
        }
        if (string.length() > 4 && string.charAt(1) == '#') {
            try {
                int n = Integer.parseInt(string.substring(2, 5));
                string2 = new Character((char)n).toString();
                return string2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static String isoCodesToText(String string) {
        int n;
        int n2 = string.indexOf(38);
        if (n2 >= 0 && (n = string.indexOf(59, n2)) > n2 && n < n2 + 8) {
            int n3;
            int n4;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
            String string2 = Utils.convertIsoCode(string.substring(n2, n + 1));
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            int n5 = n2 = (n4 = n + 1) >= (n3 = string.length()) ? -1 : string.indexOf(38, n4);
            while (n2 > 0) {
                n = string.indexOf(59, n2);
                if (n > n2 && n < n2 + 8) {
                    stringBuffer.append(string.substring(n4, n2));
                    string2 = Utils.convertIsoCode(string.substring(n2, n + 1));
                    if (string2 != null) {
                        stringBuffer.append(string2);
                    }
                    n2 = (n4 = n + 1) >= n3 ? -1 : string.indexOf(38, n4);
                    continue;
                }
                n2 = -1;
            }
            if (n4 < n3) {
                stringBuffer.append(string.substring(n4));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String htmlToText(String string) {
        int n;
        int n2 = string.indexOf(60);
        if (n2 >= 0 && (n = string.indexOf(62, n2)) > n2) {
            int n3;
            int n4;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
            String string2 = Utils.convertHtmlCode(string.substring(n2, n + 1));
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            int n5 = n2 = (n4 = n + 1) >= (n3 = string.length()) ? -1 : string.indexOf(60, n4);
            while (n2 > 0) {
                n = string.indexOf(62, n2);
                if (n > n2) {
                    stringBuffer.append(string.substring(n4, n2));
                    string2 = Utils.convertHtmlCode(string.substring(n2, n + 1));
                    if (string2 != null) {
                        stringBuffer.append(string2);
                    }
                    n2 = (n4 = n + 1) >= n3 ? -1 : string.indexOf(60, n4);
                    continue;
                }
                n2 = -1;
            }
            if (n4 < n3) {
                stringBuffer.append(string.substring(n4));
            }
            string = stringBuffer.toString();
        }
        return Utils.isoCodesToText(string);
    }

    public static String titleToSentenceCase(String string) {
        if (string.length() > 1 && Character.isUpperCase(string.charAt(0)) && Character.isLowerCase(string.charAt(1))) {
            return string.toLowerCase();
        }
        return string;
    }

    public static OpenString titleToSentenceCase(OpenString openString) {
        if (openString.length() > 1 && Character.isUpperCase(openString.charAt(0)) && Character.isLowerCase(openString.charAt(1))) {
            return new OpenString(openString.toLowerCase());
        }
        return openString;
    }

    public static OpenString trimSentenceEnd(OpenString openString, int n) {
        int n2;
        int n3 = openString.indexOf(". ");
        if (n3 < 0 && (n2 = openString.length() - 1) >= 0 && openString.charAt(n2) == '.') {
            n3 = n2;
        }
        if (n < 0 || n3 > 0 && n3 < n) {
            n = n3;
        }
        if (n >= 0) {
            openString = openString.substring(0, n).trim();
        }
        return openString;
    }

    public static String trimSentenceEnd(String string, int n) {
        int n2;
        if (n < 0) {
            n = string.indexOf(". ");
        }
        if (n < 0 && (n2 = string.lastIndexOf(".")) == string.length() - 1) {
            n = n2;
        }
        if (n >= 0) {
            string = string.substring(0, n).trim();
        }
        return string;
    }

    public static String fileSizeLabel(long l, boolean bl) {
        String string;
        String string2;
        if (l >= 1024000000L) {
            string2 = Long.toString(l / 102400000L);
            string = bl ? "Gb" : " Gigabytes";
        } else if (l >= 1024000L) {
            string2 = Long.toString(l / 102400L);
            string = bl ? "Mb" : " Megabytes";
        } else if (l >= 1024L) {
            string2 = Long.toString(l / 100L);
            string = bl ? "kb" : " kilobytes";
        } else {
            return Long.toString(l) + (bl ? "b" : " bytes");
        }
        int n = string2.length() - 1;
        if (n > 0) {
            String string3 = string2.substring(n);
            string2 = string2.substring(0, n);
            if (n < 2 && !string3.equals("0")) {
                string2 = string2 + "." + string3;
            }
        }
        return string2 + string;
    }

    public static String formatString(String string, int n) {
        int n2 = string.length();
        if (n > n2) {
            string = spaces.substring(0, n - n2) + string;
        } else if (-n > n2) {
            string = string + spaces.substring(0, -n - n2);
        }
        return string;
    }

    public static final String formatNum(int n, int n2) {
        return Utils.formatString(String.valueOf(n), n2);
    }

    public static final String formatDouble(double d, int n, int n2) {
        return Utils.formatReal(String.valueOf(d), n, n2);
    }

    public static final String formatFloat(float f, int n, int n2) {
        return Utils.formatReal(String.valueOf(f), n, n2);
    }

    public static String formatReal(String string, int n, int n2) {
        int n3 = string.indexOf(46);
        if (n3 > 0) {
            int n4;
            for (n4 = string.length(); n4 > n3 && string.charAt(n4 - 1) == '0'; --n4) {
            }
            if (n4 - 1 == n3 || n2 == 0) {
                n4 = n3;
            } else if (n2 > 0 && (n3 += n2 + 1) < n4) {
                n4 = n3;
            }
            string = string.substring(0, n4);
        }
        return Utils.formatString(string, n);
    }

    public static int hexValue(String string) {
        int n = (string = string.trim()).indexOf("0x");
        if (n < 0) {
            n = string.indexOf("0X");
        }
        if (n >= 0) {
            n += 2;
        }
        if (n > 0) {
            string = string.substring(n);
        }
        try {
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static long hexLongValue(String string) {
        int n = (string = string.trim()).indexOf("0x");
        if (n < 0) {
            n = string.indexOf("0X");
        }
        if (n >= 0) {
            n += 2;
        }
        if (n > 0) {
            string = string.substring(n);
        }
        return Long.parseLong(string, 16);
    }

    public static BitSet bitset(String string) {
        BitSet bitSet = new BitSet();
        String[] stringArray = Utils.splitString(string, " ,\t\n");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                bitSet.set(Integer.parseInt(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bitSet;
    }

    public static boolean findString(String[] stringArray, String string, boolean bl) {
        if (stringArray == null || string == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(bl ? string.indexOf(stringArray[i]) >= 0 : string.equals(stringArray[i]))) continue;
            return true;
        }
        return false;
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '+') {
                cArray[n++] = 32;
                continue;
            }
            if (c == '%') {
                try {
                    cArray[n++] = (char)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                    i += 2;
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.println("urlDecode:" + string.substring(i, i + 3) + " is an invalid code");
                }
                continue;
            }
            cArray[n++] = c;
        }
        return String.valueOf(cArray, 0, n);
    }

    public static void pipeStream(InputStream inputStream, OutputStream outputStream) {
        if (outputStream != null && inputStream != null) {
            try {
                int n;
                byte[] byArray = new byte[2048];
                do {
                    if ((n = inputStream.read(byArray)) <= 0) continue;
                    outputStream.write(byArray, 0, n);
                } while (n >= 0);
                outputStream.flush();
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void pipeTextStream(InputStream inputStream, OutputStream outputStream) {
        if (outputStream != null && inputStream != null) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                inputStream.close();
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void writeObject(OutputStream outputStream, Object object, boolean bl) {
        block4: {
            try {
                if (bl) {
                    GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
                    outputStream = gZIPOutputStream;
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                if (bl) {
                    objectOutputStream.close();
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
                if (!Debug.isOn) break block4;
                exception.printStackTrace();
            }
        }
    }

    public static Object readObject(InputStream inputStream, boolean bl) {
        Object object;
        block3: {
            object = null;
            try {
                GZIPInputStream gZIPInputStream = null;
                if (bl) {
                    gZIPInputStream = new GZIPInputStream(inputStream);
                    inputStream = gZIPInputStream;
                }
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                System.err.println(exception);
                if (!Debug.isOn) break block3;
                exception.printStackTrace();
            }
        }
        return object;
    }

    public static final String encrypt(String string) {
        return Utils.encrypt(string, 23647L);
    }

    public static final String decrypt(String string) {
        return Utils.decrypt(string, 23647L);
    }

    public static String encrypt(String string, long l) {
        if (string == null || string.length() < 1) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = (char)(((long)c ^ l) & 0xFFL);
            l = ((long)c2 + l) * 52895L + 22419L;
            byteArrayOutputStream.write(37);
            byteArrayOutputStream.write(Character.forDigit(c2 >> 4, 16));
            byteArrayOutputStream.write(Character.forDigit(c2 & 0xF, 16));
        }
        return byteArrayOutputStream.toString();
    }

    public static String decrypt(String string, long l) {
        char c;
        int n;
        if (string == null || string.length() < 1) {
            return null;
        }
        char[] cArray = new char[string.length()];
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c == '%') {
                try {
                    cArray[n2++] = (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
                    n += 2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InternalError("decrypt: invalid code");
                }
            }
            cArray[n2++] = c;
        }
        for (n = 0; n < n2; ++n) {
            c = cArray[n];
            char c2 = (char)(((long)c ^ l) & 0xFFL);
            l = ((long)c + l) * 52895L + 22419L;
            cArray[n] = c2;
        }
        return String.valueOf(cArray, 0, n2);
    }

    static {
        spaces = new String("                                            ");
    }
}

