/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import iubio.bioseq.SeqRangeException;

public class SeqRange
implements Cloneable {
    public static final int kDelete = 1;
    public static final int kInsert = 2;
    public static final int kReorder = 4;
    public static final int kChange = 8;
    public static final int kNoValue = Integer.MIN_VALUE;
    public static final int kZero = 1;
    public static final int kStartless = 1;
    public static final int kStartmore = 2;
    public static final int kEndless = 4;
    public static final int kEndmore = 8;
    public static final int kBetween = 16;
    public static final int kStartMatchend = 32;
    public static final int kEndMatchend = 64;
    public static final String[] sOperators = new String[]{"join", "complement", "order", "group", "one-of", "", ""};
    public static final byte opJoin = 0;
    public static final byte opComplement = 1;
    public static final byte opOrder = 2;
    public static final byte opGroup = 3;
    public static final byte opOneof = 4;
    public static final byte opMax = 5;
    public static final byte opNull = 6;
    public static boolean joinspace = false;
    protected int start;
    protected int nbases;
    protected int myZero = 1;
    protected byte uncertain;
    protected byte operation = (byte)6;
    protected SeqRange next;
    protected String refid;

    public SeqRange() {
    }

    public SeqRange(int n, int n2) {
        this.set(n, n2);
    }

    public SeqRange(int n, int n2, int n3) {
        this(n, n2, n3, null, 6, null);
    }

    public SeqRange(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, 6, null);
    }

    public SeqRange(int n, int n2, int n3, String string, String string2, SeqRange seqRange) {
        this(n, n2, n3, string, 6, seqRange);
        if (string2 != null) {
            if ("jo".equals(string2)) {
                this.operation = 0;
            } else if ("co".equals(string2)) {
                this.operation = 1;
            } else {
                for (int n4 = 0; n4 < 5; n4 = (int)((byte)(n4 + 1))) {
                    if (!sOperators[n4].equals(string2)) continue;
                    this.operation = (byte)n4;
                    break;
                }
            }
        }
    }

    public SeqRange(String string) throws SeqRangeException {
        this.parse1(string);
    }

    protected SeqRange(int n, int n2, int n3, String string, byte by, SeqRange seqRange) {
        this.start = n;
        this.nbases = n2;
        this.uncertain = (byte)n3;
        this.refid = string;
        this.next = seqRange;
        this.operation = by;
    }

    public final void set(int n, int n2) {
        this.start = n;
        this.nbases = n2;
    }

    public final int start() {
        return this.start;
    }

    public final int nbases() {
        return this.nbases;
    }

    public final int stop() {
        return this.start + this.nbases - 1;
    }

    public final int uncertain() {
        return this.uncertain;
    }

    public final SeqRange next() {
        return this.next;
    }

    public final String operation() {
        return this.operation >= 5 ? "" : sOperators[this.operation];
    }

    public final int opint() {
        return this.operation;
    }

    public final String remoteSeq() {
        return this.refid;
    }

    public final boolean isRemote() {
        return this.refid != null;
    }

    public final boolean isEmpty() {
        return this.start == 0 && this.nbases == 0 && this.next == null;
    }

    public final boolean isComplex() {
        return this.operation < 5 || this.next != null;
    }

    public final boolean isComplement() {
        return this.operation == 1;
    }

    public final int origin() {
        return this.myZero;
    }

    public final boolean stopIsEnd() {
        return (this.uncertain & 0x40) != 0;
    }

    public final boolean startIsEnd() {
        return (this.uncertain & 0x20) != 0;
    }

    public final void setStart(int n) {
        this.start = n;
    }

    public final void setNbases(int n) {
        this.nbases = n;
    }

    public int setDisplayOrigin(int n) {
        int n2 = this.myZero;
        this.myZero = n;
        for (SeqRange seqRange = this.next; seqRange != null; seqRange = seqRange.next()) {
            seqRange.myZero = n;
        }
        return n2;
    }

    public int max() {
        int n = this.stop();
        for (SeqRange seqRange = this.next; seqRange != null; seqRange = seqRange.next()) {
            n = Math.max(n, seqRange.stop());
        }
        return n;
    }

    public void copy(SeqRange seqRange) {
        this.start = seqRange.start;
        this.nbases = seqRange.nbases;
        this.uncertain = seqRange.uncertain;
        this.operation = seqRange.operation;
        this.refid = seqRange.refid;
        this.next = seqRange.next;
    }

    public void add(SeqRange seqRange) {
        if (seqRange != null && seqRange.nbases > 0) {
            if (this.nbases == 0) {
                this.copy(seqRange);
            } else {
                SeqRange seqRange2 = this;
                while (seqRange2.next != null) {
                    seqRange2 = seqRange2.next;
                }
                if (seqRange.start < seqRange2.stop()) {
                    if (seqRange.stop() < seqRange2.stop()) {
                        return;
                    }
                    seqRange.nbases += seqRange.start - seqRange2.stop();
                    seqRange.start = seqRange2.stop();
                }
                seqRange2.next = seqRange;
                if (this.operation == 6) {
                    this.operation = 0;
                }
            }
        }
    }

    public Object clone() {
        try {
            SeqRange seqRange = (SeqRange)super.clone();
            if (this.next != null) {
                seqRange.next = (SeqRange)this.next.clone();
            }
            return seqRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.toString());
        }
    }

    public final boolean updateRange(int n, int n2, int n3) {
        return this.updateRange(n, n2, n3, null);
    }

    public boolean updateRange(int n, int n2, int n3, byte[] byArray) {
        int n4;
        int n5;
        if (n2 > this.stop()) {
            return false;
        }
        int n6 = this.start;
        int n7 = this.nbases;
        int n8 = this.stop();
        if (byArray != null) {
            block4: for (n5 = 0; n5 < byArray.length && (n4 = n5 + n2) <= n8; ++n5) {
                switch (byArray[n5]) {
                    case 1: {
                        if (n4 < this.start) {
                            --this.start;
                            continue block4;
                        }
                        if (n4 > n8) continue block4;
                        --this.nbases;
                        continue block4;
                    }
                    case 2: {
                        if (n4 < this.start) {
                            ++this.start;
                            continue block4;
                        }
                        if (n4 > n8) continue block4;
                        ++this.nbases;
                    }
                }
            }
        } else if ((n & 2) != 0) {
            if (n2 < this.start) {
                this.start += n3;
            } else if (n2 <= n8) {
                this.nbases += n3;
            }
        } else if ((n & 1) != 0) {
            if (n2 < this.start) {
                this.start -= n3;
            } else if (n2 <= n8) {
                this.nbases -= n3;
            }
        }
        if (this.start < 0) {
            this.start = 0;
        }
        if (this.nbases < 0) {
            this.nbases = 0;
        }
        n5 = n6 != this.start || n7 != this.nbases ? 1 : 0;
        n4 = 0;
        if (this.next != null) {
            n4 = this.next.updateRange(n, n2, n3, byArray) ? 1 : 0;
        }
        return n5 != 0 || n4 != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.operation < 5) {
            stringBuffer.append(sOperators[this.operation]);
            stringBuffer.append('(');
        }
        this.toBuf(stringBuffer);
        if (this.operation < 5) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof SeqRange) {
            SeqRange seqRange = (SeqRange)object;
            if (this.start == seqRange.start && this.nbases == seqRange.nbases) {
                return this.next == null || this.next.equals(seqRange.next);
            }
        }
        return false;
    }

    public boolean contains(SeqRange seqRange) {
        if (seqRange == null) {
            return false;
        }
        return this.start <= seqRange.start() && this.max() >= seqRange.max();
    }

    public boolean intersects(SeqRange seqRange) {
        if (seqRange == null) {
            return false;
        }
        if (this.start <= seqRange.stop() && this.stop() >= seqRange.start) {
            return true;
        }
        if (this.next != null && this.next.intersects(seqRange)) {
            return true;
        }
        return seqRange.next != null && this.intersects(seqRange.next);
    }

    public boolean intersectsMax(SeqRange seqRange) {
        if (seqRange == null) {
            return false;
        }
        return this.start <= seqRange.max() && this.max() >= seqRange.start;
    }

    public SeqRange intersection0(SeqRange seqRange) {
        if (seqRange == null) {
            return null;
        }
        if (this.start <= seqRange.max() && this.max() >= seqRange.start) {
            int n = Math.max(this.start, seqRange.start());
            int n2 = Math.min(this.max(), seqRange.max());
            return this.newRange(n, n2 - n + 1);
        }
        return null;
    }

    public SeqRange intersection(SeqRange seqRange) {
        if (seqRange == null) {
            return this;
        }
        if (seqRange.start() <= this.start && seqRange.max() >= this.max()) {
            return this;
        }
        if (this.start <= seqRange.start() && this.max() >= seqRange.max()) {
            return seqRange;
        }
        return this.intersection0(seqRange);
    }

    public int compareTo(SeqRange seqRange) {
        int n;
        boolean bl;
        if (seqRange == null) {
            return -1;
        }
        if (this.start < seqRange.start()) {
            return -1;
        }
        if (this.start > seqRange.start()) {
            return 1;
        }
        boolean bl2 = (this.uncertain & 1) != 0;
        boolean bl3 = bl = (seqRange.uncertain & 1) != 0;
        if (bl2 && !bl) {
            return -1;
        }
        if (!bl2 && bl) {
            return 1;
        }
        int n2 = this.max();
        if (n2 < (n = seqRange.max())) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        bl2 = (this.uncertain & 2) != 0;
        boolean bl4 = bl = (seqRange.uncertain & 2) != 0;
        if (bl2 && !bl) {
            return 1;
        }
        if (!bl2 && bl) {
            return -1;
        }
        return 0;
    }

    public SeqRange invert(int n) {
        SeqRange seqRange = this.newRange();
        int n2 = 0;
        SeqRange seqRange2 = this;
        while (seqRange2 != null && n2 < n) {
            if (!seqRange2.isRemote()) {
                if (seqRange2.start > n2) {
                    seqRange.add(this.newRange(n2, seqRange2.start - n2));
                }
                n2 = seqRange2.stop() + 1;
            }
            seqRange2 = seqRange2.next;
        }
        if (n2 < n) {
            seqRange.add(this.newRange(n2, n - n2));
        }
        return seqRange;
    }

    public SeqRange joinRange(SeqRange seqRange) {
        SeqRange seqRange2 = null;
        seqRange2 = this.newRange();
        this.addRange(seqRange2, seqRange);
        if (seqRange2.next != null && seqRange2.operation == 6) {
            seqRange2.operation = 0;
        }
        return seqRange2;
    }

    protected void addRange(SeqRange seqRange, SeqRange seqRange2) {
        while (seqRange2 != null && seqRange2.isRemote()) {
            seqRange2 = seqRange2.next;
        }
        if (seqRange2 == null) {
            if (!this.isRemote()) {
                seqRange.add(new SeqRange(this.start, this.nbases, this.uncertain, this.refid));
            }
            if (this.next != null) {
                this.next.addRange(seqRange, seqRange2);
            }
        } else if (this.start == 0 && this.nbases == 0) {
            seqRange.add(new SeqRange(seqRange2.start, seqRange2.nbases, seqRange2.uncertain, seqRange2.refid));
            this.addRange(seqRange, seqRange2.next);
        } else if (!this.isRemote() && this.start <= seqRange2.stop() && this.stop() >= seqRange2.start) {
            int n = Math.min(this.start, seqRange2.start);
            int n2 = Math.max(this.stop(), seqRange2.stop());
            seqRange.add(new SeqRange(n, n2 - n + 1, this.uncertain | seqRange2.uncertain));
            if (this.next != null) {
                this.next.addRange(seqRange, seqRange2.next);
            } else if (seqRange2.next != null) {
                seqRange2.next.addRange(seqRange, null);
            }
        } else if (seqRange2.start < this.start || this.isRemote()) {
            seqRange.add(new SeqRange(seqRange2.start, seqRange2.nbases, seqRange2.uncertain, seqRange2.refid));
            this.addRange(seqRange, seqRange2.next);
        } else {
            seqRange.add(new SeqRange(this.start, this.nbases, this.uncertain, this.refid));
            seqRange2.addRange(seqRange, this.next);
        }
    }

    public SeqRange subrange(SeqRange seqRange) {
        if (seqRange == null || seqRange.isEmpty()) {
            return this;
        }
        SeqRange seqRange2 = this.newRange();
        SeqRange seqRange3 = this;
        if (this.isComplement()) {
            seqRange3 = this.reverse();
        }
        SeqRange seqRange4 = seqRange;
        while (seqRange4 != null) {
            int n = seqRange4.stopIsEnd() ? seqRange3.max() + seqRange4.stop() : seqRange3.start() + seqRange4.stop();
            int n2 = seqRange4.startIsEnd() ? seqRange3.max() + seqRange4.start() : seqRange3.start() + seqRange4.start();
            if (n <= seqRange3.start()) {
                seqRange2.add(this.newRange(n2, n - n2 + 1));
            } else if (n2 >= seqRange3.max()) {
                seqRange2.add(this.newRange(n2, n - n2 + 1));
            } else {
                seqRange3.subRange(seqRange2, seqRange4, n2, n);
            }
            seqRange4 = seqRange4.next;
        }
        if (this.isComplement()) {
            seqRange2 = seqRange2.reverse();
            seqRange2.operation = this.operation;
        } else if (seqRange2.next != null && seqRange2.operation == 6) {
            seqRange2.operation = 0;
        }
        return seqRange2;
    }

    protected void subRange(SeqRange seqRange, SeqRange seqRange2, int n, int n2) {
        if (seqRange2 != null) {
            if (this.start == 0 && this.nbases == 0) {
                if (this.next != null) {
                    this.next.subRange(seqRange, seqRange2, n, n2);
                }
            } else {
                if (n2 < this.start) {
                    if (seqRange.isEmpty()) {
                        seqRange.add(this.newRange(n, n2 - n + 1));
                    }
                    return;
                }
                if (n > this.stop()) {
                    if (this.next != null) {
                        this.next.subRange(seqRange, seqRange2, n, n2);
                    }
                    if (seqRange.isEmpty()) {
                        seqRange.add(this.newRange(n, n2 - n + 1));
                    }
                    return;
                }
                int n3 = this.start;
                int n4 = this.stop();
                n3 = n < this.start ? (seqRange.isEmpty() ? n : this.start) : Math.max(n, this.start());
                n4 = n2 > this.stop() ? (this.next == null ? n2 : this.stop()) : Math.min(n2, this.stop());
                SeqRange seqRange3 = this.newRange(n3, n4 - n3 + 1);
                seqRange.add(seqRange3);
                if (this.next != null) {
                    this.next.subRange(seqRange, seqRange2, n, n2);
                }
            }
        }
    }

    public SeqRange reverse() {
        SeqRange seqRange = this.newRange();
        this.reverseRange(seqRange);
        seqRange.operation = this.operation;
        return seqRange;
    }

    protected void reverseRange(SeqRange seqRange) {
        if (this.next != null) {
            this.next.reverseRange(seqRange);
        }
        SeqRange seqRange2 = new SeqRange(-this.start - this.nbases, this.nbases, (int)this.uncertain, null, this.operation, null);
        seqRange.add(seqRange2);
    }

    protected void toBuf(StringBuffer stringBuffer) {
        boolean bl;
        if (this.refid != null) {
            stringBuffer.append(this.refid);
            stringBuffer.append(':');
        }
        if ((this.uncertain & 1) != 0) {
            stringBuffer.append('<');
        } else if ((this.uncertain & 2) != 0) {
            stringBuffer.append('>');
        }
        if ((this.uncertain & 0x20) != 0) {
            stringBuffer.append("end");
        }
        stringBuffer.append(this.start + this.myZero);
        boolean bl2 = bl = (this.uncertain & 0x5C) != 0;
        if (bl || this.nbases > 1) {
            if ((this.uncertain & 0x10) != 0) {
                stringBuffer.append('^');
            } else {
                stringBuffer.append("..");
            }
            if ((this.uncertain & 4) != 0) {
                stringBuffer.append('<');
            } else if ((this.uncertain & 8) != 0) {
                stringBuffer.append('>');
            }
            if ((this.uncertain & 0x40) != 0) {
                stringBuffer.append("end");
            }
            stringBuffer.append(this.stop() + this.myZero);
        }
        if (this.next != null) {
            stringBuffer.append(',');
            if (joinspace) {
                stringBuffer.append(' ');
            }
            this.next.toBuf(stringBuffer);
        }
    }

    protected final int getMyMark(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            this.refid = string.substring(0, n);
            string = string.substring(n + 1);
        }
        return this.getMyMark(string, 1, 2, 32);
    }

    protected final int getMyEndMark(String string) {
        return this.getMyMark(string, 4, 8, 64);
    }

    protected int getMyMark(String string, int n, int n2, int n3) {
        boolean bl = false;
        int n4 = Integer.MIN_VALUE;
        int n5 = -1;
        int n6 = -1;
        int n7 = string.length();
        block10: for (int i = 0; i < n7; ++i) {
            char c = string.charAt(i);
            if (c <= ' ') continue;
            if (c >= '0' && c <= '9') {
                n6 = i;
                if (n5 != -1) continue;
                n5 = i;
                continue;
            }
            if (n5 >= 0) break;
            switch (c) {
                case '<': {
                    this.uncertain = (byte)(this.uncertain | n);
                    continue block10;
                }
                case '>': {
                    this.uncertain = (byte)(this.uncertain | n2);
                    continue block10;
                }
                case '^': {
                    this.uncertain = (byte)(this.uncertain | 0x10);
                    continue block10;
                }
                case '-': {
                    bl = true;
                    continue block10;
                }
                case '+': {
                    bl = false;
                    continue block10;
                }
                case 'e': {
                    if (i + 1 < n7 && string.charAt(i + 1) == 'n') {
                        ++i;
                    }
                    if (i + 1 < n7 && string.charAt(i + 1) == 'd') {
                        ++i;
                    }
                    this.uncertain = (byte)(this.uncertain | n3);
                    n4 = 0;
                }
            }
        }
        if (n5 < 0) {
            return n4;
        }
        try {
            n4 = Integer.parseInt(string.substring(n5, n6 + 1));
        }
        catch (Exception exception) {
            return Integer.MIN_VALUE;
        }
        if (bl) {
            n4 = -n4;
        }
        return n4 -= this.myZero;
    }

    protected boolean getMyRange(String string) {
        int n = 2;
        int n2 = string.indexOf("..");
        if (n2 < 0 && (n2 = string.indexOf(94)) > 0) {
            this.uncertain = (byte)(this.uncertain | 0x10);
            n = 1;
        }
        if (n2 >= 0) {
            int n3 = this.getMyMark(string.substring(0, n2));
            int n4 = this.getMyEndMark(string.substring(n2 + n));
            if (n3 == Integer.MIN_VALUE) {
                if (n4 == Integer.MIN_VALUE) {
                    return false;
                }
                this.set(n4, 1);
            } else if (n4 == Integer.MIN_VALUE) {
                this.set(n3, 1);
            } else {
                this.set(n3, n4 - n3 + 1);
            }
        } else {
            int n5 = this.getMyMark(string);
            if (n5 == Integer.MIN_VALUE) {
                return false;
            }
            this.set(n5, 1);
        }
        return true;
    }

    protected boolean getNextJoin(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = string.indexOf(44);
        if (n < 0) {
            return this.getMyRange(string);
        }
        if (!this.getMyRange(string.substring(0, n))) {
            return this.getNextJoin(string.substring(n + 1));
        }
        SeqRange seqRange = this.newRange();
        boolean bl = seqRange.getNextJoin(string.substring(n + 1));
        if (bl) {
            this.next = seqRange;
        }
        return bl;
    }

    public SeqRange newRange() {
        SeqRange seqRange = new SeqRange();
        seqRange.myZero = this.myZero;
        return seqRange;
    }

    public SeqRange newRange(int n, int n2) {
        SeqRange seqRange = new SeqRange(n, n2);
        seqRange.myZero = this.myZero;
        return seqRange;
    }

    public void parse1(String string) throws SeqRangeException {
        try {
            int n;
            this.operation = (byte)6;
            string = string.trim();
            if (string.length() == 0) {
                return;
            }
            if (string.startsWith("jo(")) {
                this.operation = 0;
            } else if (string.startsWith("co(")) {
                this.operation = 1;
            } else {
                for (n = 0; n < 5; n = (int)((byte)(n + 1))) {
                    if (!string.startsWith(sOperators[n])) continue;
                    this.operation = (byte)n;
                    break;
                }
            }
            if (this.operation != 6) {
                n = 0;
                int n2 = string.indexOf(40);
                if (n2 >= 0) {
                    n = string.indexOf(41, n2);
                }
                if (n < 0) {
                    n = string.length();
                }
                string = n2 > 0 ? string.substring(n2 + 1, n) : string.substring(sOperators[this.operation].length());
            }
            this.getNextJoin(string);
        }
        catch (Exception exception) {
            throw new SeqRangeException("SeqRange error parsing '" + string + "'");
        }
    }

    public static SeqRange parse(String string) throws SeqRangeException {
        if (string == null) {
            return null;
        }
        SeqRange seqRange = new SeqRange();
        seqRange.parse1(string);
        return seqRange;
    }
}

