/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Environ;
import flybase.FastProperties;
import flybase.FastVector;
import iubio.readseq.BioseqFileFilter;
import iubio.readseq.BioseqFormats;
import iubio.readseq.GetFeaturelist;
import iubio.readseq.GetUrls;
import iubio.readseq.MakeFileChooser;
import iubio.readseq.MessageApp;
import iubio.readseq.XmlSeqWriter;
import iubio.readseq.app;
import iubio.readseq.help;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class AppFrame
extends JFrame
implements MessageApp {
    public static String propname = "AppFrame";
    public static final String labelSuffix = "Label";
    public static final String tooltipSuffix = "Tip";
    public static final String checkedSuffix = "Checked";
    public static final String radioSuffix = "Radio";
    public static final String radioGroupSuffix = "Group";
    public static final String actionSuffix = "Action";
    private app myapp;
    private FastProperties props = new FastProperties();
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    protected JFileChooser fchooser;
    protected BioseqFileFilter bioseqfilter;
    protected JTextArea messageText;
    private String choosenOutputName;
    private FastVector inputitems = new FastVector();
    private Action[] defaultActions;
    private RunAction runact;
    StyleSheet defaultStyles;
    boolean gotStyles;
    Hashtable radiogroups = new Hashtable();

    public AppFrame(app app2) {
        this.myapp = app2;
        String string = System.getProperty(propname, propname);
        this.props.loadProperties(string);
        this.initframe();
        app2.pretty.userset();
        MakeFileChooser makeFileChooser = new MakeFileChooser(this);
        makeFileChooser.start();
    }

    protected void initframe() {
        Object object;
        this.commands = new Hashtable();
        Action[] actionArray = this.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            object = actionArray[i];
            this.commands.put(object.getValue("Name"), object);
        }
        this.menuItems = new Hashtable();
        this.menubar = this.createMenubar("menubar", this.commands);
        this.setJMenuBar(this.menubar);
        this.setTitle(this.props.getProperty("title", "Readseq"));
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                try {
                    this.finalize();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        JPanel jPanel = new JPanel();
        object = this.makeFormatChoice();
        JLabel jLabel = new JLabel("Output format:");
        jLabel.setFont(new Font("dialog", 0, 12));
        jLabel.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        jLabel.setEnabled(true);
        jLabel.setToolTipText("Select sequence format for saving output");
        jPanel.add(jLabel);
        jPanel.add((Component)object);
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("Center", this.makeMessageBox());
        this.pack();
        Dimension dimension = this.getToolkit().getScreenSize();
        int n = Environ.gEnv.getInt("ReadseqApp.width", 450);
        int n2 = Environ.gEnv.getInt("ReadseqApp.height", 350);
        this.setSize(n, n2);
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
    }

    public void errmessage(String string) {
        this.messageText.append(string + "\n");
        int n = this.messageText.getDocument().getLength();
        this.messageText.select(n, n);
    }

    public void infomessage(String string) {
        this.messageText.append(string + "\n");
        int n = this.messageText.getDocument().getLength();
        this.messageText.select(n, n);
    }

    void initFileChooser() {
        if (this.fchooser == null) {
            this.fchooser = new JFileChooser();
            this.fchooser.setFileSelectionMode(2);
            this.fchooser.setMultiSelectionEnabled(true);
            this.bioseqfilter = new BioseqFileFilter();
            FileFilter[] fileFilterArray = this.fchooser.getChoosableFileFilters();
            for (int i = 0; i < fileFilterArray.length; ++i) {
                this.fchooser.removeChoosableFileFilter(fileFilterArray[i]);
            }
            this.fchooser.addChoosableFileFilter(this.bioseqfilter);
            this.fchooser.addChoosableFileFilter(this.fchooser.getAcceptAllFileFilter());
            File file = new File(System.getProperty("user.dir"));
            this.fchooser.setCurrentDirectory(file);
        }
    }

    JComponent makeFormatChoice() {
        Object object;
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = BioseqFormats.nFormats();
        for (int i = 0; i <= n; ++i) {
            if (!BioseqFormats.canwrite(i)) continue;
            object = BioseqFormats.formatName(i);
            jComboBox.addItem((String)object);
        }
        String string = BioseqFormats.formatName(BioseqFormats.getFormatId(this.myapp.outformat));
        jComboBox.setSelectedItem(string);
        jComboBox.getAccessibleContext().setAccessibleName("Biosequence formats");
        jComboBox.getAccessibleContext().setAccessibleDescription("Choose a file format");
        object = this.getAction("outformat");
        if (object != null) {
            jComboBox.addActionListener((ActionListener)object);
            jComboBox.setEnabled(object.isEnabled());
        } else {
            jComboBox.setEnabled(false);
        }
        return jComboBox;
    }

    JComponent makeMessageBox() {
        String string = Environ.gEnv.get("ReadseqApp.textFont", "monospaced-plain-10");
        this.messageText = new JTextArea(20, 85);
        this.messageText.setFont(Font.decode(string));
        this.messageText.setEditable(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.messageText){

            public Dimension getPreferredSize() {
                Dimension dimension = AppFrame.this.getSize();
                return new Dimension(dimension.width, dimension.height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(100, 50);
            }
        }, "Center");
        this.messageText.setBorder(new EmptyBorder(4, 4, 4, 4));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Messages"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return jPanel;
    }

    protected JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.menuItems.get(string);
    }

    protected Action getAction(String string) {
        return (Action)this.commands.get(string);
    }

    protected Frame getFrame(Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof Frame)) continue;
                return (Frame)container;
            }
        }
        return null;
    }

    public Action[] getActions() {
        if (this.defaultActions == null) {
            this.runact = new RunAction();
            this.defaultActions = new Action[]{new ListAction(), new LcAction(), new UcAction(), new NcAction(), new DegapAction(), new ChecksumAction(), new ReverseAction(), new TranslateAction(), new VerboseAction(), new OutformatAction(), new InformatAction(), new NameleftAction(), new NamerightAction(), new NametopAction(), new NamewidthAction(), new NumleftAction(), new NumrightAction(), new NumtopAction(), new NumbotAction(), new MatchcAction(), new GapcountAction(), new SeqwidthAction(), new TabAction(), new ColtabAction(), new XmlDtdAction(), new ChoosefeatAction(), new RemovefeatAction(), new AllfeatAction(), new SubrangeAction(), new ExtractRangeAction(), new ClearopenAction(), new AboutAction(), new AboutDetailsAction(), new AboutFormatAction(), new AboutAllFormatsAction(), this.runact, new OpenurlAction(), new OpenAction(), new SaveAction(), new QuitAction()};
        }
        return this.defaultActions;
    }

    void checkEnabledActions() {
        this.runact.checkEnabled();
    }

    public StyleSheet getStyleSheet() {
        if (!this.gotStyles) {
            StyleSheet styleSheet = new StyleSheet();
            this.gotStyles = true;
            try {
                InputStream inputStream = AppResources.global.getStream("readseq.css");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                styleSheet.loadRules(bufferedReader, null);
                ((Reader)bufferedReader).close();
            }
            catch (Throwable throwable) {
                return null;
            }
            this.defaultStyles = styleSheet;
        }
        return this.defaultStyles;
    }

    protected void openActionFrame(JTextComponent jTextComponent, String string, String string2) {
        Object object;
        JScrollPane jScrollPane = new JScrollPane(jTextComponent);
        Dimension dimension = this.getToolkit().getScreenSize();
        jScrollPane.setMaximumSize(new Dimension(dimension.width - 200, dimension.height - 100));
        Action[] actionArray = new Action[]{new SaveTextAction(jTextComponent), new CloseTextAction(jTextComponent), new CopyTextAction(jTextComponent), new PrintTextAction(jTextComponent)};
        Hashtable<Object, Action> hashtable = new Hashtable<Object, Action>();
        for (int i = 0; i < actionArray.length; ++i) {
            object = actionArray[i];
            hashtable.put(object.getValue("Name"), (Action)object);
        }
        JFrame jFrame = new JFrame(string);
        object = this.createMenubar(string2, hashtable);
        if (object != null) {
            jFrame.setJMenuBar((JMenuBar)object);
        }
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        jFrame.setLocation(90, 50);
        jFrame.setVisible(true);
    }

    protected JMenuBar createMenubar(String string, Hashtable hashtable) {
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = this.tokenize(this.props.getProperty(string));
        for (int i = 0; i < stringArray.length; ++i) {
            JMenu jMenu = this.createMenu(stringArray[i], hashtable);
            if (jMenu == null) continue;
            jMenuBar.add(jMenu);
        }
        return jMenuBar;
    }

    protected JMenu createMenu(String string, Hashtable hashtable) {
        String[] stringArray = this.tokenize(this.props.getProperty(string));
        String string2 = this.props.getProperty(string + labelSuffix);
        if (string2 == null) {
            string2 = string;
        }
        JMenu jMenu = new JMenu(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                jMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = this.createMenuItem(stringArray[i], hashtable);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    protected JMenuItem createMenuItem(String string, Hashtable hashtable) {
        JMenuItem jMenuItem;
        boolean bl;
        Object object;
        String string2 = this.props.getProperty(string + actionSuffix);
        if (string2 == null) {
            string2 = string;
        }
        Action action = hashtable == null ? null : (Action)hashtable.get(string);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string3 = this.props.getProperty(string + checkedSuffix);
        if (string3 != null) {
            bl2 = true;
        } else {
            string3 = this.props.getProperty(string + radioSuffix);
            if (string3 != null) {
                bl3 = true;
            } else {
                string3 = this.props.getProperty(string + labelSuffix);
            }
        }
        if (bl2) {
            object = action == null ? null : (Boolean)action.getValue("BoolValue");
            bl = object != null ? (Boolean)object : bl4;
            jMenuItem = new JCheckBoxMenuItem(string3, bl);
        } else if (bl3) {
            object = action == null ? null : (Boolean)action.getValue("BoolValue");
            bl = object != null ? (Boolean)object : bl4;
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string3, bl);
            jMenuItem = jRadioButtonMenuItem;
            String string4 = action == null ? "bgroup" : (String)action.getValue(radioGroupSuffix);
            ButtonGroup buttonGroup = (ButtonGroup)this.radiogroups.get(string4);
            if (buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                this.radiogroups.put(string4, buttonGroup);
            }
            buttonGroup.add(jRadioButtonMenuItem);
        } else {
            object = action == null ? null : (String)action.getValue("StringValue");
            jMenuItem = object != null ? new ValueMenuItem(string3, (String)object) : new JMenuItem(string3);
        }
        jMenuItem.setActionCommand(string2);
        object = this.props.getProperty(string + tooltipSuffix);
        if (object != null) {
            jMenuItem.setToolTipText((String)object);
        }
        if (action != null) {
            ActionChangedListener actionChangedListener = new ActionChangedListener(jMenuItem);
            jMenuItem.addActionListener(action);
            action.addPropertyChangeListener(actionChangedListener);
            jMenuItem.setEnabled(action.isEnabled());
        } else {
            jMenuItem.setEnabled(false);
        }
        this.menuItems.put(string, jMenuItem);
        return jMenuItem;
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            } else if (string.equals("StringValue")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                if (this.menuItem instanceof ValueMenuItem) {
                    ((ValueMenuItem)this.menuItem).setValue(string3);
                }
            }
        }
    }

    private class ValueMenuItem
    extends JMenuItem {
        String val;
        String lab;

        ValueMenuItem(String string, String string2) {
            super(string);
            this.lab = string;
            this.setValue(string2);
        }

        void setValue(String string) {
            this.val = string;
            String string2 = this.lab;
            if (string != null) {
                string2 = string2 + " [" + string + "]";
            }
            this.setText(string2);
        }
    }

    class RunAction
    extends AbstractAction {
        RunAction() {
            super("run");
            this.checkEnabled();
        }

        void checkEnabled() {
            this.setEnabled(AppFrame.this.choosenOutputName != null && AppFrame.this.inputitems != null && !AppFrame.this.inputitems.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((AppFrame)AppFrame.this).myapp.outname = AppFrame.this.choosenOutputName;
            AppFrame.this.myapp.setInputObjects(AppFrame.this.inputitems);
            Thread thread = new Thread(AppFrame.this.myapp);
            thread.start();
            AppFrame.this.choosenOutputName = null;
            this.checkEnabled();
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("open");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AppFrame.this.fchooser == null) {
                AppFrame.this.initFileChooser();
            }
            AppFrame.this.fchooser.setFileSelectionMode(2);
            AppFrame.this.fchooser.setMultiSelectionEnabled(true);
            int n = AppFrame.this.fchooser.showOpenDialog(AppFrame.this);
            if (n == 0) {
                File file;
                File[] fileArray = AppFrame.this.fchooser.getSelectedFiles();
                if (fileArray.length == 0 && (file = AppFrame.this.fchooser.getSelectedFile()) != null) {
                    fileArray = new File[]{file};
                }
                if (fileArray.length == 0) {
                    AppFrame.this.errmessage("\n No files selected");
                } else {
                    int n2;
                    for (n2 = 0; n2 < fileArray.length; ++n2) {
                        AppFrame.this.inputitems.addElement(fileArray[n2]);
                    }
                    AppFrame.this.infomessage("Will read data from these items: ");
                    for (n2 = 0; n2 < AppFrame.this.inputitems.size(); ++n2) {
                        AppFrame.this.infomessage(String.valueOf(AppFrame.this.inputitems.elementAt(n2)));
                    }
                    AppFrame.this.checkEnabledActions();
                }
            }
        }
    }

    class OpenurlAction
    extends AbstractAction {
        OpenurlAction() {
            super("openurl");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GetUrls getUrls = new GetUrls(AppFrame.this);
            if (getUrls.choose()) {
                int n;
                FastVector fastVector = getUrls.getValue();
                for (n = 0; n < fastVector.size(); ++n) {
                    AppFrame.this.inputitems.addElement(fastVector.elementAt(n));
                }
                AppFrame.this.infomessage("Will read data from these items: ");
                for (n = 0; n < AppFrame.this.inputitems.size(); ++n) {
                    AppFrame.this.infomessage(String.valueOf(AppFrame.this.inputitems.elementAt(n)));
                }
                AppFrame.this.checkEnabledActions();
            }
        }
    }

    class ClearopenAction
    extends AbstractAction {
        ClearopenAction() {
            super("clearopen");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AppFrame.this.inputitems.removeAllElements();
            AppFrame.this.infomessage("Input data cleared. ");
            AppFrame.this.checkEnabledActions();
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("save");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (AppFrame.this.fchooser == null) {
                AppFrame.this.initFileChooser();
            }
            AppFrame.this.fchooser.setFileSelectionMode(0);
            AppFrame.this.fchooser.setMultiSelectionEnabled(false);
            File file = AppFrame.this.fchooser.getSelectedFile();
            if (file != null) {
                AppFrame.this.myapp.setInputObjects(AppFrame.this.inputitems);
                String string = AppFrame.this.myapp.guessOutname(BioseqFormats.getFormatId(((AppFrame)AppFrame.this).myapp.outformat));
                file = new File(file.getParent(), string);
                AppFrame.this.fchooser.setSelectedFile(file);
            }
            if ((n = AppFrame.this.fchooser.showSaveDialog(AppFrame.this)) == 0) {
                File file2 = AppFrame.this.fchooser.getSelectedFile();
                boolean bl = false;
                if (file2.exists()) {
                    String string = "Replace file?";
                    String string2 = "Replace existing '" + file2.getName() + "' ?";
                    Object[] objectArray = new Object[]{"Replace", "Cancel"};
                    int n2 = JOptionPane.showOptionDialog(AppFrame.this, string2, string, 0, 2, null, objectArray, objectArray[0]);
                    bl = n2 == 0;
                } else {
                    bl = true;
                }
                if (bl) {
                    AppFrame.this.choosenOutputName = file2.toString();
                    AppFrame.this.infomessage("Save output to: " + AppFrame.this.choosenOutputName);
                    AppFrame.this.checkEnabledActions();
                }
            }
        }
    }

    class SaveTextAction
    extends TextAction {
        SaveTextAction(JTextComponent jTextComponent) {
            super("saved", jTextComponent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.jtext == null) {
                return;
            }
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            int n = jFileChooser.showSaveDialog(AppFrame.this.getFrame(this.jtext));
            if (n == 0) {
                try {
                    FileWriter fileWriter = new FileWriter(jFileChooser.getSelectedFile());
                    this.jtext.write(fileWriter);
                    fileWriter.close();
                }
                catch (Exception exception) {
                    AppFrame.this.errmessage("Error: " + exception);
                }
            }
        }
    }

    class CopyTextAction
    extends TextAction {
        CopyTextAction(JTextComponent jTextComponent) {
            super("copyd", jTextComponent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.jtext == null) {
                return;
            }
            if (this.jtext.getSelectionStart() < this.jtext.getSelectionEnd()) {
                this.jtext.copy();
            } else {
                Clipboard clipboard = this.jtext.getToolkit().getSystemClipboard();
                String string = this.jtext.getText();
                clipboard.setContents(new StringSelection(string), null);
            }
        }
    }

    class CloseTextAction
    extends TextAction {
        CloseTextAction(JTextComponent jTextComponent) {
            super("closed", jTextComponent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = AppFrame.this.getFrame(this.jtext);
            if (frame != null) {
                frame.setVisible(false);
                frame.dispose();
            }
        }
    }

    class PrintTextAction
    extends TextAction {
        PrintTextAction(JTextComponent jTextComponent) {
            super("printd", jTextComponent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.jtext == null) {
                return;
            }
            Frame frame = AppFrame.this.getFrame(this.jtext);
            PrintJob printJob = frame.getToolkit().getPrintJob(frame, frame.getTitle(), null);
            this.printpages(printJob);
            printJob.end();
        }

        void printpages(PrintJob printJob) {
            boolean bl;
            Graphics graphics = printJob.getGraphics();
            Dimension dimension = printJob.getPageDimension();
            Dimension dimension2 = this.jtext.getSize();
            int n = (dimension.height - 1 + dimension2.height) / dimension.height;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl2 = bl = n > 0;
            while (bl) {
                Rectangle rectangle = graphics.getClipBounds();
                Rectangle rectangle2 = new Rectangle(rectangle);
                rectangle2.width = Math.min(rectangle2.width, dimension2.width);
                rectangle2.y = n3;
                rectangle2.x = n4;
                graphics.translate(-n4, -n3);
                this.jtext.print(graphics);
                graphics.translate(n4, n3);
                graphics.setClip(rectangle);
                PrintJob printJob2 = ((PrintGraphics)((Object)graphics)).getPrintJob();
                graphics.dispose();
                boolean bl3 = bl = ++n2 < n && (n3 += rectangle2.height) < dimension2.height;
                if (bl && printJob2 != null) {
                    graphics = printJob2.getGraphics();
                    if (graphics != null) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
        }
    }

    abstract class TextAction
    extends AbstractAction {
        JTextComponent jtext;

        TextAction(String string, JTextComponent jTextComponent) {
            super(string);
            this.jtext = jTextComponent;
        }
    }

    class QuitAction
    extends AbstractAction {
        QuitAction() {
            super("quit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    class AboutDetailsAction
    extends TextViewAction {
        AboutDetailsAction() {
            super("details");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            help help2 = new help(false, true, printStream);
            byteArrayOutputStream.reset();
            help2.extraHelp();
            this.makeHtmlUI(byteArrayOutputStream.toString(), "More about " + AppFrame.this.props.getProperty("title", "Readseq"));
        }
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                try {
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Throwable throwable) {
                    AppFrame.this.infomessage("Hyperlink error: " + throwable.toString());
                }
            }
        }
    }

    class AboutFormatAction
    extends TextViewAction {
        AboutFormatAction() {
            super("formathelp");
        }

        AboutFormatAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.showFmt(BioseqFormats.getFormatId(((AppFrame)AppFrame.this).myapp.outformat));
        }

        void showFmt(int n) {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            if (n == 0) {
                object = new help(false, true, printStream);
                ((help)object).formatHelp();
            } else {
                object = new help(false, false, printStream);
                ((help)object).formatDoc(n);
                ((help)object).formatDocEnd();
            }
            object = byteArrayOutputStream.toString();
            object = ((String)object).replace('\r', '\n');
            if (n == 0) {
                this.makeHtmlUI((String)object, "Format details ");
            } else {
                this.makeTextUI((String)object, "Format details for " + BioseqFormats.formatName(n));
            }
        }
    }

    class AboutAllFormatsAction
    extends AboutFormatAction {
        AboutAllFormatsAction() {
            super("formatallhelp");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.showFmt(0);
        }
    }

    class AboutAction
    extends TextViewAction {
        AboutAction() {
            super("about");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            help help2 = new help(printStream);
            String string = byteArrayOutputStream.toString();
            string = string.replace('\r', '\n');
            this.makeTextUI(string, "About " + AppFrame.this.props.getProperty("title", "Readseq"));
        }
    }

    abstract class TextViewAction
    extends AbstractAction {
        TextViewAction(String string) {
            super(string);
        }

        void makeHtmlUI(String string, String string2) {
            JEditorPane jEditorPane = new JEditorPane("text/html", string);
            jEditorPane.setBorder(new EmptyBorder(6, 6, 6, 6));
            jEditorPane.setBackground(Color.white);
            jEditorPane.setEditable(false);
            jEditorPane.addHyperlinkListener(new Hyperactive());
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
            if (AppFrame.this.getStyleSheet() != null) {
                hTMLEditorKit.setStyleSheet(AppFrame.this.getStyleSheet());
            }
            AppFrame.this.openActionFrame(jEditorPane, string2, "details.menubar");
        }

        void makeTextUI(String string, String string2) {
            JTextArea jTextArea = new JTextArea(string, 40, 80);
            jTextArea.setBorder(new EmptyBorder(6, 6, 6, 6));
            jTextArea.setFont(new Font("monospaced", 0, 12));
            jTextArea.setBackground(Color.white);
            jTextArea.setEditable(false);
            AppFrame.this.openActionFrame(jTextArea, string2, "details.menubar");
        }
    }

    class NamewidthAction
    extends GetvalueAction {
        NamewidthAction() {
            super("Namewidth");
            this.setval(String.valueOf(((AppFrame)AppFrame.this).myapp.pretty.namewidth));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            try {
                ((AppFrame)AppFrame.this).myapp.pretty.namewidth = Integer.parseInt(this.val);
                ((AppFrame)AppFrame.this).myapp.pretty.userset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ColtabAction
    extends GetvalueAction {
        ColtabAction() {
            super("Coltab");
            this.setval(String.valueOf(((AppFrame)AppFrame.this).myapp.pretty.spacer));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            try {
                ((AppFrame)AppFrame.this).myapp.pretty.spacer = Integer.parseInt(this.val);
                ((AppFrame)AppFrame.this).myapp.pretty.userset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class TabAction
    extends GetvalueAction {
        TabAction() {
            super("Tab");
            this.setval(String.valueOf(((AppFrame)AppFrame.this).myapp.pretty.tab));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            try {
                ((AppFrame)AppFrame.this).myapp.pretty.tab = Integer.parseInt(this.val);
                ((AppFrame)AppFrame.this).myapp.pretty.userset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class SeqwidthAction
    extends GetvalueAction {
        SeqwidthAction() {
            super("Seqwidth");
            this.setval(String.valueOf(((AppFrame)AppFrame.this).myapp.pretty.seqwidth));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            try {
                ((AppFrame)AppFrame.this).myapp.pretty.seqwidth = Integer.parseInt(this.val);
                ((AppFrame)AppFrame.this).myapp.pretty.userset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class GapcountAction
    extends CheckboxAction {
        GapcountAction() {
            super("Gapcount");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.degap);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.pretty.degap = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class MatchcAction
    extends CheckboxAction {
        MatchcAction() {
            super("Matchc");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.domatch);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.pretty.domatch = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NumbotAction
    extends CheckboxAction {
        NumbotAction() {
            super("Numbot");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.numbot);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.pretty.numbot = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NumtopAction
    extends CheckboxAction {
        NumtopAction() {
            super("Numtop");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.numtop);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.pretty.numtop = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NumrightAction
    extends CheckboxAction {
        NumrightAction() {
            super("Numright");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.numright);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.pretty.numright = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NumleftAction
    extends CheckboxAction {
        NumleftAction() {
            super("Numleft");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.numleft);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.pretty.numleft = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NametopAction
    extends CheckboxAction {
        NametopAction() {
            super("Nametop");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.nametop);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.pretty.nametop = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NamerightAction
    extends CheckboxAction {
        NamerightAction() {
            super("Nameright");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.nameright);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.pretty.nameright = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class NameleftAction
    extends CheckboxAction {
        NameleftAction() {
            super("Nameleft");
            this.setval(((AppFrame)AppFrame.this).myapp.pretty.nameleft);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.pretty.nameleft = this.val;
            ((AppFrame)AppFrame.this).myapp.pretty.userset();
        }
    }

    class ExtractRangeAction
    extends GetvalueAction {
        ExtractRangeAction() {
            super("extract");
            this.setval(((AppFrame)AppFrame.this).myapp.extractrange);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.extractrange = this.val;
        }
    }

    class SubrangeAction
    extends GetvalueAction {
        SubrangeAction() {
            super("subrange");
            this.setval(((AppFrame)AppFrame.this).myapp.featsubrange);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.featsubrange = this.val;
        }
    }

    class RemovefeatAction
    extends CheckboxAction {
        RemovefeatAction() {
            super("removefeat");
            this.putValue(AppFrame.radioGroupSuffix, "feats");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = AppFrame.this.props.getProperty("removefeatRadio", "Remove features");
            GetFeaturelist getFeaturelist = new GetFeaturelist(AppFrame.this, "Remove features", string);
            getFeaturelist.setValue(((AppFrame)AppFrame.this).myapp.nofeatlist);
            if (getFeaturelist.choose()) {
                ((AppFrame)AppFrame.this).myapp.nofeatlist = getFeaturelist.getValue();
                AppFrame.this.infomessage("Removed features: " + ((AppFrame)AppFrame.this).myapp.nofeatlist);
            } else {
                this.setValue(actionEvent, false);
            }
        }
    }

    class ChoosefeatAction
    extends CheckboxAction {
        ChoosefeatAction() {
            super("choosefeat");
            this.putValue(AppFrame.radioGroupSuffix, "feats");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = AppFrame.this.props.getProperty("choosefeatRadio", "Select features");
            GetFeaturelist getFeaturelist = new GetFeaturelist(AppFrame.this, "Select features", string);
            getFeaturelist.setValue(((AppFrame)AppFrame.this).myapp.featlist);
            if (getFeaturelist.choose()) {
                ((AppFrame)AppFrame.this).myapp.featlist = getFeaturelist.getValue();
                AppFrame.this.infomessage("Selected features: " + ((AppFrame)AppFrame.this).myapp.featlist);
            } else {
                this.setValue(actionEvent, false);
            }
        }
    }

    class AllfeatAction
    extends CheckboxAction {
        AllfeatAction() {
            super("allfeat");
            this.putValue(AppFrame.radioGroupSuffix, "feats");
            this.setval(!AppFrame.this.myapp.hasFeatlist() && !AppFrame.this.myapp.hasNofeatlist());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            if (this.val) {
                ((AppFrame)AppFrame.this).myapp.featlist = null;
                ((AppFrame)AppFrame.this).myapp.nofeatlist = null;
            }
        }
    }

    class XmlDtdAction
    extends CheckboxAction {
        XmlDtdAction() {
            super("xmldtd");
            this.setval(XmlSeqWriter.includeDTD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            XmlSeqWriter.includeDTD = this.val;
        }
    }

    class VerboseAction
    extends CheckboxAction {
        VerboseAction() {
            super("verbose");
            this.setval(((AppFrame)AppFrame.this).myapp.verbose);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.verbose = this.val;
        }
    }

    class TranslateAction
    extends GetvalueAction {
        TranslateAction() {
            super("trans");
            this.setval("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            AppFrame.this.myapp.setTranslation(this.val, false);
        }
    }

    class ReverseAction
    extends CheckboxAction {
        ReverseAction() {
            super("reverse");
            this.setval(((AppFrame)AppFrame.this).myapp.doreverse);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.doreverse = this.val;
        }
    }

    class ChecksumAction
    extends CheckboxAction {
        ChecksumAction() {
            super("checksum");
            this.setval(((AppFrame)AppFrame.this).myapp.dochecksum);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.dochecksum = this.val;
        }
    }

    class DegapAction
    extends CheckboxAction {
        DegapAction() {
            super("degap");
            this.setval(((AppFrame)AppFrame.this).myapp.degap);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.degap = this.val;
        }
    }

    class NcAction
    extends CheckboxAction {
        NcAction() {
            super("nc");
            this.putValue(AppFrame.radioGroupSuffix, "case");
            this.setval(!((AppFrame)AppFrame.this).myapp.dolowercase && !((AppFrame)AppFrame.this).myapp.douppercase);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            if (this.val) {
                ((AppFrame)AppFrame.this).myapp.dolowercase = false;
                ((AppFrame)AppFrame.this).myapp.douppercase = false;
            }
        }
    }

    class UcAction
    extends CheckboxAction {
        UcAction() {
            super("uc");
            this.putValue(AppFrame.radioGroupSuffix, "case");
            this.setval(((AppFrame)AppFrame.this).myapp.douppercase);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.douppercase = this.val;
        }
    }

    class LcAction
    extends CheckboxAction {
        LcAction() {
            super("lc");
            this.putValue(AppFrame.radioGroupSuffix, "case");
            this.setval(((AppFrame)AppFrame.this).myapp.dolowercase);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.dolowercase = this.val;
        }
    }

    class ListAction
    extends CheckboxAction {
        ListAction() {
            super("list");
            this.setval(((AppFrame)AppFrame.this).myapp.dolist);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            ((AppFrame)AppFrame.this).myapp.dolist = this.val;
        }
    }

    class GetvalueAction
    extends AbstractAction {
        String val;
        String message;

        GetvalueAction(String string) {
            super(string);
            this.message = AppFrame.this.props.getProperty(string + AppFrame.labelSuffix, "Select a value");
        }

        void setval(String string) {
            this.val = string;
            if (string != null) {
                this.putValue("StringValue", string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "Get value";
            Object[] objectArray = null;
            String string2 = this.val;
            Object object = JOptionPane.showInputDialog(AppFrame.this, this.message, string, 3, null, objectArray, string2);
            if (object instanceof String) {
                this.firePropertyChange("StringValue", this.val, (String)object);
                this.val = (String)object;
            }
        }
    }

    class CheckboxAction
    extends AbstractAction {
        boolean val;

        CheckboxAction(String string) {
            super(string);
            this.val = true;
        }

        void setval(boolean bl) {
            this.val = bl;
            this.putValue("BoolValue", new Boolean(bl));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                this.val = jCheckBoxMenuItem.isSelected();
            } else if (actionEvent.getSource() instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
                this.val = jRadioButtonMenuItem.isSelected();
            }
        }

        public void setValue(ActionEvent actionEvent, boolean bl) {
            if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                jCheckBoxMenuItem.setSelected(bl);
                this.val = bl;
            } else if (actionEvent.getSource() instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
                jRadioButtonMenuItem.setSelected(bl);
                this.val = bl;
            }
        }
    }

    class InformatAction
    extends AbstractAction {
        InformatAction() {
            super("informat");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
            } else if (actionEvent.getSource() instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                AppFrame.this.infomessage("Selected in format=" + string);
                ((AppFrame)AppFrame.this).myapp.informat = string;
            }
        }
    }

    class OutformatAction
    extends AbstractAction {
        OutformatAction() {
            super("outformat");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                AppFrame.this.infomessage("Selected out format=" + string);
                ((AppFrame)AppFrame.this).myapp.outformat = string;
            }
        }
    }
}

