/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.OpenString;
import iubio.bioseq.BaseKind;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqRange;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.DocItem;
import iubio.readseq.OutBiobase;
import iubio.readseq.OutBiobaseIntf;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.WriteseqOpts;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class BioseqWriter
implements BioseqWriterIface {
    public static boolean gJavaChecksum = true;
    public static boolean gShortChecksum = false;
    public static Checksum summer;
    public static String kNocountsymbols;
    protected Writer outs;
    protected Writer douts;
    protected String lineSeparator;
    protected int formatId;
    protected int seqlen;
    protected int offset;
    protected int nseq;
    protected int atseq;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected Bioseq bioseq;
    protected Object seqdoc;
    protected Hashtable exfeatures;
    protected SeqRange featSubrange;
    protected static final int kSpaceAll = -9;
    private static final int kMaxseqwidth = 2048;
    protected WriteseqOpts opts = new WriteseqOpts();
    protected int l1 = 0;
    protected int linesout = 0;
    protected String nocountsymbols;
    protected long checksum = 0L;
    public static long checksumTotal;
    protected int fBasePart = 0;
    protected boolean dochecksum;
    protected boolean doReverse;
    protected static final int kUseTester = 1;
    protected static final int kAnyChar = 2;
    protected static final int kAlphaChar = 3;
    protected OutBiobaseIntf testbase = new OutBiobase(null);
    protected int testbaseKind = 3;
    protected int err;
    public static long checksumTime;

    public boolean getChecksum() {
        return this.dochecksum;
    }

    public void setChecksum(boolean bl) {
        this.dochecksum = bl;
    }

    public boolean getReverseComplement() {
        return this.doReverse;
    }

    public void setReverseComplement(boolean bl) {
        this.doReverse = bl;
    }

    public BioseqWriter() {
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void setOpts(WriteseqOpts writeseqOpts) {
        if (writeseqOpts != null) {
            this.opts = writeseqOpts;
        }
    }

    public WriteseqOpts getOpts() {
        return this.opts;
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int n) {
        this.formatId = n;
    }

    public Writer getOutput() {
        return this.outs;
    }

    public final void setOutput(OutputStream outputStream) {
        this.setOutput(new OutputStreamWriter(outputStream));
    }

    public void setOutput(Writer writer) {
        this.outs = writer;
        this.douts = writer;
        this.err = 0;
    }

    public void close() throws IOException {
        this.outs.close();
    }

    public void setOutputTranslation(OutBiobaseIntf outBiobaseIntf) {
        this.testbase = outBiobaseIntf;
        this.testbaseKind = outBiobaseIntf == null ? 3 : 1;
    }

    public OutBiobaseIntf getOutputTranslation() {
        if (this.testbaseKind == 1) {
            return this.testbase;
        }
        return null;
    }

    protected int seqLen() {
        return this.seqlen;
    }

    protected int getNseq() {
        return this.nseq;
    }

    public void setNseq(int n) {
        this.nseq = n;
    }

    public void writeHeader() throws IOException {
        if (this.douts == null) {
            throw new FileNotFoundException();
        }
        checksumTotal = 0L;
        this.nseq = 0;
    }

    public void writeTrailer() {
        try {
            this.douts.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeDoc() {
    }

    public void writeSeq() {
        this.writeLoop();
    }

    public void writeSeqEnd() {
    }

    public void writeRecordEnd() {
        this.writeln();
    }

    public void writeRecordStart() {
        ++this.atseq;
        ++this.nseq;
        this.linesout = 0;
        this.l1 = 0;
        this.checksum = 0L;
        this.opts.numwidth = Fmt.fmt(this.seqlen).length() + 1;
    }

    public void writeSeqRecord() throws IOException {
        this.writeRecordStart();
        this.writePostInit();
        this.writeDoc();
        this.writeSeq();
        this.writeRecordEnd();
    }

    public void setFeatureExtraction(Hashtable hashtable) {
        this.exfeatures = hashtable;
    }

    public void setFeatureSubrange(SeqRange seqRange) {
        this.featSubrange = seqRange;
    }

    public boolean wantsDocument() {
        if (this.exfeatures != null) {
            return true;
        }
        BioseqFormat bioseqFormat = BioseqFormats.bioseqFormat(this.formatID());
        return bioseqFormat.hasdoc();
    }

    public boolean setMask(SeqFileInfo seqFileInfo, String string) {
        int n = 0;
        if (seqFileInfo.ismask) {
            n = 0;
        } else if (seqFileInfo.hasmask) {
            n = 3;
        } else {
            return false;
        }
        string = seqFileInfo.seqid.toString() + string;
        return this.setSeq(seqFileInfo.seq, seqFileInfo.offset, seqFileInfo.seqlen, string, seqFileInfo.seqdoc, seqFileInfo.atseq, n);
    }

    public boolean setSeq(SeqFileInfo seqFileInfo) {
        if (seqFileInfo.ismask) {
            return false;
        }
        return this.setSeq(seqFileInfo.seq, seqFileInfo.offset, seqFileInfo.seqlen, seqFileInfo.seqid, seqFileInfo.seqdoc, seqFileInfo.atseq, 0);
    }

    public boolean setSeq(Object object, int n, int n2, String string, Object object2, int n3, int n4) {
        if ((n2 < 1 || object == null) && object2 != null) {
            object = new byte[]{78};
            n2 = 1;
        }
        this.seqlen = n2;
        if (n2 > 0 && object != null) {
            if (object instanceof Bioseq) {
                this.bioseq = (Bioseq)object;
            } else if (object instanceof byte[]) {
                this.bioseq = new Bioseq();
                this.bioseq.setbases((byte[])object);
            }
            this.atseq = n3;
            this.offset = n;
            this.seqdoc = object2;
            this.setSeqName(string);
            this.setSeqPart(n4);
            if (this.exfeatures != null && object2 instanceof BioseqDocImpl) {
                BioseqDocImpl bioseqDocImpl = (BioseqDocImpl)object2;
                bioseqDocImpl.setWantedFeatures(this.exfeatures);
                SeqRange seqRange = bioseqDocImpl.getFeatureRanges(n, this.seqlen);
                if (this.featSubrange != null && !this.featSubrange.isEmpty()) {
                    seqRange = seqRange.subrange(this.featSubrange);
                }
                if (this.extractBases(seqRange)) {
                    bioseqDocImpl.replaceDocItem(112, new DocItem("length", String.valueOf(this.seqlen), 112, 1));
                }
            } else if (this.doReverse) {
                this.bioseq.reverseComplement(n, this.seqlen);
                if (object2 instanceof BioseqDocImpl) {
                    BioseqDocImpl bioseqDocImpl = (BioseqDocImpl)object2;
                    bioseqDocImpl.addComment("NOTE:  This is reverse-complement of original sequence.");
                }
            }
        }
        return this.seqlen > 0;
    }

    protected boolean extractBases(SeqRange seqRange) {
        if (seqRange == null) {
            return false;
        }
        int n = 0;
        boolean bl = seqRange.isComplement();
        int n2 = seqRange.start();
        int n3 = seqRange.max();
        int n4 = n3 - n2 + 1;
        for (SeqRange seqRange2 = seqRange; seqRange2 != null; seqRange2 = seqRange2.next()) {
            if (seqRange2.isRemote()) continue;
            n += seqRange2.nbases();
        }
        if (n > 0) {
            int n5 = 0;
            byte[] byArray = new byte[n];
            byte[] byArray2 = null;
            if (this.bioseq.isBytes()) {
                n2 = 0;
                byArray2 = this.bioseq.toBytes();
            } else {
                byArray2 = this.bioseq.toBytes(n2, n4, 0);
            }
            int n6 = this.bioseq.getSeqtype();
            boolean bl2 = n6 == 4;
            boolean bl3 = n6 == 2;
            for (SeqRange seqRange3 = seqRange; seqRange3 != null; seqRange3 = seqRange3.next()) {
                String string;
                if (seqRange3.isRemote()) continue;
                int n7 = seqRange3.start();
                int n8 = seqRange3.nbases();
                boolean bl4 = bl ? bl : seqRange3.isComplement();
                if ((string = (n7 -= n2) < 0 ? String.valueOf(n7) + " start<0" : (n7 + n8 > this.seqlen ? String.valueOf(n7 + n8) + " end>" + String.valueOf(this.seqlen) : (n5 + n8 > n ? String.valueOf(n5 + n8) + "  size>" + String.valueOf(n) : null))) != null) {
                    String string2 = this.idword + " seq range error: " + string + " for " + seqRange3;
                    System.err.println(string2);
                    return false;
                }
                if (bl4) {
                    int n9;
                    int n10 = n - n5 - 1;
                    if (bl2) {
                        for (n9 = 0; n9 < n8; ++n9) {
                            byArray[n10 - n9] = byArray2[n7 + n9];
                        }
                    } else {
                        for (n9 = 0; n9 < n8; ++n9) {
                            byArray[n10 - n9] = BaseKind.nucleicComplement(byArray2[n7 + n9], bl3);
                        }
                    }
                } else {
                    System.arraycopy(byArray2, n7, byArray, n5, n8);
                }
                n5 += n8;
            }
            this.bioseq.setbases(byArray);
        }
        this.seqlen = n;
        return true;
    }

    public void setSeqName(String string) {
        int n;
        if (string == null) {
            return;
        }
        if (string.equals(SeqFileInfo.gBlankSeqid)) {
            string = SeqFileInfo.getNextBlankID();
        }
        this.seqid = string;
        this.seqid = this.seqid.trim();
        if (this.seqid.indexOf("checksum") > 0 && (n = this.seqid.indexOf("bases")) > 0) {
            while (n > 0 && this.seqid.charAt(n) != ',') {
                --n;
            }
            if (n > 0) {
                this.seqid = this.seqid.substring(0, n);
            }
        }
        if ((n = this.seqid.indexOf(32)) <= 0) {
            this.idword = this.seqid;
        } else {
            if (n > 30) {
                n = 30;
            }
            this.idword = this.seqid.substring(0, n);
        }
    }

    public void setSeqPart(int n) {
        this.fBasePart = n;
    }

    protected void writePostInit() {
        if (this.dochecksum && this.checksum == 0L) {
            this.checksum = this.calculateChecksum();
        }
        this.nocountsymbols = kNocountsymbols;
        if (this.opts.baseonlynum) {
            if (this.nocountsymbols.indexOf(this.opts.gapchar) < 0) {
                this.nocountsymbols = this.nocountsymbols + String.valueOf(this.opts.gapchar);
            }
            if (this.opts.domatch && this.nocountsymbols.indexOf(this.opts.matchchar) > 0) {
                this.nocountsymbols = this.nocountsymbols.replace(this.opts.matchchar, ' ');
            }
        }
    }

    protected void writeLoop() {
        int n = this.opts.spacer;
        if (n > 0) {
            ++n;
        }
        int n2 = this.offset + this.seqlen;
        if (this.bioseq != null) {
            n2 = Math.min(n2, this.bioseq.length());
        }
        int n3 = this.seqlen;
        if (this.opts.numline > 0 && n3 == 0) {
            n3 = this.opts.seqwidth;
        }
        this.opts.seqwidth = Math.min(this.opts.seqwidth, 2048);
        char[] cArray = new char[2048];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n3) {
            int n7;
            if (this.l1 < 0) {
                this.l1 = 0;
            } else if (this.l1 == 0) {
                if (this.opts.nameleft) {
                    if (this.opts.numline > 0) {
                        this.writeString(Fmt.fmt("", this.opts.namewidth, 0));
                    } else {
                        this.writeString(Fmt.fmt(this.idword, this.opts.namewidth, this.opts.nameflags));
                    }
                }
                if (this.opts.numleft) {
                    if (this.opts.nameleft) {
                        this.writeByte(32);
                    }
                    if (this.opts.numline > 0) {
                        this.writeString(Fmt.fmt("", this.opts.numwidth, 0));
                    } else {
                        this.writeString(Fmt.fmt(n6 + this.opts.origin, this.opts.numwidth, this.opts.numflags));
                    }
                }
                for (int i = 0; i < this.opts.tab; ++i) {
                    this.writeByte(32);
                }
            }
            ++this.l1;
            if (this.opts.numline > 0) {
                if (n == -9 || n != 0 && (n5 + 1) % n == 1) {
                    if (this.opts.numline == 1) {
                        this.writeByte(32);
                    }
                    cArray[n5++] = 32;
                }
                if (this.l1 % 10 == 1 || this.l1 == this.opts.seqwidth) {
                    if (this.opts.numline == 1) {
                        this.writeString(Fmt.fmt(this.offset + n4 + 1, 10, 2));
                    }
                    cArray[n5++] = 124;
                } else {
                    cArray[n5++] = 32;
                }
                ++n4;
            } else {
                if (n == -9 || n != 0 && (n5 + 1) % n == 1) {
                    cArray[n5++] = 32;
                }
                n7 = this.offset + n4 >= n2 ? BaseKind.indelEdge : this.bioseq.base(this.offset + n4, this.fBasePart);
                ++n4;
                if (this.testbaseKind == 1) {
                    n7 = (char)this.testbase.outSeqChar(n7);
                }
                if (n7 > 0) {
                    cArray[n5++] = n7;
                    if (!this.opts.baseonlynum) {
                        ++n6;
                    } else if (this.nocountsymbols.indexOf(n7) < 0) {
                        ++n6;
                    }
                }
            }
            if (this.l1 != this.opts.seqwidth && n4 != n3) continue;
            if (this.opts.blankpad) {
                while (this.l1 < this.opts.seqwidth) {
                    if (n == -9 || n != 0 && (n5 + 1) % n == 1) {
                        cArray[n5++] = 32;
                    }
                    cArray[n5++] = 32;
                    ++this.l1;
                }
            }
            n7 = n5;
            n5 = 0;
            this.l1 = 0;
            if (this.opts.numline > 0) {
                if (this.opts.numline == 2) {
                    this.writeByteArray(cArray, 0, n7);
                }
            } else {
                this.writeByteArray(cArray, 0, n7);
                if (this.opts.numright || this.opts.nameright) {
                    this.writeByte(32);
                }
                if (this.opts.numright) {
                    this.writeString(Fmt.fmt(n6 + this.opts.origin - 1, this.opts.numwidth, 0));
                    if (this.opts.nameright) {
                        this.writeByte(32);
                    }
                }
                if (this.opts.nameright) {
                    this.writeString(Fmt.fmt(this.idword, this.opts.namewidth, 2));
                }
                if (n4 == n3) {
                    this.writeSeqEnd();
                }
            }
            this.writeln();
        }
    }

    public int getError() {
        return this.err;
    }

    protected void writeString(String string) {
        try {
            this.douts.write(string);
        }
        catch (IOException iOException) {
            ++this.err;
        }
    }

    protected void writeString(OpenString openString) {
        try {
            this.douts.write(openString.toString());
        }
        catch (IOException iOException) {
            ++this.err;
        }
    }

    protected void writeByteArray(char[] cArray, int n, int n2) {
        try {
            this.douts.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            ++this.err;
        }
    }

    protected void writeByte(int n) {
        try {
            this.douts.write(n);
        }
        catch (IOException iOException) {
            ++this.err;
        }
    }

    protected void writeln() {
        this.writeString(this.lineSeparator);
        ++this.linesout;
    }

    protected final void writeln(String string) {
        this.writeString(string);
        this.writeln();
    }

    protected final void writeln(OpenString openString) {
        this.writeString(openString);
        this.writeln();
    }

    protected long calculateChecksum() {
        if (gJavaChecksum && summer == null) {
            summer = new Adler32();
        }
        return BioseqWriter.calculateChecksum(this.bioseq, this.offset, this.seqlen, summer);
    }

    protected String checksumString() {
        if (this.checksum == 0L) {
            return "";
        }
        return new String(Fmt.fmt(this.checksum, 0, 4).toUpperCase() + " checksum");
    }

    public static long calculateChecksum(Bioseq bioseq, int n, int n2, Checksum checksum) {
        long l = System.currentTimeMillis();
        long l2 = gJavaChecksum ? BioseqWriter.ZipChecksum(bioseq, n, n2, checksum) : (gShortChecksum ? BioseqWriter.GCGchecksum(bioseq, n, n2) : BioseqWriter.CRC32checksum(bioseq, n, n2));
        checksumTime += System.currentTimeMillis() - l;
        return l2;
    }

    public static long ZipChecksum(Bioseq bioseq, int n, int n2, Checksum checksum) {
        byte[] byArray = bioseq.toBytes(n, n2, 0);
        if (checksum == null) {
            checksum = new Adler32();
        }
        checksum.reset();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 97 && by <= 122) {
                by = (byte)(by - 32);
            }
            checksum.update(by);
        }
        long l = checksum.getValue();
        checksumTotal += l;
        return l;
    }

    public static long CRC32checksum(Bioseq bioseq, int n, int n2) {
        long l = 0xFFFFFFFFL;
        if (bioseq.isBytes()) {
            byte[] byArray = bioseq.toBytes();
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[i + n];
                if (by >= 97 && by <= 122) {
                    by = (byte)(by - 32);
                }
                l = BaseKind.crctab[((int)l ^ by) & 0xFF] ^ l >> 8;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byte by = bioseq.basebyte(n + i);
                if (by >= 97 && by <= 122) {
                    by = (byte)(by - 32);
                }
                l = BaseKind.crctab[((int)l ^ by) & 0xFF] ^ l >> 8;
            }
        }
        checksumTotal += (l ^= 0xFFFFFFFFL);
        return l;
    }

    public static long GCGchecksum(Bioseq bioseq, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (bioseq.isBytes()) {
            byte[] byArray = bioseq.toBytes();
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[i + n];
                if (by >= 97 && by <= 122) {
                    by = (byte)(by - 32);
                }
                n3 += ++n4 * by;
                if (n4 != 57) continue;
                n4 = 0;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byte by = bioseq.basebyte(n + i);
                if (by >= 97 && by <= 122) {
                    by = (byte)(by - 32);
                }
                n3 += ++n4 * by;
                if (n4 != 57) continue;
                n4 = 0;
            }
        }
        checksumTotal += (long)(n3 %= 10000);
        checksumTotal %= 10000L;
        return n3;
    }

    static {
        kNocountsymbols = "_.-?";
    }
}

