/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.GcgSeqReader;
import iubio.readseq.GcgSeqWriter;

public class GcgSeqFormat
extends BioseqFormat {
    public String formatName() {
        return "GCG";
    }

    public String formatSuffix() {
        return ".gcg";
    }

    public String contentType() {
        return "biosequence/gcg";
    }

    public BioseqReaderIface newReader() {
        return new GcgSeqReader();
    }

    public BioseqWriterIface newWriter() {
        return new GcgSeqWriter();
    }

    public BioseqWriterIface newWriter(int n) {
        if (n > 1) {
            return BioseqFormats.newWriter(BioseqFormats.formatFromContentType("biosequence/msf"), n);
        }
        return new GcgSeqWriter();
    }

    public boolean canread() {
        return true;
    }

    public boolean canwrite() {
        return true;
    }

    public boolean formatTestLine(OpenString openString, int n, int n2) {
        if (openString.startsWith("!!")) {
            if (openString.indexOf("MULTIPLE_ALIGNMENT") >= 0) {
                this.formatLikelihood = 0;
                return false;
            }
            if (openString.startsWith("!!NA") || openString.startsWith("!!AA")) {
                this.formatLikelihood += 92;
                return true;
            }
            if (openString.startsWith("!!RICH_SEQUENCE")) {
                this.formatLikelihood += 92;
                return true;
            }
            this.formatLikelihood += 50;
            return false;
        }
        if (openString.indexOf("..") > 0 && openString.indexOf("Check:") > 0) {
            this.formatLikelihood += 80;
            return false;
        }
        return false;
    }
}

