/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Environ;
import flybase.FastVector;
import flybase.Utils;
import java.awt.Font;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

class GetUrls {
    static String title = "Open sequence URLs";
    static String message = "Enter URL(s) of sequence data, one per line";
    static String footer = "URL template (above non-URL values will insert in %% of template)";
    static String sUrlInsert = "%%";
    Object[] messagepack;
    JFrame frame;
    JTextArea jlist;
    JTextField jurltempl;

    GetUrls(JFrame jFrame) {
        this.frame = jFrame;
        this.makeUi();
    }

    FastVector getValue() {
        String string = this.jlist.getText();
        String[] stringArray = Utils.splitString(string, "\r\n, ");
        String string2 = this.jurltempl.getText().trim();
        if (string2.length() > 0) {
            String string3;
            String string4;
            int n = string2.indexOf(sUrlInsert);
            if (n < 0) {
                string4 = string2;
                string3 = "";
            } else {
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + sUrlInsert.length());
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf("://") >= 0) continue;
                stringArray[i] = string4 + stringArray[i] + string3;
            }
        }
        FastVector fastVector = new FastVector(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                fastVector.addElement(new URL(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fastVector;
    }

    public boolean choose() {
        int n = JOptionPane.showConfirmDialog(this.frame, this.messagepack, title, 2, 3);
        return n == 0;
    }

    void makeUi() {
        this.jlist = new JTextArea(7, 40);
        this.jlist.setLineWrap(false);
        this.jlist.setEditable(true);
        String string = Environ.gEnv.get("SEQ_URL_TEMPLATE");
        this.jurltempl = new JTextField(string, 40);
        JScrollPane jScrollPane = new JScrollPane(this.jlist);
        JLabel jLabel = new JLabel(footer, 0);
        jLabel.setFont(new Font("sanserif", 0, 10));
        jLabel.setEnabled(true);
        jLabel.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        this.messagepack = new Object[]{message, jScrollPane, this.jurltempl, jLabel};
    }
}

