/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;

class PearsonSeqWriter
extends BioseqWriter {
    static final int seqwidth = 60;

    PearsonSeqWriter() {
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.seqwidth = 60;
    }

    public void writeRecordEnd() {
    }

    public void writeSeq() {
        int n = 0;
        boolean bl = true;
        if (this.bioseq.isBytes() && this.testbaseKind != 1) {
            byte[] byArray = this.bioseq.toBytes();
            for (int i = 0; i < this.seqlen; ++i) {
                this.writeByte((char)byArray[this.offset + i]);
                bl = false;
                if (i % 60 != 59) continue;
                this.writeln();
                bl = true;
            }
        } else {
            for (int i = 0; i < this.seqlen; ++i) {
                char c = this.bioseq.base(this.offset + i, this.fBasePart);
                if (this.testbaseKind == 1) {
                    c = (char)this.testbase.outSeqChar(c);
                }
                if (c <= '\u0000') continue;
                this.writeByte(c);
                bl = false;
                if ((++n - 1) % 60 != 59) continue;
                this.writeln();
                bl = true;
            }
        }
        if (!bl) {
            this.writeln();
        }
    }

    public void writeDoc() {
        String string;
        this.writeString(">");
        this.writeString(this.seqid);
        if (this.seqdoc instanceof BioseqDoc && (string = ((BioseqDoc)this.seqdoc).getTitle()) != null) {
            string = string.replace('\n', ' ').replace('\r', ' ');
            this.writeString(" ");
            this.writeString(string);
        }
        this.writeString(" ");
        this.writeString(String.valueOf(this.seqlen));
        this.writeString(" bp ");
        this.writeln(this.checksumString());
    }
}

