/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.OpenString;
import iubio.readseq.InterleavedSeqReader;
import iubio.readseq.NumSppBases;
import iubio.readseq.PhylipSeqFormat;
import java.io.IOException;

class PhylipSeqReader
extends InterleavedSeqReader {
    static final int kNameWidth = 10;
    protected int nospp = 0;
    protected int baselen = 0;
    protected boolean interleaved;

    public PhylipSeqReader() {
        this.margin = 0;
        this.addfirst = false;
        this.addend = false;
        this.ungetend = true;
        this.interleaved = true;
    }

    public boolean endOfSequence() {
        return true;
    }

    protected void read() throws IOException {
        this.readInterleaved();
    }

    public final int speciesCount() {
        return this.nospp;
    }

    public final int sequenceLength() {
        return this.baselen;
    }

    protected void readInterleaved() throws IOException {
        boolean bl;
        Object object;
        boolean bl2 = true;
        int n = 0;
        boolean bl3 = this.addit = this.choice > 0;
        if (this.addit) {
            this.seqlencount = 0;
            this.seqlen = 0;
        }
        if (this.sequenceLength() == 0 || this.speciesCount() == 0) {
            object = PhylipSeqFormat.readSpeciesLength(this.sWaiting);
            this.nospp = ((NumSppBases)object).nospp;
            this.baselen = ((NumSppBases)object).baselen;
            Debug.println("format: phylip-interleaved, nspp=" + this.speciesCount() + ", nbase=" + this.sequenceLength());
        }
        this.setNseq(this.speciesCount());
        do {
            this.getline();
            bl = this.endOfFile();
            if (bl && this.nWaiting == 0) break;
            object = this.sWaiting.trim();
            if (((OpenString)object).length() <= 0) continue;
            if (bl2) {
                ++this.atseq;
                if (this.atseq >= this.speciesCount()) {
                    bl2 = false;
                }
                if (this.choice == -1) {
                    this.addinfo(this.sWaiting.substring(0, 10).trim().toString());
                } else if (this.atseq == this.choice) {
                    this.addseq(this.getreadchars(), this.getreadcharofs() + 10, this.nWaiting - 10);
                    this.seqid = this.sWaiting.substring(0, 10).trim().toString();
                }
            } else if (n % this.atseq == this.choice - 1) {
                this.addseq(this.getreadchars(), this.getreadcharofs() + 10, this.nWaiting - 10);
            }
            ++n;
        } while (!bl);
        this.allDone = true;
    }
}

