/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class XmlPrintWriter
extends PrintWriter {
    public int kLinewidth = 80;
    public static boolean compatableXmlChars = false;
    protected int atline;
    protected int atcol;
    protected boolean doTrimValue = true;
    protected boolean newline = true;
    protected boolean needindent = true;
    protected boolean headerdone;
    protected boolean noendeol;
    private char lastc;

    public XmlPrintWriter(Writer writer) {
        super(writer);
    }

    public XmlPrintWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public XmlPrintWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public XmlPrintWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public boolean atNewline() {
        return this.newline;
    }

    public int linesWritten() {
        return this.atline;
    }

    public int atColumn() {
        return this.atcol;
    }

    public void setTrimValue(boolean bl) {
        this.doTrimValue = bl;
    }

    public void tab(int n) {
        this.atcol += n;
        while (n > 0) {
            super.write(32);
            --n;
        }
    }

    protected void endline() {
        ++this.atline;
        this.atcol = 0;
        this.newline = true;
        this.needindent = true;
    }

    public void println() {
        super.println();
        this.endline();
    }

    public void println(boolean bl) {
        super.println(bl);
        this.endline();
    }

    public void println(char c) {
        super.println(c);
        this.endline();
    }

    public void println(int n) {
        super.println(n);
        this.endline();
    }

    public void println(long l) {
        super.println(l);
        this.endline();
    }

    public void println(float f) {
        super.println(f);
        this.endline();
    }

    public void println(double d) {
        super.println(d);
        this.endline();
    }

    public void println(char[] cArray) {
        super.println(cArray);
        this.endline();
    }

    public void println(String string) {
        super.println(string);
        this.endline();
    }

    public void println(Object object) {
        super.println(object);
        this.endline();
    }

    public void header() {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.headerdone = true;
    }

    public final void writeTag(String string, String string2, int n) {
        this.writeTagStart(string, string2, n);
        this.writeEndElement(string, this.needindent, n);
    }

    public final void writeTag(String string, String string2, String string3, int n) {
        this.writeTagStart(string, string2, string3, n);
        this.writeEndElement(string, this.needindent, n);
    }

    public void writeTagStart(String string, String string2, int n) {
        if (string2 == null || string2.length() + this.atcol + string.length() + 2 < this.kLinewidth) {
            this.writeStartElement(string, false, n);
            this.writeValue(string2);
        } else {
            this.writeStartElement(string, false, n);
            int n2 = 2 * n + string.length() + 2;
            while (string2 != null) {
                string2 = this.writeWrapText(string2, n2, this.kLinewidth);
                n2 = 0;
            }
        }
    }

    public void writeTagStart(String string, String string2, String string3, int n) {
        if (string3 == null || string3.length() + this.atcol + string.length() + 2 < this.kLinewidth) {
            this.writeStartElement(string, string2, false, n);
            this.writeValue(string3);
        } else {
            this.writeStartElement(string, string2, false, n);
            int n2 = 2 * n + string.length() + 2;
            while (string3 != null) {
                string3 = this.writeWrapText(string3, n2, this.kLinewidth);
                n2 = 0;
            }
        }
    }

    public String trimValue(String string) {
        char c;
        char c2;
        int n;
        if (this.doTrimValue && (n = (string = string.trim()).length()) > 1 && (c2 = string.charAt(0)) == (c = string.charAt(n - 1)) && (c2 == '\"' || c2 == '\'')) {
            string = string.substring(1, n - 1);
            n -= 2;
        }
        return string;
    }

    public void writeValue(String string) {
        if (string == null) {
            return;
        }
        string = this.trimValue(string);
        this.writeCharacters(string, 0, string.length());
    }

    public String writeWrapText(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        string = this.trimValue(string);
        String string2 = null;
        int n3 = string.length();
        int n4 = n2 - n;
        int n5 = n4 + 2;
        int n6 = string.indexOf(10);
        if (n6 < 0) {
            n6 = string.indexOf(13);
        }
        if (n6 >= 0 && n6 <= n5) {
            if (n6 < n3) {
                string2 = string.substring(n6 + 1).trim();
            }
            string = string.substring(0, n6);
        } else if (n3 > n4) {
            n6 = string.lastIndexOf(32, n5);
            if (n6 < 0 && (n6 = string.lastIndexOf(44, n5)) > 0) {
                ++n6;
            }
            if (n6 < 0 && (n6 = string.lastIndexOf(59, n5)) > 0) {
                ++n6;
            }
            if (n6 < 0 && (n6 = string.lastIndexOf(46, n5)) > 0) {
                ++n6;
            }
            if (n6 < 0) {
                n6 = n4;
            }
            if (n6 > 10) {
                string2 = string.substring(n6).trim();
                string = string.substring(0, n6);
            }
        }
        this.writeCharacters(string, 0, string.length());
        if (string2 != null) {
            this.println();
        }
        return string2;
    }

    public void writeEmptyElement(String string, int n) {
        this.tab(2 * n);
        super.print('<');
        super.print(string);
        super.print("/>");
        this.atcol += 3 + string.length();
        this.println();
    }

    public final void writeStartElement(String string, int n) {
        this.writeStartElement(string, true, n);
    }

    public final void writeStartElement(String string, String string2, int n) {
        this.writeStartElement(string, string2, true, n);
    }

    public void writeStartElement(String string, boolean bl, int n) {
        this.tab(2 * n);
        super.print('<');
        super.print(string);
        super.print('>');
        this.atcol += 2 + string.length();
        if (bl) {
            this.println();
        }
    }

    public void writeStartElement(String string, String string2, boolean bl, int n) {
        this.tab(2 * n);
        super.print('<');
        super.print(string);
        if (string2 != "" && string2 != null) {
            super.print(" xlink:type='simple'");
            super.print(" xlink:href='");
            super.print(string2);
            super.print('\'');
        }
        super.print('>');
        this.atcol += 2 + string.length();
        if (bl) {
            this.println();
        }
    }

    public void printAttributes(Object object) {
    }

    public final void writeEndElement(String string, int n) {
        this.writeEndElement(string, this.needindent, n);
    }

    public void skipNextEndElementNewline() {
        this.noendeol = true;
    }

    public void writeEndElement(String string, boolean bl, int n) {
        if (bl) {
            this.tab(2 * n);
        }
        super.print("</");
        super.print(string);
        super.print('>');
        if (!this.noendeol) {
            this.println();
        }
        this.noendeol = false;
    }

    public void commentStart() {
        this.print("<!-- ");
    }

    public void commentEnd() {
        this.println(" -->");
    }

    public void writeCharacters(char[] cArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.printEncoded(cArray[i]);
        }
    }

    public void writeCharacters(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.printEncoded((char)byArray[i]);
        }
    }

    public void writeCharacters(String string, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.printEncoded(string.charAt(i));
        }
    }

    public void printEncoded(char c) {
        this.newline = false;
        this.needindent = false;
        ++this.atcol;
        switch (c) {
            case '&': {
                super.write("&amp;");
                break;
            }
            case '<': {
                super.write("&lt;");
                break;
            }
            case '>': {
                super.write("&gt;");
                break;
            }
            case '\"': {
                super.write("&quot;");
                break;
            }
            case '\t': {
                if (compatableXmlChars) {
                    super.write("&#9;");
                    break;
                }
                super.write(c);
                break;
            }
            case '\n': {
                if (compatableXmlChars) {
                    super.write("&#10;");
                    break;
                }
                if (this.lastc == '\r') break;
                this.println();
                break;
            }
            case '\r': {
                if (compatableXmlChars) {
                    super.write("&#12;");
                    break;
                }
                if (this.lastc == '\n') break;
                this.println();
                break;
            }
            default: {
                super.write(c);
            }
        }
        this.lastc = c;
    }
}

