/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.XmlSeqReader;
import iubio.readseq.XmlSeqWriter;

public class XmlSeqFormat
extends BioseqFormat {
    public static String tag1 = "<Bioseq";
    private static boolean hasXmlParser;
    public static String saxParserClass;
    private static String[] saxlParserClasses;

    public String formatName() {
        return "XML";
    }

    public String formatSuffix() {
        return ".xml";
    }

    public String contentType() {
        return "biosequence/xml";
    }

    public boolean canread() {
        return hasXmlParser;
    }

    public boolean canwrite() {
        return true;
    }

    public boolean hasdoc() {
        return true;
    }

    public BioseqReaderIface newReader() {
        return new XmlSeqReader();
    }

    public BioseqWriterIface newWriter() {
        return new XmlSeqWriter();
    }

    public static void locateXmlParser() {
        if (System.getProperty("TOBA") != null) {
            saxParserClass = System.getProperty("org.xml.sax.parser", saxlParserClasses[0]);
            hasXmlParser = true;
        } else {
            for (int i = 0; !hasXmlParser && i < saxlParserClasses.length; ++i) {
                try {
                    Class<?> clazz;
                    String string = saxlParserClasses[i];
                    if (i == 0) {
                        string = System.getProperty("org.xml.sax.parser", string);
                    }
                    if ((clazz = Class.forName(string)) == null) continue;
                    saxParserClass = string;
                    hasXmlParser = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean formatTestLine(OpenString openString, int n, int n2) {
        if (openString.indexOf(tag1) >= 0) {
            this.formatLikelihood += 90;
            return true;
        }
        if (openString.indexOf("<?xml") >= 0) {
            this.formatLikelihood = 40;
            return false;
        }
        return false;
    }

    static {
        saxlParserClasses = new String[]{"com.ibm.xml.parsers.SAXParser", "com.sun.xml.parser.Parser", "com.microstar.xml.SAXDriver"};
        XmlSeqFormat.locateXmlParser();
    }
}

