/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Args;
import flybase.Debug;
import flybase.Environ;
import flybase.FastVector;
import flybase.Utils;
import iubio.bioseq.SeqRange;
import iubio.bioseq.SeqRangeException;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqReader;
import iubio.readseq.BioseqRecord;
import iubio.readseq.BioseqWriter;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.CompareSeqWriter;
import iubio.readseq.OutBiobaseIntf;
import iubio.readseq.PlainSeqWriter;
import iubio.readseq.PrettySeqWriter;
import iubio.readseq.Readseq;
import iubio.readseq.ReadseqException;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.ToDegappedBase;
import iubio.readseq.ToLowercaseBase;
import iubio.readseq.ToTranslatedBase;
import iubio.readseq.ToUppercaseBase;
import iubio.readseq.WriteseqOpts;
import iubio.readseq.XmlSeqWriter;
import iubio.readseq.help;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;

public class run
implements Runnable {
    public static String kReadseqcHelp = "rez/Readseqc-help.html";
    static String kInputStringKey = "indata=";
    static boolean dowritemask = false;
    static boolean s_reportmemory = false;
    static Runtime s_rt = Runtime.getRuntime();
    boolean degap;
    boolean dolist;
    boolean docompare;
    boolean doall;
    boolean dochecksum;
    boolean dopipe;
    boolean dolowercase;
    boolean dohtml;
    boolean hasoutformat;
    boolean dotranslate;
    boolean douppercase;
    boolean doreverse;
    boolean doPairedDocNSeq;
    boolean doUnpairDocNSeq;
    boolean dotime;
    boolean doclassic;
    boolean verbose;
    boolean verboseClassic;
    boolean doformhelp;
    char degapc = (char)45;
    String informat;
    String outname;
    String outdirname;
    String indirname;
    String itemlist;
    String outformat;
    String featsubrange;
    String extractrange;
    String translates;
    String featlist;
    String nofeatlist;
    String keepfeatures;
    Args argv;
    FastVector innames = new FastVector();
    Hashtable exfeatures = new Hashtable();
    SeqRange featSubrange;
    SeqRange extractRange;
    WriteseqOpts pretty = new WriteseqOpts();
    File outdir;
    File indir;
    static boolean bExtractRangeOkay = true;

    public static void main(String[] stringArray) {
        new run(stringArray);
    }

    public run() {
        this.initrun();
    }

    public run(String[] stringArray) {
        this.initrun();
        System.err.println(Readseq.version);
        this.getargs(stringArray);
        if (Debug.isOn) {
            this.verbose = true;
            this.dotime = true;
            s_reportmemory = true;
            bExtractRangeOkay = true;
        }
        if (s_reportmemory) {
            run.reportMemory("Free/total memory at start:", s_rt);
        }
        long l = System.currentTimeMillis();
        this.run();
        if (this.verbose || this.dotime || s_reportmemory) {
            long l2 = System.currentTimeMillis() - l;
            System.err.println("time=" + l2);
            if (Debug.isOn) {
                System.err.println("checksum time=" + BioseqWriter.checksumTime);
            }
            if (s_reportmemory) {
                run.reportMemory("Free/total memory after processing:", s_rt);
                s_rt.gc();
                s_rt.runFinalization();
                s_rt.gc();
                run.reportMemory("Free/total memory after gc:", s_rt);
            }
        }
    }

    protected void initrun() {
        this.doformhelp = false;
        this.verbose = false;
        this.doclassic = false;
        this.dotime = false;
        this.doUnpairDocNSeq = false;
        this.doPairedDocNSeq = false;
        this.doreverse = false;
        this.douppercase = false;
        this.dotranslate = false;
        this.hasoutformat = false;
        this.dohtml = false;
        this.dolowercase = false;
        this.dopipe = false;
        this.dochecksum = false;
        this.doall = false;
        this.docompare = false;
        this.dolist = false;
        this.degap = false;
        this.featlist = null;
        this.nofeatlist = null;
        this.keepfeatures = null;
        this.featsubrange = null;
        this.extractrange = null;
        this.translates = null;
        this.itemlist = null;
        this.indirname = null;
        this.outdirname = null;
        this.outname = null;
        this.informat = null;
        this.outformat = null;
        this.innames.removeAllElements();
        this.doclassic = true;
        XmlSeqWriter.dtdUrl = Environ.gEnv.get("APP_SOURCE_URL");
        XmlSeqWriter.includeDTD = Environ.gEnv.isTrue("XML_INCLUDE_DTD");
        String string = Readseq.version;
        int n = string.indexOf("version ");
        if (n >= 0) {
            string = string.substring(n + "version ".length()).trim();
        }
        Environ.gEnv.set("APP_VERSION", string);
        this.outformat = Environ.gEnv.get("format", "biosequence/fasta");
        this.doall = Environ.gEnv.isTrue("all", this.doall);
        this.dochecksum = Environ.gEnv.isTrue("checksum", this.dochecksum);
        this.doreverse = Environ.gEnv.isTrue("reverse", this.doreverse);
        s_reportmemory = Environ.gEnv.isTrue("memory", s_reportmemory);
        this.dotime = Environ.gEnv.isTrue("time", this.dotime);
        this.doclassic = Environ.gEnv.isTrue("classic", this.doclassic);
        this.dolowercase = Environ.gEnv.isTrue("caselower", this.dolowercase);
        this.douppercase = Environ.gEnv.isTrue("CASEUPPPER", this.douppercase);
        this.degap = Environ.gEnv.isTrue("degap", this.degap);
        this.dolist = Environ.gEnv.isTrue("list", this.dolist);
        this.dopipe = Environ.gEnv.isTrue("pipe", this.dopipe);
        this.verbose = Environ.gEnv.isTrue("verbose", this.verbose);
        this.doPairedDocNSeq = Environ.gEnv.isTrue("pair-feature-seq", this.doPairedDocNSeq);
        this.doUnpairDocNSeq = Environ.gEnv.isTrue("unpair-feature-seq", this.doUnpairDocNSeq);
        this.doformhelp = Environ.gEnv.isTrue("formhelp", this.doformhelp);
        this.featlist = Environ.gEnv.get("features", this.featlist);
        this.nofeatlist = Environ.gEnv.get("nofeatures", this.nofeatlist);
        this.keepfeatures = Environ.gEnv.get("keepfeatures", this.keepfeatures);
        this.featsubrange = Environ.gEnv.get("subrange", this.featsubrange);
        this.extractrange = Environ.gEnv.get("extract", this.extractrange);
        this.pretty.seqwidth = Environ.gEnv.getInt("pretty.width", this.pretty.seqwidth);
        this.pretty.tab = Environ.gEnv.getInt("pretty.tab", this.pretty.tab);
        this.pretty.spacer = Environ.gEnv.getInt("pretty.colspace", this.pretty.spacer);
        this.pretty.baseonlynum = !Environ.gEnv.isTrue("pretty.gapcount", !this.pretty.baseonlynum);
        this.pretty.nameleft = Environ.gEnv.isTrue("pretty.nameleft", this.pretty.nameleft);
        this.pretty.nameright = Environ.gEnv.isTrue("pretty.nameright", this.pretty.nameright);
        this.pretty.nametop = Environ.gEnv.isTrue("pretty.nametop", this.pretty.nametop);
        this.pretty.namewidth = Environ.gEnv.getInt("pretty.namewidth", this.pretty.namewidth);
        this.pretty.numleft = Environ.gEnv.isTrue("pretty.numleft", this.pretty.numleft);
        this.pretty.numright = Environ.gEnv.isTrue("pretty.numright", this.pretty.numright);
        this.pretty.numtop = Environ.gEnv.isTrue("pretty.numtop", this.pretty.numtop);
        this.pretty.numbot = Environ.gEnv.isTrue("pretty.numbot", this.pretty.numbot);
        this.pretty.domatch = Environ.gEnv.isTrue("pretty.match", this.pretty.domatch);
        this.pretty.interline = Environ.gEnv.getInt("pretty.interline", this.pretty.interline);
    }

    public void setInputFiles(File[] fileArray) {
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.innames.addElement(fileArray[i]);
            }
        }
    }

    public void setInputNames(String[] stringArray) {
        this.innames.removeAllElements();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.innames.addElement(stringArray[i].trim());
            }
        }
    }

    public void setInputObjects(FastVector fastVector) {
        this.innames.removeAllElements();
        if (fastVector != null) {
            for (int i = 0; i < fastVector.size(); ++i) {
                this.innames.addElement(fastVector.elementAt(i));
            }
        }
    }

    public void addInputObject(Object object) {
        if (object != null) {
            this.innames.addElement(object);
        }
    }

    public boolean haveInputData() {
        return !this.innames.isEmpty();
    }

    protected void message(String string) {
        BioseqReader.message(string);
    }

    protected String guessOutname(int n) {
        String string = null;
        for (int i = 0; string == null && i < this.innames.size(); ++i) {
            Object object = this.innames.elementAt(i);
            if (object instanceof File) {
                string = ((File)object).toString();
                continue;
            }
            if (object instanceof URL) {
                string = ((URL)object).getFile();
                continue;
            }
            if (!(object instanceof String)) continue;
            string = (String)object;
            if (string.startsWith(kInputStringKey)) {
                string = null;
                continue;
            }
            if (string.length() <= 50) continue;
        }
        if (string == null) {
            string = "run-output";
        }
        string = this.docompare ? string + ".diff" : (this.dolist ? string + ".list" : string + BioseqFormats.formatSuffix(n));
        return string;
    }

    protected void comparePair(String string, Readseq readseq, Object object, int n, Writer writer) throws IOException {
        Readseq readseq2 = new Readseq();
        readseq2.setInDirectory(this.indir);
        String string2 = readseq2.setInputObjectChecked(object);
        if (this.verbose || this.dotime) {
            this.message("Comparing to " + string2);
        }
        if (string2 == null) {
            return;
        }
        if (n > 0) {
            readseq2.setInputFormat(n);
        }
        if (!readseq2.isKnownFormat()) {
            this.message("Unknown biosequence format for input " + string2);
            return;
        }
        if (n > 0) {
            readseq2.getBioseqFormat().setVariant(this.informat);
        }
        if (!readseq2.readInit()) {
            this.message("Error initializing readseq for input " + string2);
            return;
        }
        CompareSeqWriter compareSeqWriter = new CompareSeqWriter();
        compareSeqWriter.setOutput(writer);
        compareSeqWriter.setSourceNames(string2, string);
        compareSeqWriter.writeHeader();
        boolean bl = true;
        int n2 = 1;
        while (bl) {
            SeqFileInfo seqFileInfo = readseq.readAt(n2);
            SeqFileInfo seqFileInfo2 = readseq2.readAt(n2);
            if (seqFileInfo == null || seqFileInfo2 == null) {
                bl = false;
                if (seqFileInfo2 != null) {
                    compareSeqWriter.writeln("End of file for " + string);
                }
                if (seqFileInfo != null) {
                    compareSeqWriter.writeln("End of file for " + string2);
                }
            } else {
                compareSeqWriter.compareTo(new BioseqRecord(seqFileInfo));
                if (compareSeqWriter.setSeq(seqFileInfo2)) {
                    compareSeqWriter.writeSeqRecord();
                }
            }
            ++n2;
        }
        compareSeqWriter.writeTrailer();
        compareSeqWriter.close();
    }

    public void run() {
        Object object;
        File file;
        SeqFileInfo.gWriteMask = dowritemask;
        if (this.doclassic && this.verbose) {
            this.verboseClassic = true;
            this.verbose = false;
        } else {
            this.verboseClassic = false;
        }
        BioseqReader.verbose = this.verbose;
        boolean bl = this.dohtml = this.outname != null && this.outname.indexOf("html") >= 0;
        if (this.doformhelp) {
            try {
                PrintStream printStream = this.outname == null ? System.out : new PrintStream(new FileOutputStream(this.outname));
                help help2 = new help(false, this.dohtml, printStream);
                if (this.outformat == null || !this.hasoutformat) {
                    help2.formatHelp();
                } else {
                    help2.formatDoc(BioseqFormats.getFormatId(this.outformat));
                    help2.formatDocEnd();
                }
                printStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (!this.haveInputData() && !this.dopipe) {
            run.usage();
            return;
        }
        if (this.outformat == null) {
            this.outformat = Environ.gEnv.get("format", "biosequence/fasta");
        }
        int n = BioseqFormats.getFormatId(this.outformat);
        if (this.outdirname != null && (file = new File(this.outdirname)).isDirectory()) {
            this.outdir = file;
        }
        if (this.indirname != null && (file = new File(this.indirname)).isDirectory()) {
            this.indir = file;
        }
        int n2 = 0;
        if (this.informat != null) {
            n2 = BioseqFormats.getFormatId(this.informat);
        }
        if (this.innames.isEmpty() && this.dopipe) {
            this.addInputObject(System.in);
        }
        if (!this.dopipe && this.outname == null && this.haveInputData()) {
            this.outname = this.guessOutname(n);
        }
        this.featSubrange = null;
        this.extractRange = null;
        if (bExtractRangeOkay) {
            if (this.extractrange != null) {
                try {
                    object = SeqRange.parse(this.extractrange);
                    if (object != null && !((SeqRange)object).isEmpty()) {
                        this.extractRange = object;
                    }
                    Debug.println("parse extractrange=" + this.extractrange + ", extractRange=" + this.extractRange);
                }
                catch (SeqRangeException seqRangeException) {
                    this.extractRange = null;
                }
            }
            if (this.featsubrange != null) {
                try {
                    object = SeqRange.parse(this.featsubrange);
                    if (object != null && !((SeqRange)object).isEmpty()) {
                        this.featSubrange = object;
                    }
                    Debug.println("parse featsubrange=" + this.featsubrange + ", featSubrange=" + this.featSubrange);
                }
                catch (SeqRangeException seqRangeException) {
                    this.featSubrange = null;
                }
            }
        }
        if (this.verbose || this.dotime) {
            this.message(this.getClass().getName() + " -- starting ");
            this.message("Writing to " + (this.outname == null ? "Std. output" : this.outname));
        }
        try {
            Object object2;
            object = null;
            BufferedWriter bufferedWriter = null;
            BioseqWriterIface bioseqWriterIface = null;
            BioseqWriterIface bioseqWriterIface2 = null;
            boolean bl2 = false;
            Object object3 = null;
            SeqFileInfo seqFileInfo = null;
            String string = null;
            int n3 = 0;
            boolean bl3 = false;
            Readseq readseq = new Readseq();
            readseq.verboseClassic = this.verboseClassic;
            if (this.outname == null) {
                object = new OutputStreamWriter(System.out);
            } else {
                URL uRL = readseq.checkUrl(this.outname);
                if (uRL != null) {
                    object2 = uRL.openConnection();
                    object = new OutputStreamWriter(((URLConnection)object2).getOutputStream());
                } else {
                    object = this.outdir != null ? new BufferedWriter(new FileWriter(new File(this.outdir, this.outname))) : new BufferedWriter(new FileWriter(this.outname));
                }
            }
            if (!this.dolist && !this.docompare) {
                bioseqWriterIface = BioseqFormats.newWriter(n);
                if (bioseqWriterIface == null) {
                    throw new ReadseqException("No BioseqWriter for this format: " + this.outformat);
                }
                this.setWriterOptions(bioseqWriterIface);
                bioseqWriterIface.setOutput((Writer)object);
                bioseqWriterIface.writeHeader();
                bl2 = true;
            }
            object2 = this.getItems(this.itemlist);
            readseq.setInDirectory(this.indir);
            readseq.checkInList(this.innames, kInputStringKey);
            Enumeration enumeration = this.innames.elements();
            while (enumeration.hasMoreElements()) {
                Object object4;
                Object object5;
                BioseqFormat bioseqFormat;
                String string2 = readseq.setInputObjectChecked(enumeration.nextElement());
                if (string2 == null) continue;
                if (this.verbose || this.dotime) {
                    this.message("Reading from " + string2);
                }
                if (n2 > 0) {
                    readseq.setInputFormat(n2);
                }
                if (!readseq.isKnownFormat()) {
                    this.message("Unknown biosequence format for input " + string2);
                    continue;
                }
                if (n2 > 0) {
                    bioseqFormat = readseq.getBioseqFormat();
                    bioseqFormat.setVariant(this.informat);
                }
                if (!this.exfeatures.isEmpty() || this.featSubrange != null) {
                    readseq.setFeatureExtraction(this.exfeatures, this.featSubrange);
                }
                if (!readseq.readInit()) {
                    this.message("Error initializing readseq for input " + string2);
                    continue;
                }
                if (this.dolist) {
                    readseq.list((Writer)object);
                    continue;
                }
                if (this.docompare) {
                    this.comparePair(string2, readseq, enumeration.nextElement(), n2, (Writer)object);
                    continue;
                }
                if (this.doPairedDocNSeq) {
                    bioseqFormat = readseq.getBioseqFormat();
                    Debug.println("Pair: informat " + bioseqFormat.formatName());
                    if (bioseqFormat.hasdoc() && !bioseqFormat.hasseq()) {
                        object5 = readseq.readAt(1);
                        object3 = ((SeqFileInfo)object5).seqdoc;
                        if (Debug.isOn) {
                            Debug.println("Pair: got doc " + string2 + " nfeat=" + ((BioseqDoc)object3).features().size());
                        }
                    } else if (bioseqFormat.hasseq()) {
                        seqFileInfo = readseq.readAt(1);
                        if (Debug.isOn) {
                            Debug.println("Pair: got seq " + string2 + " len=" + seqFileInfo.seqlen);
                        }
                    }
                    if (seqFileInfo == null || object3 == null) continue;
                    seqFileInfo.seqdoc = object3;
                    if (!bl2) {
                        bioseqWriterIface.writeHeader();
                    }
                    readseq.writeSeqTo(seqFileInfo, bioseqWriterIface, null);
                    if (!bl2) {
                        bioseqWriterIface.writeTrailer();
                    }
                    seqFileInfo = null;
                    object3 = null;
                    continue;
                }
                if (this.doUnpairDocNSeq) {
                    boolean bl4 = false;
                    object5 = readseq.getBioseqFormat();
                    object4 = BioseqFormats.bioseqFormat(n);
                    if (((BioseqFormat)object5).hasseq() && ((BioseqFormat)object5).hasdoc() && (!((BioseqFormat)object4).hasseq() || !((BioseqFormat)object4).hasdoc()) && this.outname != null) {
                        if (bioseqWriterIface2 == null) {
                            if (((BioseqFormat)object4).hasseq()) {
                                n3 = BioseqFormats.formatFromName("FFF");
                                bl3 = true;
                            } else {
                                n3 = BioseqFormats.formatFromName("fasta");
                                bl3 = false;
                            }
                            string = this.outname + BioseqFormats.formatSuffix(n3);
                            bufferedWriter = this.outdir != null ? new BufferedWriter(new FileWriter(new File(this.outdir, string))) : new BufferedWriter(new FileWriter(string));
                            bioseqWriterIface2 = BioseqFormats.newWriter(n3);
                            if (bioseqWriterIface2 != null) {
                                this.setWriterOptions(bioseqWriterIface2);
                                bioseqWriterIface2.setOutput(bufferedWriter);
                                bioseqWriterIface2.writeHeader();
                            }
                        }
                        bl4 = bl3 ? readseq.readToPair(bioseqWriterIface, bioseqWriterIface2, !bl2) : readseq.readToPair(bioseqWriterIface2, bioseqWriterIface, !bl2);
                    }
                    if (bl4) continue;
                    readseq.readTo(bioseqWriterIface, !bl2);
                    continue;
                }
                if (object2 != null) {
                    for (int i = 0; i < ((FastVector)object2).size(); ++i) {
                        int n4 = (Integer)((FastVector)object2).elementAt(i);
                        object4 = readseq.readAt(n4);
                        readseq.writeSeqTo((SeqFileInfo)object4, bioseqWriterIface, null);
                    }
                    continue;
                }
                readseq.readTo(bioseqWriterIface, !bl2);
            }
            try {
                if (bioseqWriterIface != null) {
                    if (bl2) {
                        bioseqWriterIface.writeTrailer();
                    }
                    bioseqWriterIface.close();
                }
                if (bioseqWriterIface2 != null) {
                    if (bl2) {
                        bioseqWriterIface2.writeTrailer();
                    }
                    bioseqWriterIface2.close();
                }
                if (object != null) {
                    ((Writer)object).close();
                }
                if (bufferedWriter != null) {
                    ((Writer)object).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            readseq.close();
        }
        catch (ReadseqException readseqException) {
            if (this.verbose) {
                readseqException.printStackTrace();
            } else {
                System.err.println(readseqException.getMessage());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.verbose || this.dotime) {
            this.message(this.getClass().getName() + " -- done ");
        }
    }

    protected FastVector getItems(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        FastVector fastVector = new FastVector();
        int n = string.length();
        boolean bl = false;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3;
            char c = string.charAt(i);
            if (c == '-') {
                bl = true;
                continue;
            }
            if (c == '.' && i < n - 1 && string.charAt(i + 1) == '.') {
                ++i;
                bl = true;
                continue;
            }
            if (c < '0' || c > '9') continue;
            for (n3 = i; n3 < n && Character.isDigit(string.charAt(n3)); ++n3) {
            }
            if (n3 > i) {
                try {
                    Integer n4 = new Integer(string.substring(i, n3));
                    if (bl) {
                        int n5 = n4 - 1;
                        for (int j = n2 + 1; j < n5; ++j) {
                            fastVector.addElement(new Integer(j));
                        }
                        bl = false;
                    }
                    fastVector.addElement(n4);
                    n2 = n4;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            i = n3 - 1;
        }
        if (fastVector.isEmpty()) {
            return null;
        }
        return fastVector;
    }

    protected void setWriterOptions(BioseqWriterIface bioseqWriterIface) {
        String[] stringArray;
        OutBiobaseIntf outBiobaseIntf = bioseqWriterIface.getOutputTranslation();
        if (this.degap) {
            outBiobaseIntf = new ToDegappedBase(this.degapc, outBiobaseIntf);
        }
        if (this.dolowercase) {
            outBiobaseIntf = new ToLowercaseBase(outBiobaseIntf);
        } else if (this.douppercase) {
            outBiobaseIntf = new ToUppercaseBase(outBiobaseIntf);
        }
        if (this.dotranslate && this.translates != null && this.translates.length() > 0) {
            stringArray = new StringBuffer();
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.translates;
            if (string.length() > 1) {
                int n = string.length();
                char c = '\u0000';
                for (int i = 0; i < n; ++i) {
                    char c2 = string.charAt(i);
                    if (c2 <= ' ' || c2 == ',' || c2 == ':') continue;
                    if (c == '\u0000') {
                        c = c2;
                        continue;
                    }
                    stringArray.append(c);
                    stringBuffer.append(c2);
                    c = '\u0000';
                }
            }
            outBiobaseIntf = new ToTranslatedBase(stringArray.toString(), stringBuffer.toString(), outBiobaseIntf);
        }
        if (outBiobaseIntf != null) {
            bioseqWriterIface.setOutputTranslation(outBiobaseIntf);
        }
        this.exfeatures.clear();
        if (this.hasFeatlist()) {
            stringArray = Utils.splitString(this.featlist, ", ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.exfeatures.put(stringArray[i], "true");
            }
        }
        if (this.hasNofeatlist()) {
            stringArray = Utils.splitString(this.nofeatlist, ", ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.exfeatures.put(stringArray[i], "false");
            }
        }
        if (bioseqWriterIface instanceof BioseqWriter) {
            ((BioseqWriter)bioseqWriterIface).setChecksum(this.dochecksum);
            ((BioseqWriter)bioseqWriterIface).setReverseComplement(this.doreverse);
        }
        if (bioseqWriterIface instanceof PrettySeqWriter) {
            ((PrettySeqWriter)bioseqWriterIface).setOpts(this.pretty);
        } else if (bioseqWriterIface instanceof PlainSeqWriter) {
            ((PlainSeqWriter)bioseqWriterIface).setOpts(this.pretty);
        }
    }

    final boolean hasFeatlist() {
        return this.featlist != null && this.featlist.length() > 0;
    }

    final boolean hasNofeatlist() {
        return this.nofeatlist != null && this.nofeatlist.length() > 0;
    }

    public void getargs(String[] stringArray) {
        this.argv = new Args(stringArray);
        this.getargs();
    }

    public void getargs() {
        if (this.doclassic) {
            this.argv.setArgPattern("acCdi:lo:prt:vf:", false);
        }
        this.pretty.prettyInit();
        this.pretty.userset();
        while (this.argv.hasMoreElements()) {
            this.argv.nextArg();
            this.getOneArg();
        }
    }

    protected void handleUnknownArg() {
        this.message("Unknown argument: " + this.argv.argKey() + "=" + this.argv.argValue());
    }

    protected void getOneArg() {
        boolean bl;
        String string = this.argv.arg();
        String string2 = this.argv.argKey();
        String string3 = this.argv.argValue();
        boolean bl2 = this.argv.hasValue();
        boolean bl3 = bl = this.argv.isBoolean() ? this.argv.booleanValue() : true;
        if (!string2.startsWith("C")) {
            string2 = string2.toLowerCase();
        }
        if ("help".equals(string2) || "h".equals(string2)) {
            run.usage();
        } else if (this.argv.argType() == 0) {
            this.addInputObject(string);
        } else if (string2.startsWith("ch")) {
            this.dochecksum = bl;
        } else if (string2.startsWith("inform")) {
            this.informat = string3;
        } else if (string2.startsWith("in")) {
            if (bl2) {
                this.addInputObject(string3);
            }
        } else if (string2.startsWith("memory")) {
            s_reportmemory = bl;
        } else if (string2.startsWith("time")) {
            this.dotime = bl;
        } else if (string2.startsWith("formhelp")) {
            this.doformhelp = bl;
        } else if (string2.startsWith("classic")) {
            this.doclassic = bl;
        } else if (string2.startsWith("all")) {
            this.doall = bl;
        } else if (string2.startsWith("caselo")) {
            this.dolowercase = true;
        } else if (string2.startsWith("CASEUP") || string2.startsWith("caseup")) {
            this.douppercase = true;
        } else if (string2.startsWith("degap")) {
            this.degap = true;
            if (bl2) {
                this.degapc = string3.charAt(0);
            }
        } else if (string2.startsWith("format")) {
            this.hasoutformat = true;
            if (bl2) {
                this.outformat = string3;
            }
        } else if (string2.startsWith("item")) {
            this.itemlist = string3;
        } else if (string2.startsWith("list")) {
            this.dolist = bl;
        } else if (string2.startsWith("compare")) {
            this.docompare = bl;
        } else if (string2.equals("pair-feature-seq")) {
            this.doPairedDocNSeq = bl;
        } else if (string2.startsWith("pair")) {
            this.doPairedDocNSeq = bl;
        } else if (string2.equals("unpair-feature-seq")) {
            this.doUnpairDocNSeq = bl;
        } else if (string2.startsWith("unpair")) {
            this.doUnpairDocNSeq = bl;
        } else if (string2.startsWith("indir")) {
            this.indirname = string3;
        } else if (string2.startsWith("outdir")) {
            this.outdirname = string3;
        } else if (string2.startsWith("out")) {
            this.outname = string3;
        } else if (string2.startsWith("pipe")) {
            this.dopipe = bl;
        } else if (string2.startsWith("rev")) {
            this.doreverse = bl;
        } else if (string2.startsWith("trans")) {
            this.setTranslation(string3, true);
        } else if (string2.startsWith("verb")) {
            this.verbose = bl;
        } else if (string2.startsWith("feat") || string2.startsWith("field")) {
            if (bl2) {
                this.featlist = this.appends(this.featlist, string3);
            }
        } else if (string2.startsWith("nofeat") || string2.startsWith("nofield")) {
            if (bl2) {
                this.nofeatlist = this.appends(this.nofeatlist, string3);
            }
        } else if (string2.startsWith("keepfeature")) {
            if (bl2) {
                this.keepfeatures = this.appends(this.keepfeatures, string3);
            }
        } else if (string2.startsWith("subrange")) {
            if (bl2) {
                this.featsubrange = string3;
            }
        } else if (string2.startsWith("extract")) {
            if (bl2) {
                this.extractrange = string3;
            }
        } else if (string2.startsWith("wid")) {
            this.pretty.seqwidth = this.argv.intValue();
            this.pretty.userset();
        } else if (string2.startsWith("tab")) {
            this.pretty.tab = this.argv.intValue();
            this.pretty.userset();
        } else if (string2.startsWith("col")) {
            this.pretty.spacer = this.argv.intValue();
            this.pretty.userset();
        } else if (string2.startsWith("gap")) {
            this.pretty.baseonlynum = false;
            this.pretty.userset();
        } else if (string2.startsWith("nameleft")) {
            this.pretty.nameleft = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.namewidth = this.argv.intValue();
            }
        } else if (string2.startsWith("nameright")) {
            this.pretty.nameright = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.namewidth = this.argv.intValue();
            }
        } else if (string2.startsWith("nametop")) {
            this.pretty.nametop = true;
            this.pretty.userset();
        } else if (string2.startsWith("numleft")) {
            this.pretty.numleft = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.numwidth = this.argv.intValue();
            }
        } else if (string2.startsWith("numright")) {
            this.pretty.numright = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.numwidth = this.argv.intValue();
            }
        } else if (string2.startsWith("numtop")) {
            this.pretty.numtop = true;
            this.pretty.userset();
        } else if (string2.startsWith("numbot")) {
            this.pretty.numbot = true;
            this.pretty.userset();
        } else if (string2.startsWith("match")) {
            this.pretty.domatch = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.matchchar = string3.charAt(0);
            }
        } else if (string2.startsWith("inter")) {
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.interline = this.argv.intValue();
            }
        } else if (this.doclassic) {
            if (string2.startsWith("a")) {
                this.doall = true;
            } else if (string2.startsWith("c")) {
                this.dolowercase = true;
            } else if (string2.startsWith("C")) {
                this.douppercase = true;
            } else if (string2.startsWith("d")) {
                this.degap = true;
                if (this.argv.hasValue()) {
                    this.degapc = string3.charAt(0);
                }
            } else if (string2.startsWith("f")) {
                if (bl2) {
                    this.outformat = string3;
                }
            } else if (string2.startsWith("i")) {
                this.itemlist = string3;
            } else if (string2.startsWith("l")) {
                this.dolist = true;
            } else if (string2.startsWith("o")) {
                this.outname = string3;
            } else if (string2.startsWith("p")) {
                this.dopipe = true;
            } else if (string2.startsWith("r")) {
                this.doreverse = true;
            } else if (string2.startsWith("t")) {
                this.setTranslation(string3, true);
            } else if (string2.startsWith("v")) {
                this.verbose = true;
            }
        } else {
            this.handleUnknownArg();
        }
    }

    final String appends(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + " " + string2;
    }

    public void setTranslation(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            this.dotranslate = true;
            this.translates = bl ? this.appends(this.translates, string) : string;
        } else if (!bl) {
            this.dotranslate = false;
        }
    }

    public static void usage() {
        run.usage(System.out);
    }

    public static void usage(PrintStream printStream) {
        printStream.println();
        printStream.println("  " + Readseq.version);
        String string = AppResources.global.getData(kReadseqcHelp);
        if (string != null) {
            String string2 = System.getProperty("line.separator");
            int n = string.indexOf("<HTML");
            if (n >= 0) {
                int n2 = string.indexOf(string2);
                n2 = n2 < 0 ? 0 : ++n2;
                int n3 = string.indexOf("</HTML", n2);
                if (n3 > n2) {
                    n3 = string.lastIndexOf(string2, n3);
                }
                if (n3 < 0) {
                    n3 = string.length();
                }
                string = string.substring(n2, n3);
            }
            printStream.println(string);
        } else {
            printStream.println("  Read & reformat biosequences, command-line interface");
            printStream.println("  Usage: jre -cp readseq.jar " + run.class.getName() + " [options] input-file");
            printStream.println();
            printStream.println("  Options: [help not available]");
            printStream.println();
        }
        printStream.println("  Known biosequence formats:");
        printStream.println(BioseqFormats.getInfo(0, "space-header"));
        for (int i = 1; i <= BioseqFormats.nFormats(); ++i) {
            printStream.println(BioseqFormats.getInfo(i, "space-command-line"));
        }
        printStream.println("   (Int'leaf = interleaved format; Features = documentation/features are parsed)");
        printStream.println();
    }

    private static void reportMemory(String string, Runtime runtime) {
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        long l3 = l - l2;
        System.err.print(string);
        System.err.print('\t');
        System.err.println(l2 + "/" + l + ": use " + l3 + " bytes");
        System.err.flush();
    }
}

