/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.AxisClient;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.session.Session;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class MessageContext
implements SOAPMessageContext {
    protected static Log log = LogFactory.getLog(MessageContext.class.getName());
    private Message requestMessage;
    private Message responseMessage;
    private String targetService;
    private String transportName;
    private ClassLoader classLoader;
    private AxisEngine axisEngine;
    private Session session;
    private boolean maintainSession = false;
    private boolean havePassedPivot = false;
    private int timeout = 600000;
    private boolean highFidelity = true;
    private LockableHashtable bag = new LockableHashtable();
    private String username = null;
    private String password = null;
    private String encodingStyle = Use.ENCODED.getEncoding();
    private boolean useSOAPAction = false;
    private String SOAPActionURI = null;
    private String[] roles;
    private SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
    private SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    private OperationDesc currentOperation = null;
    protected static String systemTempDir = null;
    private TypeMappingRegistry mappingRegistry = null;
    private SOAPService serviceHandler;
    public static final String ENGINE_HANDLER = "engine.handler";
    public static final String TRANS_URL = "transport.url";
    public static final String QUIT_REQUESTED = "quit.requested";
    public static final String AUTHUSER = "authenticatedUser";
    public static final String CALL = "call_object";
    public static final String IS_MSG = "isMsg";
    public static final String ATTACHMENTS_DIR = "attachments.directory";
    public static final String ACCEPTMISSINGPARAMS = "acceptMissingParams";
    public static final String WSDLGEN_INTFNAMESPACE = "axis.wsdlgen.intfnamespace";
    public static final String WSDLGEN_SERV_LOC_URL = "axis.wsdlgen.serv.loc.url";
    public static final String HTTP_TRANSPORT_VERSION = "axis.transport.version";
    public static final String SECURITY_PROVIDER = "securityProvider";

    public OperationDesc getOperation() {
        return this.currentOperation;
    }

    public void setOperation(OperationDesc operationDesc) {
        this.currentOperation = operationDesc;
    }

    public OperationDesc[] getPossibleOperationsByQName(QName qName) throws AxisFault {
        ServiceDesc serviceDesc;
        if (this.currentOperation != null) {
            return new OperationDesc[]{this.currentOperation};
        }
        OperationDesc[] operationDescArray = null;
        if (this.serviceHandler == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("dispatching00", qName.getNamespaceURI()));
                }
                this.setService(this.axisEngine.getConfig().getServiceByNamespaceURI(qName.getNamespaceURI()));
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        if (this.serviceHandler != null && (serviceDesc = this.serviceHandler.getInitializedServiceDesc(this)) != null) {
            if (serviceDesc.getStyle() != Style.DOCUMENT) {
                operationDescArray = serviceDesc.getOperationsByQName(qName);
            } else {
                ArrayList arrayList = serviceDesc.getOperations();
                ArrayList<OperationDesc> arrayList2 = new ArrayList<OperationDesc>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    OperationDesc operationDesc = (OperationDesc)arrayList.get(i);
                    if (operationDesc.getParamByQName(qName) == null) continue;
                    arrayList2.add(operationDesc);
                }
                if (arrayList2.size() > 0) {
                    operationDescArray = (OperationDesc[])JavaUtils.convert(arrayList2, OperationDesc[].class);
                }
            }
        }
        return operationDescArray;
    }

    public OperationDesc getOperationByQName(QName qName) throws AxisFault {
        OperationDesc[] operationDescArray;
        if (this.currentOperation == null && (operationDescArray = this.getPossibleOperationsByQName(qName)) != null && operationDescArray.length > 0) {
            this.currentOperation = operationDescArray[0];
        }
        return this.currentOperation;
    }

    public static MessageContext getCurrentContext() {
        return AxisEngine.getCurrentMessageContext();
    }

    public MessageContext(AxisEngine axisEngine) {
        this.axisEngine = axisEngine;
        if (null != axisEngine) {
            String string;
            String string2;
            Hashtable hashtable = axisEngine.getOptions();
            String string3 = null;
            if (null != hashtable) {
                string3 = (String)hashtable.get("attachments.Directory");
            }
            if (null == string3) {
                string3 = systemTempDir;
            }
            if (string3 != null) {
                this.setProperty(ATTACHMENTS_DIR, string3);
            }
            if ((string2 = (String)axisEngine.getOption("defaultSOAPVersion")) != null && "1.2".equals(string2)) {
                this.setSOAPConstants(SOAPConstants.SOAP12_CONSTANTS);
            }
            if ((string = (String)axisEngine.getOption("singleSOAPVersion")) != null) {
                if ("1.2".equals(string)) {
                    this.setProperty("SingleSOAPVersion", SOAPConstants.SOAP12_CONSTANTS);
                } else if ("1.1".equals(string)) {
                    this.setProperty("SingleSOAPVersion", SOAPConstants.SOAP11_CONSTANTS);
                }
            }
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.mappingRegistry = typeMappingRegistry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.mappingRegistry == null) {
            return this.axisEngine.getTypeMappingRegistry();
        }
        return this.mappingRegistry;
    }

    public TypeMapping getTypeMapping() {
        return (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(this.encodingStyle);
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String string) {
        this.transportName = string;
    }

    public SOAPConstants getSOAPConstants() {
        return this.soapConstants;
    }

    public void setSOAPConstants(SOAPConstants sOAPConstants) {
        if (this.soapConstants.getEncodingURI().equals(this.encodingStyle)) {
            this.encodingStyle = sOAPConstants.getEncodingURI();
        }
        this.soapConstants = sOAPConstants;
    }

    public SchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(SchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isEncoded() {
        return this.getOperationUse() == Use.ENCODED;
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSession = bl;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(Message message) {
        this.requestMessage = message;
        if (this.requestMessage != null) {
            this.requestMessage.setMessageContext(this);
        }
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(Message message) {
        this.responseMessage = message;
        if (this.responseMessage != null) {
            this.responseMessage.setMessageContext(this);
            Message message2 = this.getRequestMessage();
            if (null != message2) {
                Attachments attachments = message2.getAttachmentsImpl();
                Attachments attachments2 = message.getAttachmentsImpl();
                if (null != attachments && null != attachments2 && attachments2.getSendType() == 1) {
                    attachments2.setSendType(attachments.getSendType());
                }
            }
        }
    }

    public Message getCurrentMessage() {
        return this.havePassedPivot ? this.responseMessage : this.requestMessage;
    }

    public SOAPMessage getMessage() {
        return this.getCurrentMessage();
    }

    public void setCurrentMessage(Message message) {
        message.setMessageContext(this);
        if (this.havePassedPivot) {
            this.responseMessage = message;
        } else {
            this.requestMessage = message;
        }
    }

    public void setMessage(SOAPMessage sOAPMessage) {
        this.setCurrentMessage((Message)sOAPMessage);
    }

    public boolean getPastPivot() {
        return this.havePassedPivot;
    }

    public void setPastPivot(boolean bl) {
        this.havePassedPivot = bl;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public AxisEngine getAxisEngine() {
        return this.axisEngine;
    }

    public void setTargetService(String string) throws AxisFault {
        block4: {
            log.debug("MessageContext: setTargetService(" + string + ")");
            if (string == null) {
                this.setService(null);
            } else {
                try {
                    this.setService(this.getAxisEngine().getService(string));
                }
                catch (AxisFault axisFault) {
                    if (this.isClient()) break block4;
                    throw axisFault;
                }
            }
        }
        this.targetService = string;
    }

    public SOAPService getService() {
        return this.serviceHandler;
    }

    public void setService(SOAPService sOAPService) throws AxisFault {
        log.debug("MessageContext: setServiceHandler(" + sOAPService + ")");
        this.serviceHandler = sOAPService;
        if (sOAPService != null) {
            if (!sOAPService.isRunning()) {
                throw new AxisFault(Messages.getMessage("disabled00"));
            }
            this.targetService = sOAPService.getName();
            SOAPService sOAPService2 = sOAPService;
            TypeMappingRegistry typeMappingRegistry = sOAPService2.getTypeMappingRegistry();
            this.setTypeMappingRegistry(typeMappingRegistry);
            this.setEncodingStyle(sOAPService2.getUse().getEncoding());
            this.bag.setParent(sOAPService.getOptions());
            this.highFidelity = sOAPService2.needsHighFidelityRecording();
            sOAPService2.getInitializedServiceDesc(this);
        }
    }

    public boolean isClient() {
        return this.axisEngine instanceof AxisClient;
    }

    public String getStrProp(String string) {
        return (String)this.getProperty(string);
    }

    public boolean isPropertyTrue(String string) {
        return this.isPropertyTrue(string, false);
    }

    public boolean isPropertyTrue(String string, boolean bl) {
        return JavaUtils.isTrue(this.getProperty(string), bl);
    }

    public void setProperty(String string, Object object) {
        if (string == null || object == null) {
            return;
        }
        if (string.equals("javax.xml.rpc.security.auth.username")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setUsername((String)object);
        } else if (string.equals("javax.xml.rpc.security.auth.password")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setPassword((String)object);
        } else if (string.equals("javax.xml.rpc.session.maintain")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Boolean", object.getClass().getName()}));
            }
            this.setMaintainSession((Boolean)object);
        } else if (string.equals("javax.xml.rpc.soap.http.soapaction.use")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Boolean", object.getClass().getName()}));
            }
            this.setUseSOAPAction((Boolean)object);
        } else if (string.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setSOAPActionURI((String)object);
        } else if (string.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setEncodingStyle((String)object);
        } else {
            this.bag.put(string, object);
        }
    }

    public boolean containsProperty(String string) {
        Object object = this.getProperty(string);
        return object != null;
    }

    public Iterator getPropertyNames() {
        return this.bag.keySet().iterator();
    }

    public Iterator getAllPropertyNames() {
        return this.bag.getAllKeys().iterator();
    }

    public Object getProperty(String string) {
        if (string != null) {
            if (string.equals("javax.xml.rpc.security.auth.username")) {
                return this.getUsername();
            }
            if (string.equals("javax.xml.rpc.security.auth.password")) {
                return this.getPassword();
            }
            if (string.equals("javax.xml.rpc.session.maintain")) {
                return this.getMaintainSession() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (string.equals("javax.xml.rpc.soap.operation.style")) {
                return this.getOperationStyle() == null ? null : this.getOperationStyle().getName();
            }
            if (string.equals("javax.xml.rpc.soap.http.soapaction.use")) {
                return this.useSOAPAction() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (string.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
                return this.getSOAPActionURI();
            }
            if (string.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
                return this.getEncodingStyle();
            }
            if (this.bag == null) {
                return null;
            }
            return this.bag.get(string);
        }
        return null;
    }

    public void setPropertyParent(Hashtable hashtable) {
        this.bag.setParent(hashtable);
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public Style getOperationStyle() {
        if (this.currentOperation != null) {
            return this.currentOperation.getStyle();
        }
        if (this.serviceHandler != null) {
            return this.serviceHandler.getStyle();
        }
        return Style.RPC;
    }

    public Use getOperationUse() {
        if (this.currentOperation != null) {
            return this.currentOperation.getUse();
        }
        if (this.serviceHandler != null) {
            return this.serviceHandler.getUse();
        }
        return Use.ENCODED;
    }

    public void setUseSOAPAction(boolean bl) {
        this.useSOAPAction = bl;
    }

    public boolean useSOAPAction() {
        return this.useSOAPAction;
    }

    public void setSOAPActionURI(String string) throws IllegalArgumentException {
        this.SOAPActionURI = string;
    }

    public String getSOAPActionURI() {
        return this.SOAPActionURI;
    }

    public void setEncodingStyle(String string) {
        if (string == null) {
            string = "";
        } else if (Constants.isSOAP_ENC(string)) {
            string = this.soapConstants.getEncodingURI();
        }
        this.encodingStyle = string;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void removeProperty(String string) {
        if (this.bag != null) {
            this.bag.remove(string);
        }
    }

    public void reset() {
        if (this.bag != null) {
            this.bag.clear();
        }
        this.serviceHandler = null;
        this.havePassedPivot = false;
        this.currentOperation = null;
    }

    public boolean isHighFidelity() {
        return this.highFidelity;
    }

    public void setHighFidelity(boolean bl) {
        this.highFidelity = bl;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] stringArray) {
        this.roles = stringArray;
    }

    public synchronized void dispose() {
        log.debug("disposing of message context");
        if (this.requestMessage != null) {
            this.requestMessage.dispose();
            this.requestMessage = null;
        }
        if (this.responseMessage != null) {
            this.responseMessage.dispose();
            this.responseMessage = null;
        }
    }

    static {
        try {
            systemTempDir = AxisProperties.getProperty("axis.attachments.Directory");
        }
        catch (Throwable throwable) {
            systemTempDir = null;
        }
        if (systemTempDir == null) {
            try {
                File file = File.createTempFile("Axis", ".tmp");
                File file2 = file.getParentFile();
                if (file.exists()) {
                    file.delete();
                }
                if (file2 != null) {
                    systemTempDir = file2.getCanonicalPath();
                }
            }
            catch (Throwable throwable) {
                log.debug("Unable to find a temp dir with write access");
                systemTempDir = null;
            }
        }
    }
}

