/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.Part;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.MimeHeaders;
import org.apache.axis.message.SOAPDocumentImpl;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.transport.http.SocketInputStream;
import org.apache.axis.utils.ByteArray;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.SessionUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPPart
extends javax.xml.soap.SOAPPart
implements Part {
    protected static Log log = LogFactory.getLog(SOAPPart.class.getName());
    public static final int FORM_STRING = 1;
    public static final int FORM_INPUTSTREAM = 2;
    public static final int FORM_SOAPENVELOPE = 3;
    public static final int FORM_BYTES = 4;
    public static final int FORM_BODYINSTREAM = 5;
    public static final int FORM_FAULT = 6;
    public static final int FORM_OPTIMIZED = 7;
    private int currentForm;
    public static final String ALLOW_FORM_OPTIMIZATION = "axis.form.optimization";
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private static final String[] formNames = new String[]{"", "FORM_STRING", "FORM_INPUTSTREAM", "FORM_SOAPENVELOPE", "FORM_BYTES", "FORM_BODYINSTREAM", "FORM_FAULT", "FORM_OPTIMIZED"};
    private Object currentMessage;
    private String currentEncoding = "UTF-8";
    private String currentMessageAsString = null;
    private byte[] currentMessageAsBytes = null;
    private SOAPEnvelope currentMessageAsEnvelope = null;
    private Message msgObject;
    private Source contentSource = null;
    private Document document = new SOAPDocumentImpl(this);
    protected Document mDocument;

    public SOAPPart(Message message, Object object, boolean bl) {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
        this.setMimeHeader("Content-Type", "text/xml");
        this.msgObject = message;
        int n = 1;
        if (object instanceof SOAPEnvelope) {
            n = 3;
            ((SOAPEnvelope)object).setOwnerDocument(this);
        } else if (object instanceof InputStream) {
            n = bl ? 5 : 2;
        } else if (object instanceof byte[]) {
            n = 4;
        } else if (object instanceof AxisFault) {
            n = 6;
        }
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart ctor(" + formNames[n] + ")");
        }
        this.setCurrentMessage(object, n);
        if (log.isDebugEnabled()) {
            log.debug("Exit: SOAPPart ctor()");
        }
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node node) {
        return 0;
    }

    public String getTextContent() {
        return null;
    }

    public void setTextContent(String string) {
    }

    public boolean isSameNode(Node node) {
        return false;
    }

    public String lookupPrefix(String string) {
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return true;
    }

    public String lookupNamespaceURI(String string) {
        return null;
    }

    public boolean isEqualNode(Node node) {
        return false;
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public Object getUserData(String string) {
        return null;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }

    public String getInputEncoding() {
        return null;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return true;
    }

    public void setXmlStandalone(boolean bl) {
    }

    public String getXmlVersion() {
        return "1.0";
    }

    public void setXmlVersion(String string) {
    }

    public String getDocumentURI() {
        return null;
    }

    public void setDocumentURI(String string) {
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public void normalizeDocument() {
    }

    public Node renameNode(Node node, String string, String string2) {
        return node;
    }

    public Message getMessage() {
        return this.msgObject;
    }

    public void setMessage(Message message) {
        this.msgObject = message;
    }

    public String getContentType() {
        return "text/xml";
    }

    public long getContentLength() throws AxisFault {
        this.saveChanges();
        if (this.currentForm == 7) {
            return ((ByteArray)this.currentMessage).size();
        }
        if (this.currentForm == 4) {
            return ((byte[])this.currentMessage).length;
        }
        byte[] byArray = this.getAsBytes();
        return byArray.length;
    }

    public void setSOAPEnvelope(SOAPEnvelope sOAPEnvelope) {
        this.setCurrentMessage(sOAPEnvelope, 3);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.currentForm == 4) {
            outputStream.write((byte[])this.currentMessage);
        } else if (this.currentForm == 7) {
            ((ByteArray)this.currentMessage).writeTo(outputStream);
        } else {
            Writer writer = new OutputStreamWriter(outputStream, this.currentEncoding);
            writer = new BufferedWriter(new PrintWriter(writer));
            this.writeTo(writer);
            writer.flush();
        }
    }

    public void writeTo(Writer writer) throws IOException {
        Object object;
        boolean bl = false;
        if (this.msgObject.getMessageContext() != null) {
            bl = true;
        } else {
            try {
                object = (String)this.msgObject.getProperty("javax.xml.soap.write-xml-declaration");
                if (object != null && ((String)object).equals("true")) {
                    bl = true;
                }
            }
            catch (SOAPException sOAPException) {
                throw new IOException(sOAPException.getMessage());
            }
        }
        if (this.currentForm == 6) {
            object = (AxisFault)this.currentMessage;
            try {
                SerializationContext serializationContext = new SerializationContext(writer, this.getMessage().getMessageContext());
                serializationContext.setSendDecl(bl);
                serializationContext.setEncoding(this.currentEncoding);
                ((AxisFault)object).output(serializationContext);
            }
            catch (Exception exception) {
                log.error(Messages.getMessage("exception00"), exception);
                throw object;
            }
            return;
        }
        if (this.currentForm == 3) {
            object = (SOAPEnvelope)this.currentMessage;
            try {
                SerializationContext serializationContext = new SerializationContext(writer, this.getMessage().getMessageContext());
                serializationContext.setSendDecl(bl);
                serializationContext.setEncoding(this.currentEncoding);
                ((MessageElement)object).output(serializationContext);
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            return;
        }
        object = this.getAsString();
        if (bl && !((String)object).startsWith("<?xml")) {
            writer.write("<?xml version=\"1.0\" encoding=\"");
            writer.write(this.currentEncoding);
            writer.write("\"?>");
        }
        writer.write((String)object);
    }

    public Object getCurrentMessage() {
        return this.currentMessage;
    }

    public void setCurrentMessage(Object object, int n) {
        this.currentMessageAsString = null;
        this.currentMessageAsBytes = null;
        this.currentMessageAsEnvelope = null;
        this.setCurrentForm(object, n);
    }

    private void setCurrentForm(Object object, int n) {
        if (log.isDebugEnabled()) {
            String string = object instanceof String ? (String)object : object.getClass().getName();
            log.debug(Messages.getMessage("setMsgForm", formNames[n], "" + string));
        }
        if (this.isFormOptimizationAllowed()) {
            this.currentMessage = object;
            this.currentForm = n;
            if (this.currentForm == 3) {
                this.currentMessageAsEnvelope = (SOAPEnvelope)object;
            }
        }
    }

    private boolean isFormOptimizationAllowed() {
        Boolean bl;
        MessageContext messageContext;
        boolean bl2 = true;
        Message message = this.getMessage();
        if (message != null && (messageContext = message.getMessageContext()) != null && (bl = (Boolean)messageContext.getProperty(ALLOW_FORM_OPTIMIZATION)) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public int getCurrentForm() {
        return this.currentForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAsBytes() throws AxisFault {
        log.debug("Enter: SOAPPart::getAsBytes");
        if (this.currentForm == 7) {
            log.debug("Exit: SOAPPart::getAsBytes");
            try {
                return ((ByteArray)this.currentMessage).toByteArray();
            }
            catch (IOException iOException) {
                throw AxisFault.makeFault(iOException);
            }
        }
        if (this.currentForm == 4) {
            log.debug("Exit: SOAPPart::getAsBytes");
            return (byte[])this.currentMessage;
        }
        if (this.currentForm == 5) {
            try {
                this.getAsSOAPEnvelope();
            }
            catch (Exception exception) {
                log.fatal(Messages.getMessage("makeEnvFail00"), exception);
                log.debug("Exit: SOAPPart::getAsBytes");
                return null;
            }
        }
        if (this.currentForm == 2) {
            try {
                InputStream inputStream = null;
                byte[] byArray = null;
                try {
                    int n;
                    inputStream = (InputStream)this.currentMessage;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byArray = new byte[4096];
                    while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
                finally {
                    if (inputStream != null && this.currentMessage instanceof SocketInputStream) {
                        inputStream.close();
                    }
                }
                this.setCurrentForm(byArray, 4);
                log.debug("Exit: SOAPPart::getAsBytes");
                return (byte[])this.currentMessage;
            }
            catch (Exception exception) {
                log.error(Messages.getMessage("exception00"), exception);
                log.debug("Exit: SOAPPart::getAsBytes");
                return null;
            }
        }
        if (this.currentForm == 3 || this.currentForm == 6) {
            this.currentEncoding = XMLUtils.getEncoding(this.msgObject, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            try {
                this.writeTo(bufferedOutputStream);
                bufferedOutputStream.flush();
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            this.setCurrentForm(byteArrayOutputStream.toByteArray(), 4);
            if (log.isDebugEnabled()) {
                log.debug("Exit: SOAPPart::getAsBytes(): " + this.currentMessage);
            }
            return (byte[])this.currentMessage;
        }
        if (this.currentForm == 1) {
            if (this.currentMessage == this.currentMessageAsString && this.currentMessageAsBytes != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: SOAPPart::getAsBytes()");
                }
                return this.currentMessageAsBytes;
            }
            this.currentMessageAsString = (String)this.currentMessage;
            try {
                this.currentEncoding = XMLUtils.getEncoding(this.msgObject, null);
                this.setCurrentForm(((String)this.currentMessage).getBytes(this.currentEncoding), 4);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.setCurrentForm(((String)this.currentMessage).getBytes(), 4);
            }
            this.currentMessageAsBytes = (byte[])this.currentMessage;
            log.debug("Exit: SOAPPart::getAsBytes");
            return (byte[])this.currentMessage;
        }
        log.error(Messages.getMessage("cantConvert00", "" + this.currentForm));
        log.debug("Exit: SOAPPart::getAsBytes");
        return null;
    }

    public void saveChanges() throws AxisFault {
        log.debug("Enter: SOAPPart::saveChanges");
        if (this.currentForm == 3 || this.currentForm == 6) {
            this.currentEncoding = XMLUtils.getEncoding(this.msgObject, null);
            ByteArray byteArray = new ByteArray();
            try {
                this.writeTo(byteArray);
                byteArray.flush();
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            this.setCurrentForm(byteArray, 7);
            if (log.isDebugEnabled()) {
                log.debug("Exit: SOAPPart::saveChanges(): " + this.currentMessage);
            }
        }
    }

    public String getAsString() throws AxisFault {
        log.debug("Enter: SOAPPart::getAsString");
        if (this.currentForm == 1) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: SOAPPart::getAsString(): " + this.currentMessage);
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 2 || this.currentForm == 5) {
            this.getAsBytes();
        }
        if (this.currentForm == 7) {
            try {
                this.currentMessageAsBytes = ((ByteArray)this.currentMessage).toByteArray();
            }
            catch (IOException iOException) {
                throw AxisFault.makeFault(iOException);
            }
            try {
                this.setCurrentForm(new String(this.currentMessageAsBytes, this.currentEncoding), 1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.setCurrentForm(new String(this.currentMessageAsBytes), 1);
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: SOAPPart::getAsString(): " + this.currentMessage);
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 4) {
            if (this.currentMessage == this.currentMessageAsBytes && this.currentMessageAsString != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: SOAPPart::getAsString(): " + this.currentMessageAsString);
                }
                return this.currentMessageAsString;
            }
            this.currentMessageAsBytes = (byte[])this.currentMessage;
            try {
                this.setCurrentForm(new String((byte[])this.currentMessage, this.currentEncoding), 1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.setCurrentForm(new String((byte[])this.currentMessage), 1);
            }
            this.currentMessageAsString = (String)this.currentMessage;
            if (log.isDebugEnabled()) {
                log.debug("Exit: SOAPPart::getAsString(): " + this.currentMessage);
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 6) {
            StringWriter stringWriter = new StringWriter();
            try {
                this.writeTo(stringWriter);
            }
            catch (Exception exception) {
                log.error(Messages.getMessage("exception00"), exception);
                return null;
            }
            this.setCurrentForm(stringWriter.getBuffer().toString(), 1);
            if (log.isDebugEnabled()) {
                log.debug("Exit: SOAPPart::getAsString(): " + this.currentMessage);
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 3) {
            StringWriter stringWriter = new StringWriter();
            try {
                this.writeTo(stringWriter);
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            this.setCurrentForm(stringWriter.getBuffer().toString(), 1);
            if (log.isDebugEnabled()) {
                log.debug("Exit: SOAPPart::getAsString(): " + this.currentMessage);
            }
            return (String)this.currentMessage;
        }
        log.error(Messages.getMessage("cantConvert01", "" + this.currentForm));
        log.debug("Exit: SOAPPart::getAsString()");
        return null;
    }

    public SOAPEnvelope getAsSOAPEnvelope() throws AxisFault {
        Cloneable cloneable;
        Object object;
        InputSource inputSource;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPPart::getAsSOAPEnvelope()");
            log.debug(Messages.getMessage("currForm", formNames[this.currentForm]));
        }
        if (this.currentForm == 3) {
            return (SOAPEnvelope)this.currentMessage;
        }
        if (this.currentForm == 5) {
            InputStreamBody inputStreamBody = new InputStreamBody((InputStream)this.currentMessage);
            SOAPEnvelope sOAPEnvelope = new SOAPEnvelope();
            sOAPEnvelope.setOwnerDocument(this);
            sOAPEnvelope.addBodyElement(inputStreamBody);
            this.setCurrentForm(sOAPEnvelope, 3);
            return sOAPEnvelope;
        }
        if (this.currentForm == 2) {
            inputSource = new InputSource((InputStream)this.currentMessage);
            object = XMLUtils.getEncoding(this.msgObject, null, null);
            if (object != null) {
                this.currentEncoding = object;
                inputSource.setEncoding(this.currentEncoding);
            }
        } else {
            inputSource = new InputSource(new StringReader(this.getAsString()));
        }
        object = new DeserializationContext(inputSource, this.getMessage().getMessageContext(), this.getMessage().getMessageType());
        ((DeserializationContext)object).getEnvelope().setOwnerDocument(this);
        try {
            ((DeserializationContext)object).parse();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            throw AxisFault.makeFault(exception);
        }
        SOAPEnvelope sOAPEnvelope = ((DeserializationContext)object).getEnvelope();
        if (this.currentMessageAsEnvelope != null) {
            cloneable = sOAPEnvelope.getHeaders();
            Vector vector = this.currentMessageAsEnvelope.getHeaders();
            if (null != cloneable && null != vector) {
                Iterator iterator = vector.iterator();
                Iterator iterator2 = ((Vector)cloneable).iterator();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator2.next();
                    SOAPHeaderElement sOAPHeaderElement2 = (SOAPHeaderElement)iterator.next();
                    if (!sOAPHeaderElement2.isProcessed()) continue;
                    sOAPHeaderElement.setProcessed(true);
                }
            }
        }
        this.setCurrentForm(sOAPEnvelope, 3);
        log.debug("Exit: SOAPPart::getAsSOAPEnvelope");
        cloneable = (SOAPEnvelope)this.currentMessage;
        ((SOAPEnvelope)cloneable).setOwnerDocument(this);
        return cloneable;
    }

    public void addMimeHeader(String string, String string2) {
        this.mimeHeaders.addHeader(string, string2);
    }

    private String getFirstMimeHeader(String string) {
        String[] stringArray = this.mimeHeaders.getHeader(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String string) {
        this.setMimeHeader("Content-Location", string);
    }

    public void setContentId(String string) {
        this.setMimeHeader("Content-Id", string);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getNonMatchingHeaders(stringArray);
    }

    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        MessageContext messageContext = this.getMessage().getMessageContext();
        if (messageContext != null) {
            messageContext.setProperty(ALLOW_FORM_OPTIMIZATION, Boolean.TRUE);
        }
        this.contentSource = source;
        InputSource inputSource = XMLUtils.sourceToInputSource(this.contentSource);
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            this.setCurrentMessage(inputStream, 2);
        } else {
            Reader reader = inputSource.getCharacterStream();
            if (reader == null) {
                throw new SOAPException(Messages.getMessage("noCharacterOrByteStream"));
            }
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                }
            }
            catch (IOException iOException) {
                throw new SOAPException(Messages.getMessage("couldNotReadFromCharStream"), iOException);
            }
            this.setCurrentMessage(stringBuffer.toString(), 1);
        }
    }

    public Source getContent() throws SOAPException {
        if (this.contentSource == null) {
            switch (this.currentForm) {
                case 1: {
                    String string = (String)this.currentMessage;
                    this.contentSource = new StreamSource(new StringReader(string));
                    break;
                }
                case 2: {
                    this.contentSource = new StreamSource((InputStream)this.currentMessage);
                    break;
                }
                case 3: {
                    SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)this.currentMessage;
                    try {
                        this.contentSource = new DOMSource(sOAPEnvelope.getAsDocument());
                        break;
                    }
                    catch (Exception exception) {
                        throw new SOAPException(Messages.getMessage("errorGetDocFromSOAPEnvelope"), exception);
                    }
                }
                case 7: {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArray)this.currentMessage).toByteArray());
                        this.contentSource = new StreamSource(byteArrayInputStream);
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SOAPException(Messages.getMessage("errorGetDocFromSOAPEnvelope"), iOException);
                    }
                }
                case 4: {
                    byte[] byArray = (byte[])this.currentMessage;
                    this.contentSource = new StreamSource(new ByteArrayInputStream(byArray));
                    break;
                }
                case 5: {
                    this.contentSource = new StreamSource((InputStream)this.currentMessage);
                }
            }
        }
        return this.contentSource;
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String string, String string2) {
        this.mimeHeaders.setHeader(string, string2);
    }

    public String[] getMimeHeader(String string) {
        return this.mimeHeaders.getHeader(string);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this.mimeHeaders.removeHeader(string);
    }

    public javax.xml.soap.SOAPEnvelope getEnvelope() throws SOAPException {
        try {
            return this.getAsSOAPEnvelope();
        }
        catch (AxisFault axisFault) {
            throw new SOAPException(axisFault);
        }
    }

    public Document getSOAPDocument() {
        if (this.document == null) {
            this.document = new SOAPDocumentImpl(this);
        }
        return this.document;
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Element getDocumentElement() {
        try {
            return this.getEnvelope();
        }
        catch (SOAPException sOAPException) {
            return null;
        }
    }

    public Element createElement(String string) throws DOMException {
        return this.document.createElement(string);
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public Text createTextNode(String string) {
        return this.document.createTextNode(string);
    }

    public Comment createComment(String string) {
        return this.document.createComment(string);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return this.document.createCDATASection(string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return this.document.createProcessingInstruction(string, string2);
    }

    public Attr createAttribute(String string) throws DOMException {
        return this.document.createAttribute(string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return this.document.createEntityReference(string);
    }

    public NodeList getElementsByTagName(String string) {
        return this.document.getElementsByTagName(string);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        return this.document.importNode(node, bl);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        return this.document.createElementNS(string, string2);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return this.document.createAttributeNS(string, string2);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return this.document.getElementsByTagNameNS(string, string2);
    }

    public Element getElementById(String string) {
        return this.document.getElementById(string);
    }

    public String getEncoding() {
        return this.currentEncoding;
    }

    public void setEncoding(String string) {
        this.currentEncoding = string;
    }

    public boolean getStandalone() {
        throw new UnsupportedOperationException("Not yet implemented.71");
    }

    public void setStandalone(boolean bl) {
        throw new UnsupportedOperationException("Not yet implemented.72");
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("Not yet implemented.73");
    }

    public void setStrictErrorChecking(boolean bl) {
        throw new UnsupportedOperationException("Not yet implemented. 74");
    }

    public String getVersion() {
        throw new UnsupportedOperationException("Not yet implemented. 75");
    }

    public void setVersion(String string) {
        throw new UnsupportedOperationException("Not yet implemented.76");
    }

    public Node adoptNode(Node node) throws DOMException {
        throw new UnsupportedOperationException("Not yet implemented.77");
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public void setNodeValue(String string) throws DOMException {
        this.document.setNodeValue(string);
    }

    public short getNodeType() {
        return this.document.getNodeType();
    }

    public Node getParentNode() {
        return this.document.getParentNode();
    }

    public NodeList getChildNodes() {
        return this.document.getChildNodes();
    }

    public Node getFirstChild() {
        return this.document.getFirstChild();
    }

    public Node getLastChild() {
        return this.document.getLastChild();
    }

    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    public Node getNextSibling() {
        return this.document.getNextSibling();
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.document.insertBefore(node, node2);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        return this.document.replaceChild(node, node2);
    }

    public Node removeChild(Node node) throws DOMException {
        return this.document.removeChild(node);
    }

    public Node appendChild(Node node) throws DOMException {
        return this.document.appendChild(node);
    }

    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    public Node cloneNode(boolean bl) {
        return this.document.cloneNode(bl);
    }

    public void normalize() {
        this.document.normalize();
    }

    public boolean isSupported(String string, String string2) {
        return this.document.isSupported(string, string2);
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public void setPrefix(String string) throws DOMException {
        this.document.setPrefix(string);
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    public boolean isBodyStream() {
        return this.currentForm == 2 || this.currentForm == 5;
    }
}

