/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.axis.components.image.ImageIOFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class ImageDataSource
implements DataSource {
    protected static Log log = LogFactory.getLog(ImageDataSource.class.getName());
    public static final String CONTENT_TYPE = "image/jpeg";
    private final String name;
    private final String contentType;
    private byte[] data;
    private ByteArrayOutputStream os;

    public ImageDataSource(String string, Image image) {
        this(string, CONTENT_TYPE, image);
    }

    public ImageDataSource(String string, String string2, Image image) {
        this.name = string;
        this.contentType = string2 == null ? CONTENT_TYPE : string2;
        this.os = new ByteArrayOutputStream();
        try {
            if (image != null) {
                ImageIOFactory.getImageIO().saveImage(this.contentType, image, this.os);
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return this.os;
    }
}

