/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.WeakHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axis.InternalException;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class ManagedMemoryDataSource
implements DataSource {
    protected static Log log = LogFactory.getLog(ManagedMemoryDataSource.class.getName());
    protected String contentType = "application/octet-stream";
    InputStream ss = null;
    public static final int MIN_MEMORY_DISK_CACHED = -1;
    public static final int MAX_MEMORY_DISK_CACHED = 16384;
    protected int maxCached = 16384;
    protected File diskCacheFile = null;
    protected WeakHashMap readers = new WeakHashMap();
    protected boolean deleted = false;
    public static final int READ_CHUNK_SZ = 32768;
    protected boolean debugEnabled = false;
    protected LinkedList memorybuflist = new LinkedList();
    protected byte[] currentMemoryBuf = null;
    protected int currentMemoryBufSz = 0;
    protected long totalsz = 0L;
    protected BufferedOutputStream cachediskstream = null;
    protected boolean closed = false;
    protected static Log is_log = LogFactory.getLog(Instream.class.getName());

    protected ManagedMemoryDataSource() {
    }

    public ManagedMemoryDataSource(InputStream inputStream, int n, String string) throws IOException {
        this(inputStream, n, string, false);
    }

    public ManagedMemoryDataSource(InputStream inputStream, int n, String string, boolean bl) throws IOException {
        this.ss = inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
        this.maxCached = n;
        if (null != string && string.length() != 0) {
            this.contentType = string;
        }
        if (n < -1) {
            throw new IllegalArgumentException(Messages.getMessage("badMaxCached", "" + n));
        }
        if (log.isDebugEnabled()) {
            this.debugEnabled = true;
        }
        if (bl) {
            byte[] byArray = new byte[32768];
            int n2 = 0;
            do {
                if ((n2 = inputStream.read(byArray)) <= 0) continue;
                this.write(byArray, n2);
            } while (n2 > -1);
            this.close();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public synchronized InputStream getInputStream() throws IOException {
        return new Instream();
    }

    public String getName() {
        String string = null;
        try {
            this.flushToDisk();
            if (this.diskCacheFile != null) {
                string = this.diskCacheFile.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            this.diskCacheFile = null;
        }
        return string;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    protected void write(byte[] byArray) throws IOException {
        this.write(byArray, byArray.length);
    }

    protected synchronized void write(byte[] byArray, int n) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        int n2 = n;
        int n3 = 0;
        if (null != this.memorybuflist && this.totalsz + (long)n2 > (long)this.maxCached && null == this.cachediskstream) {
            this.flushToDisk();
        }
        if (this.memorybuflist != null) {
            do {
                if (null == this.currentMemoryBuf) {
                    this.currentMemoryBuf = new byte[32768];
                    this.currentMemoryBufSz = 0;
                    this.memorybuflist.add(this.currentMemoryBuf);
                }
                int n4 = Math.min(n2 - n3, this.currentMemoryBuf.length - this.currentMemoryBufSz);
                System.arraycopy(byArray, n3, this.currentMemoryBuf, this.currentMemoryBufSz, n4);
                this.currentMemoryBufSz += n4;
                if ((n3 += n4) >= n2) continue;
                this.currentMemoryBuf = new byte[32768];
                this.currentMemoryBufSz = 0;
                this.memorybuflist.add(this.currentMemoryBuf);
            } while (n3 < n2);
        }
        if (null != this.cachediskstream) {
            this.cachediskstream.write(byArray, 0, n);
        }
        this.totalsz += (long)n2;
    }

    protected synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (null != this.cachediskstream) {
                this.cachediskstream.close();
                this.cachediskstream = null;
            }
            if (null != this.memorybuflist) {
                if (this.currentMemoryBufSz > 0) {
                    byte[] byArray = new byte[this.currentMemoryBufSz];
                    System.arraycopy(this.currentMemoryBuf, 0, byArray, 0, this.currentMemoryBufSz);
                    this.memorybuflist.set(this.memorybuflist.size() - 1, byArray);
                }
                this.currentMemoryBuf = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (null != this.cachediskstream) {
            this.cachediskstream.close();
            this.cachediskstream = null;
        }
    }

    protected void flushToDisk() throws IOException, FileNotFoundException {
        LinkedList linkedList = this.memorybuflist;
        log.debug(Messages.getMessage("maxCached", "" + this.maxCached, "" + this.totalsz));
        if (linkedList != null && null == this.cachediskstream) {
            try {
                MessageContext messageContext = MessageContext.getCurrentContext();
                String string = messageContext == null ? null : messageContext.getStrProp("attachments.directory");
                this.diskCacheFile = File.createTempFile("Axis", ".att", string == null ? null : new File(string));
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("diskCache", this.diskCacheFile.getAbsolutePath()));
                }
                this.cachediskstream = new BufferedOutputStream(new FileOutputStream(this.diskCacheFile));
                int n = linkedList.size();
                for (byte[] byArray : linkedList) {
                    int n2 = n-- == 0 ? this.currentMemoryBufSz : byArray.length;
                    this.cachediskstream.write(byArray, 0, n2);
                    if (!this.closed) continue;
                    this.cachediskstream.close();
                    this.cachediskstream = null;
                }
                this.memorybuflist = null;
            }
            catch (SecurityException securityException) {
                this.diskCacheFile = null;
                this.cachediskstream = null;
                this.maxCached = Integer.MAX_VALUE;
                log.info(Messages.getMessage("nodisk00"), securityException);
            }
        }
    }

    public synchronized boolean delete() {
        boolean bl = false;
        this.deleted = true;
        this.memorybuflist = null;
        if (this.diskCacheFile != null) {
            if (this.cachediskstream != null) {
                try {
                    this.cachediskstream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cachediskstream = null;
            }
            Object[] objectArray = this.readers.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Instream instream = (Instream)objectArray[i];
                if (null == instream) continue;
                try {
                    instream.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.readers.clear();
            try {
                this.diskCacheFile.delete();
                bl = true;
            }
            catch (Exception exception) {
                this.diskCacheFile.deleteOnExit();
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            FileInputStream fileInputStream = new FileInputStream(string);
            ManagedMemoryDataSource managedMemoryDataSource = new ManagedMemoryDataSource(fileInputStream, 0x100000, "foo/data", true);
            DataHandler dataHandler = new DataHandler(managedMemoryDataSource);
            InputStream inputStream = dataHandler.getInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[512];
            int n = 0;
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                fileOutputStream.write(byArray, 0, n);
            } while (n > -1);
            fileOutputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
        }
    }

    public File getDiskCacheFile() {
        return this.diskCacheFile;
    }

    private class Instream
    extends InputStream {
        protected int bread = 0;
        FileInputStream fin = null;
        int currentIndex = 0;
        byte[] currentBuf = null;
        int currentBufPos = 0;
        boolean readClosed = false;

        protected Instream() throws IOException {
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            ManagedMemoryDataSource.this.readers.put(this, null);
        }

        public int available() throws IOException {
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            int n = new Long(ManagedMemoryDataSource.this.totalsz - (long)this.bread).intValue();
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("available() = " + n + ".");
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                byte[] byArray = new byte[1];
                int n = this.read(byArray, 0, 1);
                if (n == -1) {
                    return -1;
                }
                return 0xFF & byArray[0];
            }
        }

        public boolean markSupported() {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("markSupported() = false.");
            }
            return false;
        }

        public void mark(int n) {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("mark()");
            }
        }

        public void reset() throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("reset()");
            }
            throw new IOException(Messages.getMessage("noResetMark"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long l) throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("skip(" + l + ").");
            }
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            if (l < 1L) {
                return 0L;
            }
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                l = Math.min(l, ManagedMemoryDataSource.this.totalsz - (long)this.bread);
                if (l == 0L) {
                    return 0L;
                }
                LinkedList linkedList = ManagedMemoryDataSource.this.memorybuflist;
                int n = 0;
                if (linkedList != null) {
                    if (null == this.currentBuf) {
                        this.currentBuf = (byte[])linkedList.get(this.currentIndex);
                        this.currentBufPos = 0;
                    }
                    do {
                        long l2 = Math.min((long)(this.currentBuf.length - this.currentBufPos), l - (long)n);
                        n = (int)((long)n + l2);
                        this.currentBufPos = (int)((long)this.currentBufPos + l2);
                        if ((long)n >= l) continue;
                        this.currentBuf = (byte[])linkedList.get(++this.currentIndex);
                        this.currentBufPos = 0;
                    } while ((long)n < l);
                }
                if (null != this.fin) {
                    this.fin.skip(l);
                }
                this.bread = (int)((long)this.bread + l);
            }
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("skipped " + l + ".");
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug(this.hashCode() + " read(" + n + ", " + n2 + ")");
            }
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            if (byArray == null) {
                throw new InternalException(Messages.getMessage("nullInput"));
            }
            if (n < 0) {
                throw new IndexOutOfBoundsException(Messages.getMessage("negOffset", "" + n));
            }
            if (n2 < 0) {
                throw new IndexOutOfBoundsException(Messages.getMessage("length", "" + n2));
            }
            if (n2 + n > byArray.length) {
                throw new IndexOutOfBoundsException(Messages.getMessage("writeBeyond"));
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                if ((long)this.bread == ManagedMemoryDataSource.this.totalsz) {
                    return -1;
                }
                LinkedList linkedList = ManagedMemoryDataSource.this.memorybuflist;
                long l = n2;
                l = Math.min(l, ManagedMemoryDataSource.this.totalsz - (long)this.bread);
                n2 = new Long(l).intValue();
                if (ManagedMemoryDataSource.this.debugEnabled) {
                    is_log.debug("len = " + n2);
                }
                if (linkedList != null) {
                    if (null == this.currentBuf) {
                        this.currentBuf = (byte[])linkedList.get(this.currentIndex);
                        this.currentBufPos = 0;
                    }
                    do {
                        int n4 = Math.min(this.currentBuf.length - this.currentBufPos, n2 - n3);
                        System.arraycopy(this.currentBuf, this.currentBufPos, byArray, n + n3, n4);
                        this.currentBufPos += n4;
                        if ((n3 += n4) >= n2) continue;
                        this.currentBuf = (byte[])linkedList.get(++this.currentIndex);
                        this.currentBufPos = 0;
                    } while (n3 < n2);
                }
                if (n3 == 0 && null != ManagedMemoryDataSource.this.diskCacheFile) {
                    if (ManagedMemoryDataSource.this.debugEnabled) {
                        is_log.debug(Messages.getMessage("reading", "" + n2));
                    }
                    if (null == this.fin) {
                        if (ManagedMemoryDataSource.this.debugEnabled) {
                            is_log.debug(Messages.getMessage("openBread", ManagedMemoryDataSource.this.diskCacheFile.getCanonicalPath()));
                        }
                        if (ManagedMemoryDataSource.this.debugEnabled) {
                            is_log.debug(Messages.getMessage("openBread", "" + this.bread));
                        }
                        this.fin = new FileInputStream(ManagedMemoryDataSource.this.diskCacheFile);
                        if (this.bread > 0) {
                            this.fin.skip(this.bread);
                        }
                    }
                    if (ManagedMemoryDataSource.this.cachediskstream != null) {
                        if (ManagedMemoryDataSource.this.debugEnabled) {
                            is_log.debug(Messages.getMessage("flushing"));
                        }
                        ManagedMemoryDataSource.this.cachediskstream.flush();
                    }
                    if (ManagedMemoryDataSource.this.debugEnabled) {
                        is_log.debug(Messages.getMessage("flushing"));
                        is_log.debug("len=" + n2);
                        is_log.debug("off=" + n);
                        is_log.debug("b.length=" + byArray.length);
                    }
                    n3 = this.fin.read(byArray, n, n2);
                }
                if (n3 > 0) {
                    this.bread += n3;
                }
            }
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug(this.hashCode() + Messages.getMessage("read", "" + n3));
            }
            return n3;
        }

        public synchronized void close() throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("close()");
            }
            if (!this.readClosed) {
                ManagedMemoryDataSource.this.readers.remove(this);
                this.readClosed = true;
                if (this.fin != null) {
                    this.fin.close();
                }
                this.fin = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

