/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Service;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.handlers.HandlerInfoChainFactory;
import org.apache.axis.handlers.soap.MustUnderstandChecker;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class AxisClient
extends AxisEngine {
    protected static Log log = LogFactory.getLog(AxisClient.class.getName());
    MustUnderstandChecker checker = new MustUnderstandChecker(null);

    public AxisClient(EngineConfiguration engineConfiguration) {
        super(engineConfiguration);
    }

    public AxisClient() {
        this(EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig());
    }

    public AxisEngine getClientEngine() {
        return this;
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        block29: {
            if (log.isDebugEnabled()) {
                log.debug("Enter: AxisClient::invoke");
            }
            String string = null;
            Handler handler = null;
            HandlerChain handlerChain = null;
            MessageContext messageContext2 = AxisClient.getCurrentMessageContext();
            try {
                AxisClient.setCurrentMessageContext(messageContext);
                string = messageContext.getStrProp("engine.handler");
                if (log.isDebugEnabled()) {
                    log.debug("EngineHandler: " + string);
                }
                if (string != null) {
                    handler = this.getHandler(string);
                    if (handler != null) {
                        handler.invoke(messageContext);
                        break block29;
                    }
                    throw new AxisFault("Client.error", Messages.getMessage("noHandler00", string), null, null);
                }
                SOAPService sOAPService = null;
                messageContext.setPastPivot(false);
                sOAPService = messageContext.getService();
                if (sOAPService != null && (handler = sOAPService.getRequestHandler()) != null) {
                    handler.invoke(messageContext);
                }
                if ((handler = this.getGlobalRequest()) != null) {
                    handler.invoke(messageContext);
                }
                if ((handlerChain = this.getJAXRPChandlerChain(messageContext)) != null) {
                    try {
                        if (!handlerChain.handleRequest(messageContext)) {
                            messageContext.setPastPivot(true);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        handlerChain.destroy();
                        throw runtimeException;
                    }
                }
                if (!messageContext.getPastPivot()) {
                    string = messageContext.getTransportName();
                    if (string != null && (handler = this.getTransport(string)) != null) {
                        handler.invoke(messageContext);
                    } else {
                        throw new AxisFault(Messages.getMessage("noTransport00", string));
                    }
                }
                messageContext.setPastPivot(true);
                if (messageContext.isPropertyTrue("axis.one.way")) break block29;
                if (handlerChain != null && !messageContext.isPropertyTrue("axis.one.way")) {
                    try {
                        handlerChain.handleResponse(messageContext);
                    }
                    catch (RuntimeException runtimeException) {
                        handlerChain.destroy();
                        throw runtimeException;
                    }
                }
                if ((handler = this.getGlobalResponse()) != null) {
                    handler.invoke(messageContext);
                }
                if (sOAPService != null && (handler = sOAPService.getResponseHandler()) != null) {
                    handler.invoke(messageContext);
                }
                if (messageContext.isPropertyTrue("call.CheckMustUnderstand", true)) {
                    this.checker.invoke(messageContext);
                }
            }
            catch (Exception exception) {
                if (exception instanceof AxisFault) {
                    throw (AxisFault)exception;
                }
                log.debug(Messages.getMessage("exception00"), exception);
                throw AxisFault.makeFault(exception);
            }
            finally {
                if (handlerChain != null) {
                    handlerChain.destroy();
                }
                AxisClient.setCurrentMessageContext(messageContext2);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: AxisClient::invoke");
        }
    }

    protected HandlerChain getJAXRPChandlerChain(MessageContext messageContext) {
        SOAPService sOAPService;
        List list = null;
        HandlerInfoChainFactory handlerInfoChainFactory = null;
        boolean bl = false;
        Service service = (Service)messageContext.getProperty("wsdl.service");
        if (service == null) {
            return null;
        }
        QName qName = (QName)messageContext.getProperty("wsdl.portName");
        if (qName == null) {
            return null;
        }
        HandlerRegistry handlerRegistry = service.getHandlerRegistry();
        if (handlerRegistry != null && (list = handlerRegistry.getHandlerChain(qName)) != null && !list.isEmpty()) {
            handlerInfoChainFactory = new HandlerInfoChainFactory(list);
            bl = true;
        }
        if (!bl && (sOAPService = messageContext.getService()) != null) {
            handlerInfoChainFactory = (HandlerInfoChainFactory)sOAPService.getOption("handlerInfoChain");
        }
        if (handlerInfoChainFactory == null) {
            return null;
        }
        return handlerInfoChainFactory.createHandlerChain();
    }
}

