/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;

public class HappyClient {
    PrintStream out;

    public HappyClient(PrintStream printStream) {
        this.out = printStream;
    }

    Class classExists(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    boolean resourceExists(String string) {
        boolean bl;
        InputStream inputStream = ClassUtils.getResourceAsStream(this.getClass(), string);
        boolean bl2 = bl = inputStream != null;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    int probeClass(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        String string7 = "";
        if (string6 != null) {
            string7 = Messages.getMessage("happyClientHomepage", string6);
        }
        String string8 = "";
        if (string5 != null) {
            string8 = Messages.getMessage(string5);
        }
        try {
            Class clazz = this.classExists(string2);
            if (clazz == null) {
                String string9 = Messages.getMessage("happyClientMissingClass", string, string2, string3);
                this.out.println(string9);
                this.out.println(string7);
                return 1;
            }
            String string10 = this.getLocation(clazz);
            String string11 = string10 == null ? Messages.getMessage("happyClientFoundDescriptionClass", string4, string2) : Messages.getMessage("happyClientFoundDescriptionClassLocation", string4, string2, string10);
            this.out.println(string11);
            return 0;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.out.println(Messages.getMessage("happyClientNoDependency", string, string2, string3));
            this.out.println(string8);
            this.out.println(string7);
            this.out.println(noClassDefFoundError.getMessage());
            return 1;
        }
    }

    String getLocation(Class clazz) {
        try {
            URL uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
            String string = uRL.toString();
            if (string.startsWith("jar")) {
                uRL = ((JarURLConnection)uRL.openConnection()).getJarFileURL();
                string = uRL.toString();
            }
            if (string.startsWith("file")) {
                File file = new File(uRL.getFile());
                return file.getAbsolutePath();
            }
            return uRL.toString();
        }
        catch (Throwable throwable) {
            return Messages.getMessage("happyClientUnknownLocation");
        }
    }

    int needClass(String string, String string2, String string3, String string4, String string5) throws IOException {
        return this.probeClass(Messages.getMessage("happyClientError"), string, string2, string3, string4, string5);
    }

    int wantClass(String string, String string2, String string3, String string4, String string5) throws IOException {
        return this.probeClass(Messages.getMessage("happyClientWarning"), string, string2, string3, string4, string5);
    }

    int wantResource(String string, String string2) throws Exception {
        if (!this.resourceExists(string)) {
            this.out.println(Messages.getMessage("happyClientNoResource", string));
            this.out.println(string2);
            return 0;
        }
        this.out.println(Messages.getMessage("happyClientFoundResource", string));
        return 1;
    }

    private String getParserName() {
        SAXParser sAXParser = this.getSAXParser();
        if (sAXParser == null) {
            return Messages.getMessage("happyClientNoParser");
        }
        String string = sAXParser.getClass().getName();
        return string;
    }

    private SAXParser getSAXParser() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        if (sAXParserFactory == null) {
            return null;
        }
        SAXParser sAXParser = null;
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sAXParser;
    }

    private String getParserLocation() {
        SAXParser sAXParser = this.getSAXParser();
        if (sAXParser == null) {
            return null;
        }
        String string = this.getLocation(sAXParser.getClass());
        return string;
    }

    public int getJavaVersionNumber() {
        int n = 10;
        try {
            Class.forName("java.lang.Void");
            ++n;
            Class.forName("java.lang.ThreadLocal");
            ++n;
            Class.forName("java.lang.StrictMath");
            ++n;
            Class.forName("java.lang.CharSequence");
            ++n;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    private void title(String string) {
        this.out.println();
        String string2 = Messages.getMessage(string);
        this.out.println(string2);
        for (int i = 0; i < string2.length(); ++i) {
            this.out.print("=");
        }
        this.out.println();
    }

    public boolean verifyClientIsHappy(boolean bl) throws IOException {
        boolean bl2;
        int n = 0;
        int n2 = 0;
        this.out.println();
        this.title("happyClientTitle");
        this.title("happyClientNeeded");
        n = this.needClass("javax.xml.soap.SOAPMessage", "saaj.jar", "SAAJ", "happyClientNoAxis", "http://xml.apache.org/axis/");
        n += this.needClass("javax.xml.rpc.Service", "jaxrpc.jar", "JAX-RPC", "happyClientNoAxis", "http://xml.apache.org/axis/");
        n += this.needClass("org.apache.commons.discovery.Resource", "commons-discovery.jar", "Jakarta-Commons Discovery", "happyClientNoAxis", "http://jakarta.apache.org/commons/discovery.html");
        n += this.needClass("org.apache.commons.logging.Log", "commons-logging.jar", "Jakarta-Commons Logging", "happyClientNoAxis", "http://jakarta.apache.org/commons/logging.html");
        n += this.needClass("org.apache.log4j.Layout", "log4j-1.2.4.jar", "Log4j", "happyClientNoLog4J", "http://jakarta.apache.org/log4j");
        n += this.needClass("com.ibm.wsdl.factory.WSDLFactoryImpl", "wsdl4j.jar", "WSDL4Java", "happyClientNoAxis", null);
        n += this.needClass("javax.xml.parsers.SAXParserFactory", "xerces.jar", "JAXP", "happyClientNoAxis", "http://xml.apache.org/xerces-j/");
        this.title("happyClientOptional");
        n2 += this.wantClass("javax.mail.internet.MimeMessage", "mail.jar", "Mail", "happyClientNoAttachments", "http://java.sun.com/products/javamail/");
        n2 += this.wantClass("javax.activation.DataHandler", "activation.jar", "Activation", "happyClientNoAttachments", "http://java.sun.com/products/javabeans/glasgow/jaf.html");
        n2 += this.wantClass("org.apache.xml.security.Init", "xmlsec.jar", "XML Security", "happyClientNoSecurity", "http://xml.apache.org/security/");
        n2 += this.wantClass("javax.net.ssl.SSLSocketFactory", Messages.getMessage("happyClientJSSEsources"), "Java Secure Socket Extension", "happyClientNoHTTPS", "http://java.sun.com/products/jsse/");
        int n3 = 0;
        String string = this.getParserName();
        String string2 = this.getParserLocation();
        this.out.println(Messages.getMessage("happyClientXMLinfo", string, string2));
        if (string.indexOf("xerces") <= 0) {
            ++n3;
            this.out.println();
            this.out.println(Messages.getMessage("happyClientRecommendXerces"));
        }
        if (this.getJavaVersionNumber() < 13) {
            ++n3;
            this.out.println();
            this.out.println(Messages.getMessage("happyClientUnsupportedJVM"));
        }
        this.title("happyClientSummary");
        if (n == 0) {
            this.out.println(Messages.getMessage("happyClientCorePresent"));
            bl2 = true;
        } else {
            bl2 = false;
            this.out.println(Messages.getMessage("happyClientCoreMissing", Integer.toString(n)));
        }
        if (n2 > 0) {
            this.out.println();
            this.out.println(Messages.getMessage("happyClientOptionalMissing", Integer.toString(n2)));
            this.out.println(Messages.getMessage("happyClientOptionalOK"));
            if (bl) {
                bl2 = false;
            }
        } else {
            this.out.println(Messages.getMessage("happyClientOptionalPresent"));
        }
        if (n3 > 0) {
            this.out.println(Messages.getMessage("happyClientWarningMessageCount", Integer.toString(n3)));
            if (bl) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        boolean bl = HappyClient.isClientHappy(stringArray);
        System.exit(bl ? 0 : -1);
    }

    private static boolean isClientHappy(String[] stringArray) {
        boolean bl;
        HappyClient happyClient = new HappyClient(System.out);
        int n = 0;
        try {
            bl = happyClient.verifyClientIsHappy(false);
            for (int i = 0; i < stringArray.length; ++i) {
                n += happyClient.probeClass("argument", stringArray[i], null, null, null, null);
            }
            if (n > 0) {
                bl = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }
}

